/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints;

import de.lmu.ifi.dbs.elki.utilities.optionhandling.ParameterException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.WrongParameterValueException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import java.util.Arrays;

public class EqualStringConstraint
implements ParameterConstraint<String> {
    private String[] testStrings;

    public EqualStringConstraint(String[] stringArray) {
        this.testStrings = stringArray;
    }

    private String constraintStrings() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        for (int i = 0; i < this.testStrings.length; ++i) {
            stringBuilder.append(this.testStrings[i]);
            if (i == this.testStrings.length - 1) continue;
            stringBuilder.append(',');
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public void test(String string) throws ParameterException {
        for (String string2 : this.testStrings) {
            if (!string.equalsIgnoreCase(string2)) continue;
            return;
        }
        throw new WrongParameterValueException("Parameter Constraint Error.\nParameter value must be one of the following values: " + this.constraintStrings());
    }

    @Override
    public String getDescription(String string) {
        return string + " in " + Arrays.asList(this.testStrings).toString();
    }
}

