/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters;

import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.ParameterException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.WrongParameterValueException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.AbstractParameter;

public class Flag
extends AbstractParameter<Flag, Boolean> {
    public static final String SET = "true";
    public static final String NOT_SET = "false";

    public Flag(OptionID optionID) {
        super(optionID);
        this.setOptional(true);
        this.setDefaultValue(Boolean.FALSE);
    }

    @Override
    protected Boolean parseValue(Object object) throws ParameterException {
        if (SET.equals(object)) {
            return Boolean.TRUE;
        }
        if (NOT_SET.equals(object)) {
            return Boolean.FALSE;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object != null && SET.equals(object.toString())) {
            return Boolean.TRUE;
        }
        if (object != null && NOT_SET.equals(object.toString())) {
            return Boolean.FALSE;
        }
        throw new WrongParameterValueException("Wrong value for flag \"" + this.getName() + "\". Allowed values:\n" + SET + " or " + NOT_SET);
    }

    @Override
    public String getSyntax() {
        return "<|true|false>";
    }

    @Override
    public String getValueAsString() {
        return (Boolean)this.getValue() != false ? SET : NOT_SET;
    }

    @Override
    protected boolean validate(Boolean bl) throws ParameterException {
        if (bl == null) {
            throw new WrongParameterValueException("Boolean option '" + this.getName() + "' got 'null' value.");
        }
        return true;
    }

    public void setValue(boolean bl) {
        try {
            super.setValue(bl);
        }
        catch (ParameterException parameterException) {
            throw new AbortException("Flag did not accept boolean value!", parameterException);
        }
    }

    public boolean isTrue() {
        return this.isDefined() && (Boolean)this.getValue() != false;
    }

    public boolean isFalse() {
        return this.isDefined() && (Boolean)this.getValue() == false;
    }
}

