/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.gui;

import de.lmu.ifi.dbs.elki.KDDTask;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultHierarchy;
import de.lmu.ifi.dbs.elki.result.ResultListener;
import de.lmu.ifi.dbs.elki.utilities.datastructures.hierarchy.HashMapHierarchy;
import de.lmu.ifi.dbs.elki.utilities.datastructures.hierarchy.Hierarchy;
import de.lmu.ifi.dbs.elki.visualization.VisualizationItem;
import de.lmu.ifi.dbs.elki.visualization.VisualizationListener;
import de.lmu.ifi.dbs.elki.visualization.VisualizationMenuAction;
import de.lmu.ifi.dbs.elki.visualization.VisualizationMenuToggle;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.batikutil.JSVGSynchronizedCanvas;
import de.lmu.ifi.dbs.elki.visualization.batikutil.LazyCanvasResizer;
import de.lmu.ifi.dbs.elki.visualization.gui.SelectionTableWindow;
import de.lmu.ifi.dbs.elki.visualization.gui.detail.DetailView;
import de.lmu.ifi.dbs.elki.visualization.gui.overview.DetailViewSelectedEvent;
import de.lmu.ifi.dbs.elki.visualization.gui.overview.OverviewPlot;
import de.lmu.ifi.dbs.elki.visualization.gui.overview.PlotItem;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.savedialog.SVGSaveDialog;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;
import org.apache.batik.swing.svg.GVTTreeBuilderAdapter;
import org.apache.batik.swing.svg.GVTTreeBuilderEvent;

public class ResultWindow
extends JFrame
implements ResultListener,
VisualizationListener {
    private static final long serialVersionUID = 1L;
    private static final Logging LOG = Logging.getLogger(ResultWindow.class);
    private DynamicMenu menubar;
    private JSVGSynchronizedCanvas svgCanvas;
    private OverviewPlot overview;
    protected VisualizerContext context;
    private DetailView currentSubplot = null;
    private boolean single = false;

    public ResultWindow(String string, VisualizerContext visualizerContext, boolean bl) {
        super(string);
        this.context = visualizerContext;
        this.single = bl;
        this.setDefaultCloseOperation(2);
        try {
            this.setIconImage(new ImageIcon(KDDTask.class.getResource("elki-icon.png")).getImage());
        }
        catch (Exception exception) {
            // empty catch block
        }
        JPanel jPanel = new JPanel(new BorderLayout());
        this.menubar = new DynamicMenu();
        jPanel.add("North", this.menubar.getMenuBar());
        this.svgCanvas = new JSVGSynchronizedCanvas();
        jPanel.add("Center", this.svgCanvas);
        this.getContentPane().add(jPanel);
        this.overview = new OverviewPlot(visualizerContext, bl);
        this.overview.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent instanceof DetailViewSelectedEvent) {
                    ResultWindow.this.showSubplot((DetailViewSelectedEvent)actionEvent);
                }
                if ("Overview refreshing" == actionEvent.getActionCommand() && ResultWindow.this.currentSubplot == null) {
                    ResultWindow.this.showPlot(null);
                }
                if ("Overview refreshed" == actionEvent.getActionCommand() && ResultWindow.this.currentSubplot == null) {
                    ResultWindow.this.showOverview();
                }
            }
        });
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.overview.screenwidth = dimension.width;
        this.overview.screenheight = dimension.height;
        this.setSize(dimension.width - 50, dimension.height - 50);
        this.setExtendedState(6);
        LazyCanvasResizer lazyCanvasResizer = new LazyCanvasResizer(this, 0.1){

            @Override
            public void executeResize(double d) {
                ResultWindow.this.handleResize(d);
            }
        };
        this.addComponentListener(lazyCanvasResizer);
        this.svgCanvas.addGVTTreeBuilderListener(new GVTTreeBuilderAdapter(){

            @Override
            public void gvtBuildCompleted(GVTTreeBuilderEvent gVTTreeBuilderEvent) {
                ResultWindow.this.menubar.updateVisualizerMenus();
            }
        });
        visualizerContext.addResultListener(this);
        visualizerContext.addVisualizationListener(this);
        this.overview.initialize(lazyCanvasResizer.getCurrentRatio());
    }

    @Override
    public void dispose() {
        this.context.removeResultListener(this);
        this.context.removeVisualizationListener(this);
        this.svgCanvas.setPlot(null);
        this.overview.destroy();
        if (this.currentSubplot != null) {
            this.currentSubplot.dispose();
            this.currentSubplot = null;
        }
        super.dispose();
    }

    protected void close() {
        this.setVisible(false);
        this.dispose();
    }

    public void showOverview() {
        if (this.currentSubplot != null) {
            this.currentSubplot.destroy();
        }
        this.currentSubplot = null;
        this.showPlot(this.overview.getPlot());
    }

    protected void showSubplot(DetailViewSelectedEvent detailViewSelectedEvent) {
        if (!this.single) {
            this.currentSubplot = detailViewSelectedEvent.makeDetailView();
            this.showPlot(this.currentSubplot);
        }
    }

    private void showPlot(SVGPlot sVGPlot) {
        if (this.svgCanvas.getPlot() instanceof DetailView) {
            ((DetailView)this.svgCanvas.getPlot()).destroy();
        }
        this.svgCanvas.setPlot(sVGPlot);
        this.menubar.enableOverview(sVGPlot != this.overview.getPlot());
        this.menubar.enableExport(sVGPlot != null);
        this.updateVisualizerMenus();
    }

    protected void saveCurrentPlot() {
        SVGPlot sVGPlot = this.svgCanvas.getPlot();
        if (sVGPlot == null) {
            LOG.warning("saveCurrentPlot() called without a visible plot!");
            return;
        }
        SVGSaveDialog.showSaveDialog(sVGPlot, 512, 512);
    }

    protected void showTableView() {
        new SelectionTableWindow(this.context).setVisible(true);
    }

    protected void update() {
        this.updateVisualizerMenus();
        if (this.currentSubplot != null) {
            this.showPlot(this.currentSubplot);
        }
        this.overview.lazyRefresh();
    }

    protected void handleResize(double d) {
        if (this.currentSubplot == null) {
            this.overview.setRatio(d);
        }
    }

    @Override
    public void resultAdded(Result result, Result result2) {
        this.updateVisualizerMenus();
    }

    @Override
    public void resultChanged(Result result) {
        this.updateVisualizerMenus();
    }

    @Override
    public void resultRemoved(Result result, Result result2) {
        this.updateVisualizerMenus();
    }

    @Override
    public void visualizationChanged(VisualizationItem visualizationItem) {
        this.updateVisualizerMenus();
    }

    private void updateVisualizerMenus() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ResultWindow.this.menubar.updateVisualizerMenus();
            }
        });
    }

    public class DynamicMenu {
        private JMenuBar menubar = new JMenuBar();
        private JMenu filemenu = new JMenu("File");
        private JMenuItem overviewItem;
        private JMenuItem quitItem;
        private JMenuItem exportItem;
        private JMenuItem editItem;
        private JMenu visualizersMenu;
        protected boolean simplify = true;

        public DynamicMenu() {
            this.filemenu.setMnemonic(70);
            if (!ResultWindow.this.single) {
                this.overviewItem = new JMenuItem("Open Overview");
                this.overviewItem.setMnemonic(79);
                this.overviewItem.setEnabled(false);
                this.overviewItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        ResultWindow.this.showOverview();
                    }
                });
                this.filemenu.add(this.overviewItem);
            }
            this.exportItem = new JMenuItem("Export Plot");
            this.exportItem.setMnemonic(69);
            this.exportItem.setEnabled(false);
            this.exportItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ResultWindow.this.saveCurrentPlot();
                }
            });
            this.filemenu.add(this.exportItem);
            this.editItem = new JMenuItem("Table View/Edit");
            this.editItem.setMnemonic(84);
            this.editItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ResultWindow.this.showTableView();
                }
            });
            this.quitItem = new JMenuItem("Quit");
            this.quitItem.setMnemonic(81);
            this.quitItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ResultWindow.this.close();
                }
            });
            this.filemenu.add(this.quitItem);
            this.menubar.add(this.filemenu);
            this.visualizersMenu = new JMenu("Visualizers");
            this.visualizersMenu.setMnemonic(86);
            this.menubar.add(this.visualizersMenu);
        }

        protected synchronized void updateVisualizerMenus() {
            Object object;
            Object object2;
            Projection projection = null;
            if (ResultWindow.this.svgCanvas.getPlot() instanceof DetailView) {
                object2 = ((DetailView)ResultWindow.this.svgCanvas.getPlot()).getPlotItem();
                projection = ((PlotItem)object2).proj;
            }
            this.menubar.removeAll();
            this.menubar.add(this.filemenu);
            object2 = ResultWindow.this.context.getHierarchy();
            VisualizationTree visualizationTree = ResultWindow.this.context.getVisHierarchy();
            Result result = ResultWindow.this.context.getBaseResult();
            ArrayList<JMenuItem> arrayList = new ArrayList<JMenuItem>();
            if (result == null) {
                object = ((HashMapHierarchy)object2).iterAll();
                while (object.valid()) {
                    if (((HashMapHierarchy)object2).numParents(object.get()) == 0) {
                        this.recursiveBuildMenu(arrayList, object.get(), (ResultHierarchy)object2, visualizationTree, projection);
                    }
                    object.advance();
                }
            } else {
                object = ((HashMapHierarchy)object2).iterChildren(result);
                while (object.valid()) {
                    this.recursiveBuildMenu(arrayList, object.get(), (ResultHierarchy)object2, visualizationTree, projection);
                    object.advance();
                }
            }
            for (JMenuItem jMenuItem : arrayList) {
                this.menubar.add(jMenuItem);
            }
            this.menubar.revalidate();
            this.menubar.repaint();
        }

        private void recursiveBuildMenu(Collection<JMenuItem> collection, Object object, ResultHierarchy resultHierarchy, Hierarchy<Object> hierarchy, Projection projection) {
            JMenuItem jMenuItem;
            Object object2;
            String string;
            if (object instanceof Result) {
                string = ((Result)object).getLongName();
            } else if (object instanceof VisualizationItem) {
                string = ((VisualizationItem)object).getMenuName();
            } else {
                return;
            }
            ArrayList<JMenuItem> arrayList = new ArrayList<JMenuItem>();
            if (object instanceof Result) {
                object2 = resultHierarchy.iterChildren((Result)object);
                while (object2.valid()) {
                    this.recursiveBuildMenu(arrayList, object2.get(), resultHierarchy, hierarchy, projection);
                    object2.advance();
                }
            }
            object2 = hierarchy.iterChildren(object);
            while (object2.valid()) {
                this.recursiveBuildMenu(arrayList, object2.get(), resultHierarchy, hierarchy, projection);
                object2.advance();
            }
            object2 = null;
            if (projection == null) {
                object2 = this.makeMenuItemForVisualizer(object);
            } else {
                Hierarchy.Iter<Object> iter = hierarchy.iterAncestorsSelf(object);
                while (iter.valid()) {
                    if (iter.get() == projection.getProjector()) {
                        object2 = this.makeMenuItemForVisualizer(object);
                        break;
                    }
                    iter.advance();
                }
            }
            int n = arrayList.size();
            if (n == 0) {
                if (object2 != null) {
                    collection.add((JMenuItem)object2);
                }
                return;
            }
            if (this.simplify && n == 1 && (jMenuItem = arrayList.get(0)) instanceof JMenu) {
                if (string != null) {
                    jMenuItem.setText(string + " " + jMenuItem.getText());
                }
                collection.add(jMenuItem);
                return;
            }
            jMenuItem = new JMenu(string != null ? string : "unnamed");
            if (object2 != null) {
                ((JMenu)jMenuItem).add((JMenuItem)object2);
            }
            for (JMenuItem jMenuItem2 : arrayList) {
                ((JMenu)jMenuItem).add(jMenuItem2);
            }
            collection.add(jMenuItem);
        }

        private JMenuItem makeMenuItemForVisualizer(Object object) {
            JMenuItem jMenuItem;
            if (object instanceof VisualizationMenuAction) {
                final VisualizationMenuAction visualizationMenuAction = (VisualizationMenuAction)object;
                JMenuItem jMenuItem2 = new JMenuItem(visualizationMenuAction.getMenuName());
                jMenuItem2.setEnabled(visualizationMenuAction.enabled());
                jMenuItem2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        visualizationMenuAction.activate();
                    }
                });
                return jMenuItem2;
            }
            if (object instanceof VisualizationMenuToggle) {
                final VisualizationMenuToggle visualizationMenuToggle = (VisualizationMenuToggle)object;
                JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(visualizationMenuToggle.getMenuName(), visualizationMenuToggle.active());
                jCheckBoxMenuItem.setEnabled(visualizationMenuToggle.enabled());
                jCheckBoxMenuItem.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent itemEvent) {
                        visualizationMenuToggle.toggle();
                    }
                });
                return jCheckBoxMenuItem;
            }
            if (!(object instanceof VisualizationTask)) {
                return null;
            }
            final VisualizationTask visualizationTask = (VisualizationTask)object;
            String string = visualizationTask.getMenuName();
            boolean bl = visualizationTask.visible;
            boolean bl2 = visualizationTask.tool;
            if (!bl2) {
                final JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(string, bl);
                jCheckBoxMenuItem.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent itemEvent) {
                        VisualizationTree.setVisible(ResultWindow.this.context, visualizationTask, jCheckBoxMenuItem.getState());
                    }
                });
                jMenuItem = jCheckBoxMenuItem;
            } else {
                final JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(string, bl);
                jRadioButtonMenuItem.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent itemEvent) {
                        VisualizationTree.setVisible(ResultWindow.this.context, visualizationTask, jRadioButtonMenuItem.isSelected());
                    }
                });
                jMenuItem = jRadioButtonMenuItem;
            }
            return jMenuItem;
        }

        public JMenuBar getMenuBar() {
            return this.menubar;
        }

        public void enableOverview(boolean bl) {
            if (this.overviewItem != null) {
                this.overviewItem.setEnabled(bl);
            }
        }

        public void enableExport(boolean bl) {
            this.exportItem.setEnabled(bl);
        }
    }
}

