/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.style;

import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import de.lmu.ifi.dbs.elki.visualization.colors.ColorLibrary;
import de.lmu.ifi.dbs.elki.visualization.style.ClassStylingPolicy;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ClusterStylingPolicy
implements ClassStylingPolicy {
    ArrayList<DBIDs> ids;
    TObjectIntMap<Cluster<?>> cmap;
    TIntArrayList colors;
    Clustering<?> clustering;

    public ClusterStylingPolicy(Clustering<?> clustering, StyleLibrary styleLibrary) {
        this.clustering = clustering;
        ColorLibrary colorLibrary = styleLibrary.getColorSet("plot");
        List<Cluster<?>> list = clustering.getAllClusters();
        this.ids = new ArrayList(list.size());
        this.colors = new TIntArrayList(list.size());
        this.cmap = new TObjectIntHashMap(list.size(), 0.5f, -1);
        Iterator<Cluster<?>> iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Cluster<?> cluster = iterator.next();
            this.ids.add(DBIDUtil.ensureSet(cluster.getIDs()));
            this.cmap.put(cluster, n);
            Color color = SVGUtil.stringToColor(colorLibrary.getColor(n));
            if (color != null) {
                this.colors.add(color.getRGB());
            } else {
                LoggingUtil.warning("Unrecognized color name: " + colorLibrary.getColor(n));
            }
            if (!iterator.hasNext()) break;
            ++n;
        }
    }

    @Override
    public int getStyleForDBID(DBIDRef dBIDRef) {
        for (int i = 0; i < this.ids.size(); ++i) {
            if (!this.ids.get(i).contains(dBIDRef)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getColorForDBID(DBIDRef dBIDRef) {
        for (int i = 0; i < this.ids.size(); ++i) {
            if (!this.ids.get(i).contains(dBIDRef)) continue;
            return this.colors.get(i);
        }
        return 0;
    }

    @Override
    public int getMinStyle() {
        return 0;
    }

    @Override
    public int getMaxStyle() {
        return this.ids.size();
    }

    @Override
    public DBIDIter iterateClass(int n) {
        return this.ids.get(n).iter();
    }

    @Override
    public int classSize(int n) {
        return this.ids.get(n).size();
    }

    public Clustering<?> getClustering() {
        return this.clustering;
    }

    public int getStyleForCluster(Cluster<?> cluster) {
        return this.cmap.get(cluster);
    }

    @Override
    public String getMenuName() {
        return this.clustering.getLongName();
    }
}

