/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.egl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.antlr.runtime.ANTLRInputStream;
import org.antlr.runtime.Lexer;
import org.antlr.runtime.TokenStream;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.common.parse.EpsilonParser;
import org.eclipse.epsilon.common.util.AstUtil;
import org.eclipse.epsilon.egl.EglTemplate;
import org.eclipse.epsilon.egl.EglTemplateFactory;
import org.eclipse.epsilon.egl.GenerationRule;
import org.eclipse.epsilon.egl.exceptions.EglRuntimeException;
import org.eclipse.epsilon.egl.execute.context.EgxContext;
import org.eclipse.epsilon.egl.formatter.Formatter;
import org.eclipse.epsilon.egl.internal.EglResult;
import org.eclipse.epsilon.egl.internal.IEglModule;
import org.eclipse.epsilon.egl.parse.EgxLexer;
import org.eclipse.epsilon.egl.parse.EgxParser;
import org.eclipse.epsilon.egl.traceability.Content;
import org.eclipse.epsilon.egl.traceability.Template;
import org.eclipse.epsilon.eol.EolImport;
import org.eclipse.epsilon.eol.IEolExecutableModule;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.erl.ErlModule;
import org.eclipse.epsilon.erl.rules.INamedRule;
import org.eclipse.epsilon.erl.rules.NamedRules;

public class EgxModule
extends ErlModule
implements IEolExecutableModule,
IEglModule {
    protected NamedRules declaredGenerationRules = null;
    protected NamedRules generationRules = null;
    protected EgxContext context = null;
    protected EglTemplateFactory templateFactory = null;
    protected List<Content<Template>> invokedTemplates = new ArrayList<Content<Template>>();

    public static void main(String[] args) throws Exception {
        EgxModule module = new EgxModule(new EglTemplateFactory());
        module.parse("rule C2J transform c : EClass { target: 1+2+'c' pre {'pre'.println();'pre1'.println();}  post{'post'.println();} }");
        System.err.println(module.getParseProblems());
        module.execute();
    }

    public EgxModule() {
        this(new EglTemplateFactory());
    }

    public EgxModule(EglTemplateFactory templateFactory) {
        this.templateFactory = templateFactory;
        this.reset();
    }

    public EglTemplateFactory getTemplateFactory() {
        return this.templateFactory;
    }

    public List<Content<Template>> getInvokedTemplates() {
        return this.invokedTemplates;
    }

    @Override
    public Lexer createLexer(InputStream inputStream) {
        ANTLRInputStream input = null;
        try {
            input = new ANTLRInputStream(inputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new EgxLexer(input);
    }

    @Override
    public EpsilonParser createParser(TokenStream tokenStream) {
        return new EgxParser(tokenStream);
    }

    @Override
    public String getMainRule() {
        return "egxModule";
    }

    @Override
    public void buildModel() throws Exception {
        super.buildModel();
        for (AST generationRuleAst : AstUtil.getChildren(this.ast, 80)) {
            this.declaredGenerationRules.add(this.createGenerationRule(generationRuleAst));
        }
        this.getParseProblems().addAll(this.declaredGenerationRules.calculateSuperRules(this.getGenerationRules()));
    }

    protected GenerationRule createGenerationRule(AST generationRuleAst) {
        return new GenerationRule(generationRuleAst);
    }

    public NamedRules getDeclaredTransformRules() {
        return this.declaredGenerationRules;
    }

    @Override
    public boolean parse(File file) throws Exception {
        boolean result = super.parse(file);
        if (result) {
            this.templateFactory.initialiseRoot(file.getParentFile().toURI());
        }
        return result;
    }

    @Override
    public boolean parse(URI uri) throws Exception {
        boolean result = super.parse(uri);
        if (result) {
            this.templateFactory.initialiseRoot(uri);
        }
        return result;
    }

    @Override
    public boolean parse(String code, File file) throws Exception {
        boolean result = super.parse(code, file);
        if (result) {
            this.templateFactory.initialiseRoot(file.getParentFile().toURI());
        }
        return result;
    }

    @Override
    public Object execute() throws EolRuntimeException {
        this.context.setModule(this);
        this.context.copyInto(this.templateFactory.getContext(), true);
        this.execute(this.getPre(), this.context);
        for (INamedRule rule : this.getGenerationRules()) {
            ((GenerationRule)rule).generateAll(this.context, this.templateFactory, this);
        }
        this.execute(this.getPost(), this.context);
        return null;
    }

    @Override
    public HashMap<String, Class<?>> getImportConfiguration() {
        HashMap<String, Class<?>> importConfiguration = super.getImportConfiguration();
        importConfiguration.put("egx", EgxModule.class);
        return importConfiguration;
    }

    @Override
    public EgxContext getContext() {
        return this.context;
    }

    public void setContext(EgxContext context) {
        this.context = context;
    }

    @Override
    public List<ModuleElement> getChildren() {
        ArrayList<ModuleElement> children = new ArrayList<ModuleElement>();
        children.addAll(this.getImports());
        children.addAll(this.getDeclaredPre());
        children.addAll(this.declaredGenerationRules);
        children.addAll(this.getDeclaredPost());
        children.addAll(this.getDeclaredOperations());
        return children;
    }

    @Override
    public void reset() {
        super.reset();
        this.generationRules = null;
        this.declaredGenerationRules = new NamedRules();
        this.context = new EgxContext(this.templateFactory);
    }

    public NamedRules getGenerationRules() {
        if (this.generationRules == null) {
            this.generationRules = new NamedRules();
            for (EolImport import_ : this.imports) {
                if (!import_.isLoaded() || !(import_.getModule() instanceof EgxModule)) continue;
                EgxModule module = (EgxModule)import_.getModule();
                this.generationRules.addAll(module.getGenerationRules());
            }
            this.generationRules.addAll(this.declaredGenerationRules);
        }
        return this.generationRules;
    }

    @Override
    protected int getPostBlockTokenType() {
        return 77;
    }

    @Override
    protected int getPreBlockTokenType() {
        return 76;
    }

    @Override
    public EglResult execute(EglTemplate template, Formatter postprocessor) throws EglRuntimeException {
        System.err.println("EgxModule.execute() invoked");
        return null;
    }

    @Override
    public void setContext(IEolContext context) {
        if (context instanceof EgxContext) {
            this.context = (EgxContext)context;
        }
    }
}

