/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.egl.execute.context;

import java.io.PrintStream;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.epsilon.egl.EglTemplate;
import org.eclipse.epsilon.egl.EglTemplateFactory;
import org.eclipse.epsilon.egl.config.ContentTypeRepository;
import org.eclipse.epsilon.egl.config.XMLContentTypeRepository;
import org.eclipse.epsilon.egl.execute.EglExecutorFactory;
import org.eclipse.epsilon.egl.execute.EglOperationFactory;
import org.eclipse.epsilon.egl.execute.context.EglExecutionManager;
import org.eclipse.epsilon.egl.execute.context.EglFrameStackManager;
import org.eclipse.epsilon.egl.execute.context.ExecutableTemplateSpecification;
import org.eclipse.epsilon.egl.execute.context.IEglContext;
import org.eclipse.epsilon.egl.formatter.Formatter;
import org.eclipse.epsilon.egl.internal.EglPreprocessorContext;
import org.eclipse.epsilon.egl.internal.IEglModule;
import org.eclipse.epsilon.egl.merge.partition.CommentBlockPartitioner;
import org.eclipse.epsilon.egl.merge.partition.CompositePartitioner;
import org.eclipse.epsilon.egl.output.IOutputBuffer;
import org.eclipse.epsilon.egl.output.IOutputBufferFactory;
import org.eclipse.epsilon.egl.output.OutputBuffer;
import org.eclipse.epsilon.egl.status.StatusMessage;
import org.eclipse.epsilon.egl.traceability.Template;
import org.eclipse.epsilon.eol.execute.context.EolContext;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.context.Variable;
import org.eclipse.epsilon.eol.types.EolClasspathNativeTypeDelegate;

public class EglContext
extends EolContext
implements IEglContext {
    private final EglTemplateFactory templateFactory;
    private final List<StatusMessage> statusMessages = new LinkedList<StatusMessage>();
    private final EglExecutionManager executionManager = new EglExecutionManager(new EglFrameStackManager(this.getFrameStack()));
    private IOutputBufferFactory outputBufferFactory = new IOutputBufferFactory(){

        @Override
        public IOutputBuffer create() {
            return new OutputBuffer(EglContext.this);
        }
    };
    private CompositePartitioner partitioner = new CompositePartitioner(new CommentBlockPartitioner[0]);
    private ContentTypeRepository repository = new XMLContentTypeRepository(this);
    private IEglContext parentContext;

    public EglContext(EglTemplateFactory templateFactory) {
        super(new EolClasspathNativeTypeDelegate(EglContext.class.getClassLoader()));
        this.templateFactory = templateFactory;
        this.populateScope();
        this.setOperationFactory(new EglOperationFactory());
        this.setExecutorFactory(new EglExecutorFactory());
    }

    @Override
    public IEglModule getModule() {
        return (IEglModule)this.module;
    }

    @Override
    public EglTemplateFactory getTemplateFactory() {
        return this.templateFactory;
    }

    @Override
    public IOutputBufferFactory getOutputBufferFactory() {
        return this.outputBufferFactory;
    }

    @Override
    public void setOutputBufferFactory(IOutputBufferFactory outputBufferFactory) {
        this.outputBufferFactory = outputBufferFactory;
    }

    private void populateScope() {
        this.getFrameStack().put(Variable.createReadOnlyVariable("TemplateFactory", this.templateFactory));
        this.getFrameStack().put(Variable.createReadOnlyVariable("openTag", "[%"));
        this.getFrameStack().put(Variable.createReadOnlyVariable("openOutputTag", "[%="));
        this.getFrameStack().put(Variable.createReadOnlyVariable("closeTag", "%]"));
    }

    @Override
    public void copyInto(IEolContext context, boolean preserveFrameStack) {
        context.setErrorStream(this.getErrorStream());
        context.setExecutorFactory(this.getExecutorFactory());
        context.setIntrospectionManager(this.getIntrospectionManager());
        context.setModelRepository(this.getModelRepository());
        context.setOperationFactory(this.getOperationFactory());
        context.setOutputStream(this.getOutputStream());
        if (!preserveFrameStack) {
            context.setFrameStack(this.getFrameStack());
        }
        context.setUserInput(this.getUserInput());
        context.setNativeTypeDelegates(this.getNativeTypeDelegates());
        context.setExtendedProperties(this.getExtendedProperties());
        context.setPrettyPrinterManager(this.getPrettyPrinterManager());
        if (context instanceof EglPreprocessorContext) {
            ((EglPreprocessorContext)context).setEglContext(this);
        }
    }

    @Override
    public void copyInto(IEolContext context) {
        this.copyInto(context, false);
    }

    @Override
    public CompositePartitioner getPartitioner() {
        return this.partitioner;
    }

    @Override
    public void setPartitioner(CompositePartitioner partitioner) {
        this.partitioner = partitioner;
    }

    @Override
    public boolean usePartitionerFor(String contentType) {
        CompositePartitioner partitioner = this.repository.partitionerFor(contentType);
        if (partitioner == null) {
            return false;
        }
        this.partitioner = partitioner;
        return true;
    }

    @Override
    public List<String> getPartitioningProblems() {
        return this.getPartitioner().partition(this.getOutputBuffer().toString()).getProblems();
    }

    @Override
    public ContentTypeRepository getContentTypeRepository() {
        return this.repository;
    }

    @Override
    public void setContentTypeRepository(ContentTypeRepository repository) {
        this.repository = repository;
    }

    @Override
    public void addStatusMessage(StatusMessage message) {
        this.statusMessages.add(message);
        if (this.parentContext != null) {
            this.parentContext.addStatusMessage(message);
        }
    }

    @Override
    public List<StatusMessage> getStatusMessages() {
        return Collections.unmodifiableList(this.statusMessages);
    }

    @Override
    public void setOutputStream(PrintStream outputStream) {
        super.setOutputStream(outputStream);
    }

    @Override
    public void enter(EglTemplate template) {
        this.executionManager.prepareFor(new ExecutableTemplateSpecification(template, this.outputBufferFactory.create()));
    }

    @Override
    public void exit() {
        this.executionManager.restore();
    }

    @Override
    public IOutputBuffer getOutputBuffer() {
        return this.executionManager.getCurrent().outputBuffer;
    }

    @Override
    public Template getTrace() {
        return this.executionManager.getBase().template.getTemplate();
    }

    @Override
    public EglTemplate getCurrentTemplate() {
        return this.executionManager.getCurrent().template;
    }

    @Override
    public void formatWith(Formatter formatter) {
        this.getOutputBuffer().formatWith(formatter);
    }
}

