/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eunit;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.eol.EolModule;
import org.eclipse.epsilon.eol.EolOperation;
import org.eclipse.epsilon.eol.annotations.EolAnnotationsUtil;
import org.eclipse.epsilon.eol.annotations.IEolAnnotation;
import org.eclipse.epsilon.eol.exceptions.EolAssertionException;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelNotFoundException;
import org.eclipse.epsilon.eol.execute.context.FrameStack;
import org.eclipse.epsilon.eol.execute.context.FrameType;
import org.eclipse.epsilon.eol.execute.context.Variable;
import org.eclipse.epsilon.eol.models.IModel;
import org.eclipse.epsilon.eol.models.ModelRepository;
import org.eclipse.epsilon.eol.types.EolAnyType;
import org.eclipse.epsilon.eol.types.EolSequence;
import org.eclipse.epsilon.eunit.EUnitParseException;
import org.eclipse.epsilon.eunit.EUnitTest;
import org.eclipse.epsilon.eunit.EUnitTestListener;
import org.eclipse.epsilon.eunit.EUnitTestResultType;
import org.eclipse.epsilon.eunit.ModelBindings;
import org.eclipse.epsilon.eunit.operations.ExtraEUnitOperationContributor;
import org.eclipse.epsilon.internal.eunit.io.ByteBufferTeePrintStream;
import org.eclipse.epsilon.internal.eunit.util.Pair;
import org.eclipse.epsilon.internal.eunit.xml.EUnitXMLFormatter;

public class EUnitModule
extends EolModule {
    private static final String MODEL_EXCLUSIVE_BINDING_ANNOTATION_NAME = "onlyWith";
    private static final String MODEL_BINDING_ANNOTATION_NAME = "with";
    public static final String DEFAULT_PACKAGE = "default";
    private String packageName = "default";
    private static ThreadMXBean THREAD_MXBEAN = ManagementFactory.getThreadMXBean();
    private List<EUnitTestListener> testListeners = new ArrayList<EUnitTestListener>();
    private EUnitTest suiteRoot;
    private File reportDirectory = new File(".");
    private List selectedOperations;

    static {
        THREAD_MXBEAN.setThreadCpuTimeEnabled(true);
    }

    public EUnitModule() {
        this.getContext().getOperationContributorRegistry().add(new ExtraEUnitOperationContributor());
    }

    public ArrayList<EolOperation> getTests() {
        return this.collectOperationsAnnotatedWith("Test", this.getOperationsAnnotatedWith("test"));
    }

    public ArrayList<EolOperation> getInlineModelOperations() {
        return this.collectOperationsAnnotatedWith("Model", this.getOperationsAnnotatedWith("model"));
    }

    public ArrayList<EolOperation> getSetups() {
        return this.collectOperationsAnnotatedWith("Before", this.getOperationsAnnotatedWith("setup"));
    }

    public ArrayList<EolOperation> getTeardowns() {
        return this.collectOperationsAnnotatedWith("After", this.getOperationsAnnotatedWith("teardown"));
    }

    public ArrayList<EolOperation> getSuiteSetups() {
        return this.collectOperationsAnnotatedWith("BeforeClass", this.getOperationsAnnotatedWith("suitesetup"));
    }

    public ArrayList<EolOperation> getSuiteTeardowns() {
        return this.collectOperationsAnnotatedWith("AfterClass", this.getOperationsAnnotatedWith("suiteteardown"));
    }

    public List<Pair<EolOperation, String>> getDataVariableNames() {
        ArrayList<Pair<EolOperation, String>> results = new ArrayList<Pair<EolOperation, String>>();
        for (EolOperation op : this.getOperations()) {
            for (IEolAnnotation ann : EolAnnotationsUtil.getAnnotations(op.getAst())) {
                String annName = ann.getName();
                if (!"data".equals(annName) && !"Data".equals(annName)) continue;
                try {
                    results.add(new Pair<EolOperation, String>(op, (String)ann.getValue(this.context)));
                }
                catch (EolRuntimeException eolRuntimeException) {
                    // empty catch block
                }
            }
        }
        return results;
    }

    public boolean isAnnotatedAs(EolOperation operation, String annotation) {
        try {
            return EolAnnotationsUtil.getBooleanAnnotationValue(operation.getAst(), annotation, this.context, false, true);
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    public Object execute() throws EolRuntimeException {
        try {
            this.runSuite(this.getSuiteRoot());
        }
        finally {
            this.writeReport();
        }
        return null;
    }

    public EUnitTest getSuiteRoot() throws EolRuntimeException {
        if (!this.getParseProblems().isEmpty()) {
            throw new EUnitParseException(this.getParseProblems());
        }
        super.execute();
        if (this.suiteRoot != null) {
            return this.suiteRoot;
        }
        List<Pair<EolOperation, String>> dataVariables = this.getDataVariableNames();
        this.suiteRoot = new EUnitTest();
        this.populateSuiteTree(this.suiteRoot, dataVariables.listIterator());
        return this.suiteRoot;
    }

    public void runSuite(EUnitTest node) throws EolRuntimeException {
        if (node.getResult().equals((Object)EUnitTestResultType.SKIPPED)) {
            return;
        }
        try {
            try {
                this.runSuiteInternal(node);
            }
            catch (Exception ex) {
                this.setResultWithFailureTrace(node, ex, this.isTestFailureException(ex) ? EUnitTestResultType.FAILURE : EUnitTestResultType.ERROR);
                this.clearCache();
                node.setEndCpuTime(THREAD_MXBEAN.getCurrentThreadCpuTime());
                node.setEndWallclockTime(System.currentTimeMillis());
                this.fireAfterCase(node);
                if (node.getOperation() != null) {
                    this.getContext().getFrameStack().leaveLocal(node.getOperation().getAst());
                }
            }
        }
        finally {
            this.clearCache();
            node.setEndCpuTime(THREAD_MXBEAN.getCurrentThreadCpuTime());
            node.setEndWallclockTime(System.currentTimeMillis());
            this.fireAfterCase(node);
            if (node.getOperation() != null) {
                this.getContext().getFrameStack().leaveLocal(node.getOperation().getAst());
            }
        }
    }

    private boolean isTestFailureException(Throwable ex) {
        while (ex instanceof EolRuntimeException) {
            if (ex instanceof EolAssertionException) {
                return true;
            }
            ex = ex.getCause();
        }
        return false;
    }

    protected List<ModelBindings> getModelBindings(EolOperation opTest) throws EolRuntimeException {
        ArrayList<ModelBindings> results = new ArrayList<ModelBindings>();
        for (Object withValue : EolAnnotationsUtil.getAnnotationsValues(opTest.getAst(), MODEL_BINDING_ANNOTATION_NAME, this.getContext())) {
            results.add(new ModelBindings((Map)withValue, ModelBindings.ExclusiveMode.INCLUDE_OTHERS));
        }
        for (Object onlyWithValue : EolAnnotationsUtil.getAnnotationsValues(opTest.getAst(), MODEL_EXCLUSIVE_BINDING_ANNOTATION_NAME, this.getContext())) {
            results.add(new ModelBindings((Map)onlyWithValue, ModelBindings.ExclusiveMode.EXCLUDE_OTHERS));
        }
        return results;
    }

    private void populateSuiteTree(EUnitTest parent, ListIterator<Pair<EolOperation, String>> dataIterator) throws EolRuntimeException {
        if (dataIterator.hasNext()) {
            this.populateSuiteTreeDataOperation(parent, dataIterator);
        } else {
            this.populateSuiteTreeTestOperation(parent);
        }
    }

    private void populateSuiteTreeTestOperation(EUnitTest parent) throws EolRuntimeException {
        for (EolOperation opTest : this.getTests()) {
            EUnitTest test = new EUnitTest();
            test.setParent(parent);
            test.setOperation(opTest);
            parent.addChildren(test);
            try {
                List<ModelBindings> annotationsValues = this.getModelBindings(opTest);
                if (annotationsValues.size() == 1) {
                    test.setModelBindings(annotationsValues.get(0));
                    continue;
                }
                if (annotationsValues.isEmpty()) continue;
                for (ModelBindings mb : annotationsValues) {
                    EUnitTest child = new EUnitTest();
                    child.setParent(test);
                    child.setOperation(opTest);
                    child.setModelBindings(mb);
                    test.addChildren(child);
                }
            }
            catch (Exception ex) {
                this.setResultWithFailureTrace(test, ex, EUnitTestResultType.ERROR);
            }
        }
    }

    private void populateSuiteTreeDataOperation(EUnitTest parent, ListIterator<Pair<EolOperation, String>> dataIterator) throws EolRuntimeException {
        Pair<EolOperation, String> entry = dataIterator.next();
        try {
            try {
                EolSequence values = (EolSequence)entry.getLeft().execute(null, Collections.emptyList(), this.context, true);
                String variableName = entry.getRight();
                for (Object value : values) {
                    EUnitTest child = new EUnitTest();
                    child.setParent(parent);
                    child.setDataVariableName(variableName);
                    child.setDataValue(value);
                    child.setOperation(entry.getLeft());
                    parent.addChildren(child);
                    FrameStack frameStack = this.getContext().getFrameStack();
                    AST operationAST = child.getOperation().getAst();
                    frameStack.enterLocal(FrameType.UNPROTECTED, operationAST, new Variable[0]);
                    AST dataBindingAST = this.applyDataBinding(child);
                    this.populateSuiteTree(child, dataIterator);
                    frameStack.leaveGlobal(dataBindingAST);
                    frameStack.leaveLocal(operationAST);
                }
            }
            catch (Exception ex) {
                this.setResultWithFailureTrace(parent, ex, EUnitTestResultType.ERROR);
                if (dataIterator.hasPrevious()) {
                    dataIterator.previous();
                }
            }
        }
        finally {
            if (dataIterator.hasPrevious()) {
                dataIterator.previous();
            }
        }
    }

    private void setResultWithFailureTrace(EUnitTest node, Exception asex, EUnitTestResultType resultType) {
        node.setResult(resultType);
        node.setException(asex);
        node.setFrameStack(this.getContext().getFrameStack().clone());
    }

    /*
     * Unable to fully structure code
     */
    private void runSuiteInternal(EUnitTest node) throws EolModelNotFoundException, EolRuntimeException {
        block12: {
            if (node.getOperation() != null) {
                this.getContext().getFrameStack().enterLocal(FrameType.UNPROTECTED, node.getOperation().getAst(), new Variable[0]);
            }
            dataBindEntryPoint = null;
            if (node.getDataVariableName() != null) {
                dataBindEntryPoint = this.applyDataBinding(node);
            }
            node.setStartCpuTime(EUnitModule.THREAD_MXBEAN.getCurrentThreadCpuTime());
            node.setStartWallclockTime(System.currentTimeMillis());
            if (node.getResult().equals((Object)EUnitTestResultType.NOT_RUN_YET)) {
                node.setResult(EUnitTestResultType.RUNNING);
            }
            this.fireBeforeCase(node);
            if (node.isRootTest()) {
                this.getContext().setOutputStream(new ByteBufferTeePrintStream(this.getContext().getOutputStream()));
                this.getContext().setErrorStream(new ByteBufferTeePrintStream(this.getContext().getErrorStream()));
                for (EolOperation op : this.getSuiteSetups()) {
                    op.execute(null, Collections.<T>emptyList(), this.context, false);
                }
            }
            try {
                if (node.getResult().equals((Object)EUnitTestResultType.RUNNING)) {
                    if (node.getChildren().isEmpty()) {
                        this.runLeafTestCase(node.getOperation(), node);
                    }
                    this.runInnerTestCase(node);
                }
            }
            finally {
                if (dataBindEntryPoint != null) {
                    this.getContext().getFrameStack().leaveGlobal(dataBindEntryPoint);
                }
                if (!node.isRootTest()) break block12;
                var5_7 = this.getSuiteTeardowns().iterator();
                if (true) ** GOTO lbl39
            }
            {
            }
            do {
                op = var5_7.next();
                op.execute(null, Collections.<T>emptyList(), this.context, false);
lbl39:
                // 2 sources

            } while (var5_7.hasNext());
        }
    }

    private void runInnerTestCase(EUnitTest node) throws EolRuntimeException {
        for (EUnitTest child : node.getChildren()) {
            this.runSuite(child);
            switch (child.getResult()) {
                case ERROR: {
                    node.setResult(EUnitTestResultType.ERROR);
                    node.setException(child.getException());
                    break;
                }
                case FAILURE: {
                    node.setResult(EUnitTestResultType.FAILURE);
                    node.setException(child.getException());
                }
            }
        }
        if (node.getResult() != EUnitTestResultType.ERROR && node.getResult() != EUnitTestResultType.FAILURE) {
            node.setResult(EUnitTestResultType.SUCCESS);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void runLeafTestCase(EolOperation opTest, EUnitTest node) throws EolRuntimeException {
        try {
            for (EolOperation inlineModelOp : this.getInlineModelOperations()) {
                inlineModelOp.execute(null, Collections.<T>emptyList(), this.context, false);
            }
            if (node.getModelBindings() != null) {
                this.applyModelBindings(node);
            }
            for (EolOperation opSetup : this.getSetups()) {
                opSetup.execute(null, Collections.<T>emptyList(), this.context, false);
            }
            if (opTest != null) {
                opTest.execute(null, Collections.<T>emptyList(), this.context, false);
                node.setResult(EUnitTestResultType.SUCCESS);
            }
            node.setException(new EolRuntimeException("Test suite was empty"));
            node.setResult(EUnitTestResultType.FAILURE);
        }
        finally {
            ** for (opTeardown : this.getTeardowns())
        }
lbl-1000:
        // 1 sources

        {
            opTeardown.execute(null, Collections.<T>emptyList(), this.context, false);
            continue;
        }
lbl25:
        // 1 sources

    }

    private AST applyDataBinding(EUnitTest node) {
        Variable dataVariable = new Variable(node.getDataVariableName(), node.getDataValue(), EolAnyType.Instance, true);
        AST dummyEntryPoint = new AST();
        this.getContext().getFrameStack().enterGlobal(FrameType.UNPROTECTED, dummyEntryPoint, dataVariable);
        return dummyEntryPoint;
    }

    private void applyModelBindings(EUnitTest node) throws EolModelNotFoundException {
        ModelRepository modelRepository = this.getContext().getModelRepository();
        ModelBindings bindings = node.getModelBindings();
        Map<String, String> mappings = bindings.getMappings();
        IModel defaultModel = null;
        if (mappings.containsKey("")) {
            defaultModel = modelRepository.getModelByName(mappings.get(""));
        } else if (bindings.getExclusiveMode() == ModelBindings.ExclusiveMode.INCLUDE_OTHERS) {
            defaultModel = modelRepository.getModelByName("");
        }
        if (defaultModel != null) {
            modelRepository.removeModel(defaultModel);
        }
        ArrayList<IModel> renamedModels = new ArrayList<IModel>();
        for (Map.Entry<String, String> entry : mappings.entrySet()) {
            if ("".equals(entry.getKey())) continue;
            if (defaultModel != null && entry.getValue().equals(defaultModel.getName())) {
                defaultModel.setName(entry.getKey());
                continue;
            }
            IModel renamedModel = modelRepository.getModelByName(entry.getValue());
            renamedModel.setName(entry.getKey());
            renamedModels.add(renamedModel);
            modelRepository.removeModel(renamedModel);
        }
        ArrayList<IModel> otherModels = new ArrayList<IModel>(modelRepository.getModels());
        for (IModel model : otherModels) {
            modelRepository.removeModel(model);
        }
        assert (modelRepository.getModels().isEmpty());
        if (defaultModel != null) {
            modelRepository.addModel(defaultModel);
        }
        for (IModel model : renamedModels) {
            modelRepository.addModel(model);
        }
        if (bindings.getExclusiveMode() == ModelBindings.ExclusiveMode.INCLUDE_OTHERS) {
            for (IModel model : otherModels) {
                modelRepository.addModel(model);
            }
        }
    }

    private ArrayList<EolOperation> getOperationsAnnotatedWith(String annotationName) {
        ArrayList<EolOperation> results = new ArrayList<EolOperation>();
        this.collectOperationsAnnotatedWith(annotationName, results);
        return results;
    }

    private ArrayList<EolOperation> collectOperationsAnnotatedWith(String annotationName, ArrayList<EolOperation> results) {
        for (EolOperation operation : this.getOperations()) {
            if (!this.isAnnotatedAs(operation, annotationName)) continue;
            results.add(operation);
        }
        return results;
    }

    public boolean addTestListener(EUnitTestListener listener) {
        return this.testListeners.add(listener);
    }

    public boolean removeTestListener(EUnitTestListener listener) {
        return this.testListeners.remove(listener);
    }

    private void fireAfterCase(EUnitTest test) {
        for (EUnitTestListener listener : this.testListeners) {
            listener.afterCase(this, test);
        }
    }

    private void fireBeforeCase(EUnitTest test) {
        for (EUnitTestListener listener : this.testListeners) {
            listener.beforeCase(this, test);
        }
    }

    public List getSelectedOperations() {
        return this.selectedOperations;
    }

    public void setSelectedOperations(List attribute) throws EolRuntimeException {
        this.selectedOperations = attribute;
        this.markSkippedEntries(this.getSuiteRoot());
    }

    private boolean markSkippedEntries(EUnitTest node) {
        if (!node.isSelected(this.selectedOperations)) {
            node.setResult(EUnitTestResultType.SKIPPED);
            return true;
        }
        if (node.getResult().equals((Object)EUnitTestResultType.SKIPPED)) {
            node.setResult(EUnitTestResultType.NOT_RUN_YET);
        }
        if (node.isLeafTest()) {
            return false;
        }
        boolean bAllChildrenSkipped = true;
        for (EUnitTest child : node.getChildren()) {
            bAllChildrenSkipped &= this.markSkippedEntries(child);
        }
        if (bAllChildrenSkipped) {
            node.setResult(EUnitTestResultType.SKIPPED);
        }
        return bAllChildrenSkipped;
    }

    public void setReportDirectory(File reportFile) {
        this.reportDirectory = reportFile;
    }

    public File getReportDirectory() {
        return this.reportDirectory;
    }

    private void writeReport() throws EolRuntimeException {
        if (this.reportDirectory != null) {
            EUnitXMLFormatter formatter = new EUnitXMLFormatter(this);
            formatter.generate(this.reportDirectory);
        }
    }

    public String getClassName() {
        String filename = this.getAst().getBasename();
        int lastDot = filename.lastIndexOf(46);
        return lastDot == -1 ? filename : filename.substring(0, lastDot);
    }

    public String getPackage() {
        return this.packageName;
    }

    public void setPackage(String packageName) {
        this.packageName = packageName;
    }

    public String getQualifiedName() {
        return String.valueOf(this.getPackage()) + "." + this.getClassName();
    }
}

