/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.optics;

import de.lmu.ifi.dbs.elki.algorithm.clustering.optics.AbstractOPTICS;
import de.lmu.ifi.dbs.elki.algorithm.clustering.optics.ClusterOrder;
import de.lmu.ifi.dbs.elki.algorithm.clustering.optics.OPTICSHeapEntry;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListMIter;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.range.RangeQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.datastructures.heap.UpdatableHeap;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;

@Title(value="OPTICS: Density-Based Hierarchical Clustering")
@Description(value="Algorithm to find density-connected sets in a database based on the parameters 'minPts' and 'epsilon' (specifying a volume). These two parameters determine a density threshold for clustering.")
@Reference(authors="M. Ankerst, M. Breunig, H.-P. Kriegel, and J. Sander", title="OPTICS: Ordering Points to Identify the Clustering Structure", booktitle="Proc. ACM SIGMOD Int. Conf. on Management of Data (SIGMOD '99)", url="http://dx.doi.org/10.1145/304181.304187")
@Alias(value={"de.lmu.ifi.dbs.elki.algorithm.clustering.OPTICS"})
public class OPTICSHeap<O>
extends AbstractOPTICS<O> {
    private static final Logging LOG = Logging.getLogger(OPTICSHeap.class);

    public OPTICSHeap(DistanceFunction<? super O> distanceFunction, double d, int n) {
        super(distanceFunction, d, n);
    }

    @Override
    public ClusterOrder run(Database database, Relation<O> relation) {
        return new Instance(database, relation).run();
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O>
    extends AbstractOPTICS.Parameterizer<O> {
        @Override
        protected OPTICSHeap<O> makeInstance() {
            return new OPTICSHeap(this.distanceFunction, this.epsilon, this.minpts);
        }
    }

    private class Instance {
        private ModifiableDBIDs processedIDs;
        UpdatableHeap<OPTICSHeapEntry> heap;
        ClusterOrder clusterOrder;
        private DBIDs ids;
        FiniteProgress progress;
        RangeQuery<O> rangeQuery;

        public Instance(Database database, Relation<O> relation) {
            this.ids = relation.getDBIDs();
            this.processedIDs = DBIDUtil.newHashSet(this.ids.size());
            this.clusterOrder = new ClusterOrder(this.ids, "OPTICS Clusterorder", "optics-clusterorder");
            this.progress = LOG.isVerbose() ? new FiniteProgress("OPTICS", this.ids.size(), LOG) : null;
            DistanceQuery distanceQuery = database.getDistanceQuery(relation, OPTICSHeap.this.getDistanceFunction(), new Object[0]);
            this.rangeQuery = database.getRangeQuery(distanceQuery, OPTICSHeap.this.epsilon);
            this.heap = new UpdatableHeap();
        }

        public ClusterOrder run() {
            DBIDIter dBIDIter = this.ids.iter();
            while (dBIDIter.valid()) {
                if (!this.processedIDs.contains(dBIDIter)) {
                    assert (this.heap.isEmpty());
                    this.expandClusterOrder(dBIDIter);
                }
                dBIDIter.advance();
            }
            LOG.ensureCompleted(this.progress);
            return this.clusterOrder;
        }

        protected void expandClusterOrder(DBIDRef dBIDRef) {
            ModifiableDoubleDBIDList modifiableDoubleDBIDList = DBIDUtil.newDistanceDBIDList();
            DoubleDBIDListMIter doubleDBIDListMIter = modifiableDoubleDBIDList.iter();
            this.heap.add(new OPTICSHeapEntry(DBIDUtil.deref(dBIDRef), null, Double.POSITIVE_INFINITY));
            while (!this.heap.isEmpty()) {
                OPTICSHeapEntry oPTICSHeapEntry = this.heap.poll();
                this.clusterOrder.add(oPTICSHeapEntry.objectID, oPTICSHeapEntry.reachability, oPTICSHeapEntry.predecessorID);
                this.processedIDs.add(oPTICSHeapEntry.objectID);
                modifiableDoubleDBIDList.clear();
                this.rangeQuery.getRangeForDBID(oPTICSHeapEntry.objectID, OPTICSHeap.this.epsilon, modifiableDoubleDBIDList);
                if (modifiableDoubleDBIDList.size() >= OPTICSHeap.this.minpts) {
                    modifiableDoubleDBIDList.sort();
                    double d = doubleDBIDListMIter.seek(OPTICSHeap.this.minpts - 1).doubleValue();
                    doubleDBIDListMIter.seek(0);
                    while (doubleDBIDListMIter.valid()) {
                        if (!this.processedIDs.contains(doubleDBIDListMIter)) {
                            double d2 = MathUtil.max(doubleDBIDListMIter.doubleValue(), d);
                            this.heap.add(new OPTICSHeapEntry(DBIDUtil.deref(doubleDBIDListMIter), oPTICSHeapEntry.objectID, d2));
                        }
                        doubleDBIDListMIter.advance();
                    }
                }
                LOG.incrementProcessed(this.progress);
            }
        }
    }
}

