/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.application.cache;

import de.lmu.ifi.dbs.elki.application.AbstractApplication;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListMIter;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.range.RangeQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.io.ByteArrayUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.FileParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import de.lmu.ifi.dbs.elki.workflow.InputStep;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;

public class CacheDoubleDistanceRangeQueries<O>
extends AbstractApplication {
    private static final Logging LOG = Logging.getLogger(CacheDoubleDistanceRangeQueries.class);
    private InputStep input;
    private DistanceFunction<O> distance;
    private double radius;
    private File out;
    public static final int RANGE_CACHE_MAGIC = -893111501;

    public CacheDoubleDistanceRangeQueries(InputStep inputStep, DistanceFunction<O> distanceFunction, double d, File file) {
        this.input = inputStep;
        this.distance = distanceFunction;
        this.radius = d;
        this.out = file;
    }

    @Override
    public void run() {
        Database database = this.input.getDatabase();
        Relation relation = database.getRelation(this.distance.getInputTypeRestriction(), new Object[0]);
        DistanceQuery distanceQuery = database.getDistanceQuery(relation, this.distance, new Object[0]);
        RangeQuery rangeQuery = database.getRangeQuery(distanceQuery, this.radius, "heavy");
        LOG.verbose("Performing range queries with radius " + this.radius);
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(this.out, "rw");
             FileChannel fileChannel = randomAccessFile.getChannel();
             FileLock fileLock = fileChannel.lock();){
            randomAccessFile.writeInt(-893111501);
            randomAccessFile.writeDouble(this.radius);
            int n = 2410;
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n);
            FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress("Computing range queries", relation.size(), LOG) : null;
            ModifiableDoubleDBIDList modifiableDoubleDBIDList = DBIDUtil.newDistanceDBIDList();
            DoubleDBIDListMIter doubleDBIDListMIter = modifiableDoubleDBIDList.iter();
            DBIDIter dBIDIter = relation.iterDBIDs();
            while (dBIDIter.valid()) {
                modifiableDoubleDBIDList.clear();
                rangeQuery.getRangeForDBID(dBIDIter, this.radius, modifiableDoubleDBIDList);
                modifiableDoubleDBIDList.sort();
                int n2 = modifiableDoubleDBIDList.size();
                if (n2 * 12 + 10 > n) {
                    while (n2 * 12 + 10 > n) {
                        n <<= 1;
                    }
                    LOG.verbose("Resizing buffer to " + n + " to store " + n2 + " results:");
                    byteBuffer = ByteBuffer.allocateDirect(n);
                }
                byteBuffer.clear();
                ByteArrayUtil.writeUnsignedVarint(byteBuffer, dBIDIter.internalGetIndex());
                ByteArrayUtil.writeUnsignedVarint(byteBuffer, n2);
                int n3 = 0;
                doubleDBIDListMIter.seek(0);
                while (doubleDBIDListMIter.valid()) {
                    ByteArrayUtil.writeUnsignedVarint(byteBuffer, doubleDBIDListMIter.internalGetIndex());
                    byteBuffer.putDouble(doubleDBIDListMIter.doubleValue());
                    doubleDBIDListMIter.advance();
                    ++n3;
                }
                if (n3 != modifiableDoubleDBIDList.size()) {
                    throw new AbortException("Sizes did not agree. Cache is invalid.");
                }
                byteBuffer.flip();
                fileChannel.write(byteBuffer);
                LOG.incrementProcessed(finiteProgress);
                dBIDIter.advance();
            }
            LOG.ensureCompleted(finiteProgress);
            fileLock.release();
        }
        catch (IOException iOException) {
            LOG.exception(iOException);
        }
    }

    public static void main(String[] stringArray) {
        CacheDoubleDistanceRangeQueries.runCLIApplication(CacheDoubleDistanceRangeQueries.class, stringArray);
    }

    public static class Parameterizer<O>
    extends AbstractApplication.Parameterizer {
        public static final OptionID CACHE_ID = new OptionID("loader.diskcache", "File name of the disk cache to create.");
        public static final OptionID DISTANCE_ID = new OptionID("loader.distance", "Distance function to cache.");
        public static final OptionID RADIUS_ID = new OptionID("loader.radius", "Query radius for precomputation.");
        private InputStep input = null;
        private DistanceFunction<O> distance = null;
        private double radius;
        private File out = null;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            FileParameter fileParameter;
            super.makeOptions(parameterization);
            this.input = parameterization.tryInstantiate(InputStep.class);
            ObjectParameter objectParameter = new ObjectParameter(DISTANCE_ID, DistanceFunction.class);
            if (parameterization.grab(objectParameter)) {
                this.distance = (DistanceFunction)objectParameter.instantiateClass(parameterization);
            }
            DoubleParameter doubleParameter = new DoubleParameter(RADIUS_ID);
            doubleParameter.addConstraint(CommonConstraints.GREATER_EQUAL_ZERO_DOUBLE);
            if (parameterization.grab(doubleParameter)) {
                this.radius = doubleParameter.doubleValue();
            }
            if (parameterization.grab(fileParameter = new FileParameter(CACHE_ID, FileParameter.FileType.OUTPUT_FILE))) {
                this.out = (File)fileParameter.getValue();
            }
        }

        @Override
        protected CacheDoubleDistanceRangeQueries<O> makeInstance() {
            return new CacheDoubleDistanceRangeQueries<O>(this.input, this.distance, this.radius, this.out);
        }
    }
}

