/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.filter.cleaning;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.data.type.VectorFieldTypeInformation;
import de.lmu.ifi.dbs.elki.datasource.bundle.BundleMeta;
import de.lmu.ifi.dbs.elki.datasource.bundle.BundleStreamSource;
import de.lmu.ifi.dbs.elki.datasource.bundle.MultipleObjectsBundle;
import de.lmu.ifi.dbs.elki.datasource.filter.AbstractStreamFilter;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.Distribution;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.ArrayList;

@Alias(value={"de.lmu.ifi.dbs.elki.datasource.filter.ReplaceNaNWithRandomFilter"})
public class ReplaceNaNWithRandomFilter
extends AbstractStreamFilter {
    private static final Logging LOG = Logging.getLogger(ReplaceNaNWithRandomFilter.class);
    private NumberVector.Factory<?>[] densecols = null;
    private Distribution dist;
    private ArrayList<Object> rows = new ArrayList();

    public ReplaceNaNWithRandomFilter(Distribution distribution) {
        this.dist = distribution;
    }

    @Override
    public BundleMeta getMeta() {
        return this.source.getMeta();
    }

    @Override
    public Object data(int n) {
        return this.rows.get(n);
    }

    @Override
    public BundleStreamSource.Event nextEvent() {
        while (true) {
            BundleStreamSource.Event event = this.source.nextEvent();
            switch (event) {
                case END_OF_STREAM: {
                    return event;
                }
                case META_CHANGED: {
                    this.updateMeta(this.source.getMeta());
                    return event;
                }
                case NEXT_OBJECT: {
                    if (this.densecols == null) {
                        this.updateMeta(this.source.getMeta());
                    }
                    this.rows.clear();
                    for (int i = 0; i < this.densecols.length; ++i) {
                        Object object = this.source.data(i);
                        if (this.densecols[i] != null) {
                            NumberVector numberVector = (NumberVector)object;
                            double[] dArray = null;
                            if (numberVector != null) {
                                for (int j = 0; j < numberVector.getDimensionality(); ++j) {
                                    if (!Double.isNaN(numberVector.doubleValue(j))) continue;
                                    if (dArray != null) {
                                        dArray = numberVector.getColumnVector().getArrayRef();
                                    }
                                    dArray[j] = this.dist.nextRandom();
                                }
                            }
                            object = this.densecols[i].newNumberVector(dArray);
                        }
                        this.rows.add(object);
                    }
                    return event;
                }
            }
        }
    }

    private void updateMeta(BundleMeta bundleMeta) {
        int n = bundleMeta.size();
        this.densecols = new NumberVector.Factory[n];
        for (int i = 0; i < n; ++i) {
            VectorFieldTypeInformation vectorFieldTypeInformation;
            if (TypeUtil.SPARSE_VECTOR_VARIABLE_LENGTH.isAssignableFromType((TypeInformation)bundleMeta.get(i))) {
                throw new AbortException("Filtering sparse vectors is not yet supported by this filter. Please contribute.");
            }
            if (TypeUtil.FLOAT_VECTOR_FIELD.isAssignableFromType((TypeInformation)bundleMeta.get(i))) {
                vectorFieldTypeInformation = (VectorFieldTypeInformation)bundleMeta.get(i);
                this.densecols[i] = (NumberVector.Factory)vectorFieldTypeInformation.getFactory();
                continue;
            }
            if (!TypeUtil.DOUBLE_VECTOR_FIELD.isAssignableFromType((TypeInformation)bundleMeta.get(i))) continue;
            vectorFieldTypeInformation = (VectorFieldTypeInformation)bundleMeta.get(i);
            this.densecols[i] = (NumberVector.Factory)vectorFieldTypeInformation.getFactory();
        }
    }

    @Override
    public MultipleObjectsBundle filter(MultipleObjectsBundle multipleObjectsBundle) {
        int n;
        if (LOG.isDebuggingFinest()) {
            LOG.debugFinest("Removing records with NaN values.");
        }
        this.updateMeta(multipleObjectsBundle.meta());
        MultipleObjectsBundle multipleObjectsBundle2 = new MultipleObjectsBundle();
        for (n = 0; n < multipleObjectsBundle.metaLength(); ++n) {
            multipleObjectsBundle2.appendColumn(multipleObjectsBundle.meta(n), new ArrayList());
        }
        for (n = 0; n < multipleObjectsBundle.dataLength(); ++n) {
            Object[] objectArray = multipleObjectsBundle.getRow(n);
            for (int i = 0; i < this.densecols.length; ++i) {
                if (this.densecols[i] == null) continue;
                NumberVector numberVector = (NumberVector)objectArray[i];
                double[] dArray = null;
                if (numberVector != null) {
                    for (int j = 0; j < numberVector.getDimensionality(); ++j) {
                        if (!Double.isNaN(numberVector.doubleValue(j))) continue;
                        if (dArray != null) {
                            dArray = numberVector.getColumnVector().getArrayRef();
                        }
                        dArray[j] = this.dist.nextRandom();
                    }
                }
                objectArray[i] = this.densecols[i].newNumberVector(dArray);
            }
            multipleObjectsBundle2.appendSimple(objectArray);
        }
        return multipleObjectsBundle2;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID REPLACEMENT_DISTRIBUTION = new OptionID("nanfilter.replacement", "Distribution to sample replacement values from.");
        private Distribution dist;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            ObjectParameter objectParameter = new ObjectParameter(REPLACEMENT_DISTRIBUTION, Distribution.class);
            if (parameterization.grab(objectParameter)) {
                this.dist = (Distribution)objectParameter.instantiateClass(parameterization);
            }
        }

        @Override
        protected ReplaceNaNWithRandomFilter makeInstance() {
            return new ReplaceNaNWithRandomFilter(this.dist);
        }
    }
}

