/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.filter.normalization.columnwise;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.datasource.filter.normalization.AbstractNormalization;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.NormalDistribution;
import de.lmu.ifi.dbs.elki.utilities.Alias;

@Alias(value={"de.lmu.ifi.dbs.elki.datasource.filter.normalization.AttributeWiseErfNormalization", "de.lmu.ifi.dbs.elki.datasource.filter.AttributeWiseErfNormalization"})
public class AttributeWiseErfNormalization<V extends NumberVector>
extends AbstractNormalization<V> {
    private static final Logging LOG = Logging.getLogger(AttributeWiseErfNormalization.class);

    @Override
    protected V filterSingleObject(V v) {
        double[] dArray = new double[v.getDimensionality()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = NormalDistribution.erf(v.doubleValue(i));
        }
        return this.factory.newNumberVector(dArray);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    @Override
    protected SimpleTypeInformation<? super V> getInputTypeRestriction() {
        return TypeUtil.NUMBER_VECTOR_FIELD;
    }
}

