/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.distance.distancefunction.AbstractSpatialDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Alias(value={"bray-curtis", "braycurtis", "sorensen", "dice", "sorensen-dice"})
@Reference(authors="J. R. Bray and J. T. Curtis", title="An ordination of the upland forest communities of southern Wisconsin", booktitle="Ecological monographs 27.4", url="http://dx.doi.org/10.2307/1942268")
public class BrayCurtisDistanceFunction
extends AbstractSpatialDistanceFunction {
    public static final BrayCurtisDistanceFunction STATIC_CONTINUOUS = new BrayCurtisDistanceFunction();

    @Deprecated
    public BrayCurtisDistanceFunction() {
    }

    @Reference(authors="T. S\u00f8rensen", title="A method of establishing groups of equal amplitude in plant sociology based on similarity of species and its application to analyses of the vegetation on Danish commons", booktitle="Kongelige Danske Videnskabernes Selskab 5 (4)")
    static void secondReference() {
    }

    @Reference(authors="L. R. Dice", title="Measures of the Amount of Ecologic Association Between Species", booktitle="Ecology 26 (3)")
    static void thirdReference() {
    }

    @Override
    public double distance(NumberVector numberVector, NumberVector numberVector2) {
        int n = BrayCurtisDistanceFunction.dimensionality(numberVector, numberVector2);
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < n; ++i) {
            double d3 = numberVector.doubleValue(i);
            double d4 = numberVector2.doubleValue(i);
            d += Math.abs(d3 - d4);
            d2 += Math.abs(d3) + Math.abs(d4);
        }
        return d / d2;
    }

    @Override
    public double minDist(SpatialComparable spatialComparable, SpatialComparable spatialComparable2) {
        int n = BrayCurtisDistanceFunction.dimensionality(spatialComparable, spatialComparable2);
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < n; ++i) {
            double d3 = spatialComparable.getMin(i);
            double d4 = spatialComparable.getMax(i);
            double d5 = spatialComparable2.getMin(i);
            double d6 = spatialComparable2.getMax(i);
            if (d4 < d5) {
                d += d5 - d4;
            } else if (d3 > d6) {
                d += d3 - d6;
            }
            d2 += Math.max(-d3, d4) + Math.max(-d5, d6);
        }
        return d / d2;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected BrayCurtisDistanceFunction makeInstance() {
            return STATIC_CONTINUOUS;
        }
    }
}

