/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction;

import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.query.distance.DBIDDistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.AbstractDatabaseDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DBIDDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.Util;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import java.util.Random;

public class RandomStableDistanceFunction
extends AbstractDatabaseDistanceFunction<DBID>
implements DBIDDistanceFunction {
    public static final RandomStableDistanceFunction STATIC = new RandomStableDistanceFunction(new Random().nextLong());
    private long seed;

    public RandomStableDistanceFunction(long l) {
        this.seed = l;
    }

    @Override
    public double distance(DBIDRef dBIDRef, DBIDRef dBIDRef2) {
        int n = DBIDUtil.compare(dBIDRef, dBIDRef2);
        if (n == 0) {
            return 0.0;
        }
        if (n > 0) {
            return this.distance(dBIDRef2, dBIDRef);
        }
        return this.pseudoRandom(this.seed, Util.mixHashCodes(DBIDUtil.deref(dBIDRef).hashCode(), DBIDUtil.deref(dBIDRef2).hashCode(), (int)this.seed));
    }

    private double pseudoRandom(long l, int n) {
        long l2 = ((long)n ^ l ^ 0x5DEECE66DL) & 0xFFFFFFFFFFFFL;
        long l3 = ((long)n ^ l >>> 16 ^ 0x5DEECE66DL) & 0xFFFFFFFFFFFFL;
        long l4 = l2 * 25214903917L + 11L & 0xFFFFFFFFFFFFL;
        long l5 = l3 * 25214903917L + 11L & 0xFFFFFFFFFFFFL;
        int n2 = (int)(l4 >>> 22);
        int n3 = (int)(l5 >>> 21);
        double d = (double)(((long)n2 << 27) + (long)n3) / 9.007199254740992E15;
        return d;
    }

    public String toString() {
        return "RandomDistance";
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!this.getClass().equals(object.getClass())) {
            return false;
        }
        return this.seed == ((RandomStableDistanceFunction)object).seed;
    }

    public int hashCode() {
        return (int)this.seed;
    }

    @Override
    public TypeInformation getInputTypeRestriction() {
        return TypeUtil.DBID;
    }

    @Override
    public <T extends DBID> DistanceQuery<T> instantiate(Relation<T> relation) {
        return new DBIDDistanceQuery(relation, this);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected RandomStableDistanceFunction makeInstance() {
            return STATIC;
        }
    }
}

