/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mkcop;

import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.query.range.RangeQuery;
import de.lmu.ifi.dbs.elki.database.query.rknn.RKNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.index.KNNIndex;
import de.lmu.ifi.dbs.elki.index.RKNNIndex;
import de.lmu.ifi.dbs.elki.index.RangeIndex;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.MkTreeSettings;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mkcop.MkCoPEntry;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mkcop.MkCoPLeafEntry;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mkcop.MkCoPTree;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mkcop.MkCoPTreeNode;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.query.MTreeQueryUtil;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.query.MkTreeRKNNQuery;
import de.lmu.ifi.dbs.elki.persistent.PageFile;
import java.util.ArrayList;
import java.util.List;

public class MkCoPTreeIndex<O>
extends MkCoPTree<O>
implements RangeIndex<O>,
KNNIndex<O>,
RKNNIndex<O> {
    private Relation<O> relation;

    public MkCoPTreeIndex(Relation<O> relation, PageFile<MkCoPTreeNode<O>> pageFile, MkTreeSettings<O, MkCoPTreeNode<O>, MkCoPEntry> mkTreeSettings) {
        super(relation, pageFile, mkTreeSettings);
        this.relation = relation;
    }

    protected MkCoPEntry createNewLeafEntry(DBID dBID, O o, double d) {
        MkCoPLeafEntry mkCoPLeafEntry = new MkCoPLeafEntry(dBID, d, null, null);
        return mkCoPLeafEntry;
    }

    @Override
    public void initialize() {
        super.initialize();
        ArrayList<MkCoPEntry> arrayList = new ArrayList<MkCoPEntry>(this.relation.size());
        DBIDIter dBIDIter = this.relation.iterDBIDs();
        while (dBIDIter.valid()) {
            DBID dBID = DBIDUtil.deref(dBIDIter);
            O o = this.relation.get(dBID);
            arrayList.add(this.createNewLeafEntry(dBID, o, Double.NaN));
            dBIDIter.advance();
        }
        this.insertAll((List<MkCoPEntry>)arrayList);
    }

    @Override
    public KNNQuery<O> getKNNQuery(DistanceQuery<O> distanceQuery, Object ... objectArray) {
        if (distanceQuery.getRelation() != this.relation) {
            return null;
        }
        DistanceFunction<O> distanceFunction = distanceQuery.getDistanceFunction();
        if (!this.getDistanceFunction().equals(distanceFunction)) {
            this.getLogger().debug("Distance function not supported by index - or 'equals' not implemented right!");
            return null;
        }
        return MTreeQueryUtil.getKNNQuery(this, distanceQuery, objectArray);
    }

    @Override
    public RangeQuery<O> getRangeQuery(DistanceQuery<O> distanceQuery, Object ... objectArray) {
        if (distanceQuery.getRelation() != this.relation) {
            return null;
        }
        DistanceFunction<O> distanceFunction = distanceQuery.getDistanceFunction();
        if (!this.getDistanceFunction().equals(distanceFunction)) {
            this.getLogger().debug("Distance function not supported by index - or 'equals' not implemented right!");
            return null;
        }
        return MTreeQueryUtil.getRangeQuery(this, distanceQuery, objectArray);
    }

    @Override
    public RKNNQuery<O> getRKNNQuery(DistanceQuery<O> distanceQuery, Object ... objectArray) {
        DistanceFunction<O> distanceFunction = distanceQuery.getDistanceFunction();
        if (!this.getDistanceFunction().equals(distanceFunction)) {
            this.getLogger().debug("Distance function not supported by index - or 'equals' not implemented right!");
            return null;
        }
        return new MkTreeRKNNQuery<O>(this, distanceQuery);
    }

    @Override
    public String getLongName() {
        return "MkCoP-Tree";
    }

    @Override
    public String getShortName() {
        return "mkcoptree";
    }
}

