/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.linearalgebra.randomprojections;

import de.lmu.ifi.dbs.elki.math.linearalgebra.randomprojections.AbstractRandomProjectionFamily;
import de.lmu.ifi.dbs.elki.math.linearalgebra.randomprojections.RandomProjectionFamily;
import de.lmu.ifi.dbs.elki.math.random.RandomFactory;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;

@Reference(title="Database-friendly random projections: Johnson-Lindenstrauss with binary coins", authors="D. Achlioptas", booktitle="Proc. 20th ACM SIGMOD-SIGACT-SIGART symposium on Principles of database systems", url="http://dx.doi.org/10.1145/375551.375608")
public class AchlioptasRandomProjectionFamily
extends AbstractRandomProjectionFamily {
    private double sparsity;

    public AchlioptasRandomProjectionFamily(double d, RandomFactory randomFactory) {
        super(randomFactory);
        this.sparsity = d;
    }

    @Override
    public RandomProjectionFamily.Projection generateProjection(int n, int n2) {
        double d = 0.5 / this.sparsity;
        double d2 = d + d;
        double d3 = Math.sqrt(this.sparsity);
        double[][] dArray = new double[n2][n];
        for (int i = 0; i < n2; ++i) {
            double[] dArray2 = dArray[i];
            for (int j = 0; j < n; ++j) {
                double d4 = this.random.nextDouble();
                dArray2[j] = d4 < d ? d3 : (d4 < d2 ? -d3 : 0.0);
            }
        }
        return new AbstractRandomProjectionFamily.MatrixProjection(dArray);
    }

    public static class Parameterizer
    extends AbstractRandomProjectionFamily.Parameterizer {
        public static final OptionID SPARSITY_ID = new OptionID("achlioptas.sparsity", "Frequency of zeros in the projection matrix.");
        private double sparsity = 3.0;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            DoubleParameter doubleParameter = new DoubleParameter(SPARSITY_ID);
            doubleParameter.setDefaultValue((Object)3.0);
            doubleParameter.addConstraint(CommonConstraints.GREATER_EQUAL_ONE_DOUBLE);
            if (parameterization.grab(doubleParameter)) {
                this.sparsity = doubleParameter.doubleValue();
            }
        }

        @Override
        protected AchlioptasRandomProjectionFamily makeInstance() {
            return new AchlioptasRandomProjectionFamily(this.sparsity, this.random);
        }
    }
}

