/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.datastructures.unionfind;

import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import java.util.Arrays;

@Reference(authors="R. Sedgewick", title="1.3 Union-Find Algorithms", booktitle="Algorithms in C, Parts 1-4")
public class WeightedQuickUnionInteger {
    private int used;
    private int[] parent;
    private int[] weight = new int[51];
    private static final int INITIAL_SIZE = 51;

    public WeightedQuickUnionInteger() {
        this.parent = new int[51];
    }

    public int nextIndex(int n) {
        if (this.used == this.parent.length) {
            int n2 = this.used + (this.used >> 1);
            this.weight = Arrays.copyOf(this.weight, n2);
            this.parent = Arrays.copyOf(this.parent, n2);
        }
        this.weight[this.used] = n;
        this.parent[this.used] = this.used;
        return this.used++;
    }

    public int find(int n) {
        assert (n >= 0 && n < this.parent.length);
        int n2 = this.parent[n];
        while (n != n2) {
            int n3 = n2;
            n2 = this.parent[n] = this.parent[n2];
            n = n3;
        }
        return n;
    }

    public int union(int n, int n2) {
        int n3;
        int n4 = this.find(n);
        if (n4 == (n3 = this.find(n2))) {
            return n4;
        }
        int n5 = this.weight[n4];
        int n6 = this.weight[n3];
        if (n5 > n6) {
            this.parent[n3] = n4;
            int n7 = n4;
            this.weight[n7] = this.weight[n7] + n6;
            return n4;
        }
        this.parent[n4] = n3;
        int n8 = n3;
        this.weight[n8] = this.weight[n8] + n5;
        return n3;
    }

    public boolean isConnected(int n, int n2) {
        return this.find(n) == this.find(n2);
    }

    public TIntList getRoots() {
        TIntArrayList tIntArrayList = new TIntArrayList();
        for (int i = 0; i < this.used; ++i) {
            if (this.parent[i] != i) continue;
            tIntArrayList.add(i);
        }
        return tIntArrayList;
    }

    public int size() {
        return this.used;
    }
}

