/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters;

import de.lmu.ifi.dbs.elki.utilities.ClassGenericsUtil;
import de.lmu.ifi.dbs.elki.utilities.ELKIServiceRegistry;
import de.lmu.ifi.dbs.elki.utilities.FormatUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.ParameterException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.UnusedParameterException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.WrongParameterValueException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ListParameter;
import java.util.ArrayList;
import java.util.List;

public class ClassListParameter<C>
extends ListParameter<ClassListParameter<C>, List<Class<? extends C>>> {
    protected Class<C> restrictionClass;

    public ClassListParameter(OptionID optionID, Class<?> clazz, boolean bl) {
        super(optionID, bl);
        this.restrictionClass = clazz;
    }

    public ClassListParameter(OptionID optionID, Class<?> clazz) {
        super(optionID);
        this.restrictionClass = clazz;
    }

    @Override
    public String getValueAsString() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.restrictionClass.getPackage().getName() + ".";
        for (Class clazz : (List)this.getValue()) {
            String string2;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(",");
            }
            if ((string2 = clazz.getName()).startsWith(string)) {
                string2 = string2.substring(string.length());
            }
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    @Override
    public String getDefaultValueAsString() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.restrictionClass.getPackage().getName() + ".";
        for (Class clazz : (List)this.getDefaultValue()) {
            String string2;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(",");
            }
            if ((string2 = clazz.getName()).startsWith(string)) {
                string2 = string2.substring(string.length());
            }
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    @Override
    protected List<Class<? extends C>> parseValue(Object object) throws ParameterException {
        try {
            List list = (List)List.class.cast(object);
            for (Object e : list) {
                if (e instanceof Class) continue;
                throw new WrongParameterValueException("Wrong parameter format for parameter \"" + this.getName() + "\". Given list contains objects of different type!");
            }
            return list;
        }
        catch (ClassCastException classCastException) {
            try {
                if (this.restrictionClass.isAssignableFrom((Class)object)) {
                    ArrayList<Class<C>> arrayList = new ArrayList<Class<C>>(1);
                    arrayList.add((Class)object);
                    return arrayList;
                }
            }
            catch (ClassCastException classCastException2) {
                // empty catch block
            }
            if (object instanceof String) {
                String[] stringArray = SPLIT.split((String)object);
                if (stringArray.length == 0) {
                    throw new WrongParameterValueException("Wrong parameter format! Given list of classes for parameter \"" + this.getName() + "\" is either empty or has the wrong format!");
                }
                ArrayList<Class<C>> arrayList = new ArrayList<Class<C>>(stringArray.length);
                for (String string : stringArray) {
                    Class<C> clazz = ELKIServiceRegistry.findImplementation(this.restrictionClass, string);
                    if (clazz == null) {
                        throw new WrongParameterValueException(this, (String)object, "Class '" + string + "' not found for given value. Must be a subclass / implementation of " + this.restrictionClass.getName());
                    }
                    arrayList.add(clazz);
                }
                return arrayList;
            }
            throw new WrongParameterValueException("Wrong parameter format! Parameter \"" + this.getName() + "\" requires a list of Class values!");
        }
    }

    @Override
    protected boolean validate(List<Class<? extends C>> list) throws ParameterException {
        for (Class<C> clazz : list) {
            if (this.restrictionClass.isAssignableFrom(clazz)) continue;
            throw new WrongParameterValueException(this, clazz.getName(), "Class \"" + clazz.getName() + "\" does not extend/implement restriction class " + this.restrictionClass + ".\n");
        }
        return super.validate(list);
    }

    public Class<C> getRestrictionClass() {
        return this.restrictionClass;
    }

    public List<Class<?>> getKnownImplementations() {
        return ELKIServiceRegistry.findAllImplementations(this.getRestrictionClass());
    }

    @Override
    public String getSyntax() {
        return "<class_1,...,class_n>";
    }

    public List<C> instantiateClasses(Parameterization parameterization) {
        parameterization = parameterization.descend(this);
        ArrayList<C> arrayList = new ArrayList<C>();
        if (this.getValue() == null) {
            parameterization.reportError(new UnusedParameterException("Value of parameter " + this.getName() + " has not been specified."));
            return arrayList;
        }
        for (Class clazz : (List)this.getValue()) {
            try {
                C c = ClassGenericsUtil.tryInstantiate(this.restrictionClass, clazz, parameterization);
                arrayList.add(c);
            }
            catch (Exception exception) {
                parameterization.reportError(new WrongParameterValueException(this, clazz.getName(), exception));
            }
        }
        return arrayList;
    }

    public String restrictionString() {
        String string = this.restrictionClass.getPackage().getName() + ".";
        StringBuilder stringBuilder = new StringBuilder();
        if (this.restrictionClass.isInterface()) {
            stringBuilder.append("Implementing ");
        } else {
            stringBuilder.append("Extending ");
        }
        stringBuilder.append(this.restrictionClass.getName());
        stringBuilder.append(FormatUtil.NEWLINE);
        List<Class<?>> list = this.getKnownImplementations();
        if (!list.isEmpty()) {
            stringBuilder.append("Known classes (default package " + string + "):");
            stringBuilder.append(FormatUtil.NEWLINE);
            for (Class<?> clazz : list) {
                stringBuilder.append("->\u00a0");
                String string2 = clazz.getName();
                if (string2.startsWith(string)) {
                    stringBuilder.append(string2.substring(string.length()));
                } else {
                    stringBuilder.append(string2);
                }
                stringBuilder.append(FormatUtil.NEWLINE);
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public boolean hasValuesDescription() {
        return this.restrictionClass != null && this.restrictionClass != Object.class;
    }

    @Override
    public String getValuesDescription() {
        if (this.restrictionClass != null && this.restrictionClass != Object.class) {
            return this.restrictionString();
        }
        return "";
    }

    @Override
    public int size() {
        return ((List)this.getValue()).size();
    }
}

