/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.ecl;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.antlr.runtime.ANTLRInputStream;
import org.antlr.runtime.Lexer;
import org.antlr.runtime.TokenStream;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.common.parse.EpsilonParser;
import org.eclipse.epsilon.common.util.AstUtil;
import org.eclipse.epsilon.ecl.IEclModule;
import org.eclipse.epsilon.ecl.MatchRule;
import org.eclipse.epsilon.ecl.MatchRules;
import org.eclipse.epsilon.ecl.execute.EclOperationFactory;
import org.eclipse.epsilon.ecl.execute.context.EclContext;
import org.eclipse.epsilon.ecl.execute.context.IEclContext;
import org.eclipse.epsilon.ecl.parse.EclLexer;
import org.eclipse.epsilon.ecl.parse.EclParser;
import org.eclipse.epsilon.ecl.trace.Match;
import org.eclipse.epsilon.eol.EolImport;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.context.Variable;
import org.eclipse.epsilon.erl.ErlModule;
import org.eclipse.epsilon.erl.rules.INamedRule;

public class EclModule
extends ErlModule
implements IEclModule {
    protected MatchRules matchRules = null;
    protected MatchRules declaredMatchRules = null;
    protected IEclContext context = null;

    public EclModule() {
        this.reset();
    }

    @Override
    public Lexer createLexer(InputStream inputStream) {
        ANTLRInputStream input = null;
        try {
            input = new ANTLRInputStream(inputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new EclLexer(input);
    }

    @Override
    public EpsilonParser createParser(TokenStream tokenStream) {
        return new EclParser(tokenStream);
    }

    @Override
    public String getMainRule() {
        return "eclModule";
    }

    @Override
    public void buildModel() throws Exception {
        super.buildModel();
        for (AST matchRuleAst : AstUtil.getChildren(this.ast, 80)) {
            this.declaredMatchRules.add(new MatchRule(matchRuleAst));
        }
        this.getParseProblems().addAll(this.getMatchRules().calculateSuperRules(this.getMatchRules()));
    }

    @Override
    public HashMap<String, Class<?>> getImportConfiguration() {
        HashMap<String, Class<?>> importConfiguration = super.getImportConfiguration();
        importConfiguration.put("ecl", EclModule.class);
        return importConfiguration;
    }

    @Override
    public MatchRules getMatchRules() {
        if (this.matchRules == null) {
            this.matchRules = new MatchRules();
            for (EolImport import_ : this.imports) {
                if (!import_.isLoaded() || !(import_.getModule() instanceof IEclModule)) continue;
                IEclModule module = (IEclModule)import_.getModule();
                this.matchRules.addAll(module.getMatchRules());
            }
            this.matchRules.addAll(this.declaredMatchRules);
        }
        return this.matchRules;
    }

    @Override
    public Object execute() throws EolRuntimeException {
        this.prepareContext(this.context);
        this.context.setOperationFactory(new EclOperationFactory());
        this.context.getFrameStack().put(Variable.createReadOnlyVariable("matchTrace", this.context.getMatchTrace()));
        this.context.getFrameStack().put(Variable.createReadOnlyVariable("context", this.context));
        this.context.getFrameStack().put(Variable.createReadOnlyVariable("self", this));
        this.execute(this.getPre(), this.context);
        this.matchModels();
        this.execute(this.getPost(), this.context);
        return this.context.getMatchTrace();
    }

    @Override
    public void matchModels() throws EolRuntimeException {
        MatchRule matchRule;
        for (INamedRule rule : this.getMatchRules()) {
            matchRule = (MatchRule)rule;
            if (matchRule.isAbstract() || matchRule.isLazy()) continue;
            matchRule.matchAll(this.context, true);
        }
        for (INamedRule rule : this.getMatchRules()) {
            matchRule = (MatchRule)rule;
            if (matchRule.isAbstract() || matchRule.isLazy() || !matchRule.isGreedy()) continue;
            matchRule.matchAll(this.context, false);
        }
    }

    @Override
    public Match match(Object left, Object right, boolean forcedMatch) throws EolRuntimeException {
        Match traceMatch = this.context.getMatchTrace().getMatch(left, right);
        if (traceMatch != null) {
            return traceMatch;
        }
        MatchRules matchRules = this.getMatchRules().getRulesFor(left, right, this.context, true);
        MatchRule matchRule2 = null;
        if (matchRules.size() > 0) {
            matchRule2 = (MatchRule)matchRules.iterator().next();
            return matchRule2.match(left, right, this.context, false, null, forcedMatch);
        }
        matchRules = this.getMatchRules().getRulesFor(left, right, this.context, false);
        if (matchRules.size() > 0) {
            Match match = this.context.getMatchTrace().createMatch(left, right, true);
            for (MatchRule matchRule2 : matchRules) {
                if (!matchRule2.isGreedy()) continue;
                Match tempMatch = matchRule2.match(left, right, this.context, true, match.getInfo(), forcedMatch);
                match.setMatching(match.isMatching() && tempMatch.isMatching());
                match.setRule(matchRule2);
            }
            this.context.getMatchTrace().getMatches().add(match);
            return match;
        }
        Match match = this.context.getMatchTrace().createMatch(left, right, false);
        this.context.getMatchTrace().getMatches().add(match);
        return match;
    }

    @Override
    public IEclContext getContext() {
        return this.context;
    }

    @Override
    public List<ModuleElement> getChildren() {
        ArrayList<ModuleElement> children = new ArrayList<ModuleElement>();
        children.addAll(this.getImports());
        children.addAll(this.getDeclaredPre());
        children.addAll(this.getDeclaredMatchRules());
        children.addAll(this.getDeclaredOperations());
        children.addAll(this.getDeclaredPost());
        return children;
    }

    @Override
    public void reset() {
        super.reset();
        this.matchRules = null;
        this.declaredMatchRules = new MatchRules();
        this.context = new EclContext();
    }

    @Override
    public MatchRules getDeclaredMatchRules() {
        return this.declaredMatchRules;
    }

    @Override
    protected int getPostBlockTokenType() {
        return 77;
    }

    @Override
    protected int getPreBlockTokenType() {
        return 76;
    }

    @Override
    public void setContext(IEolContext context) {
        if (context instanceof IEclContext) {
            this.context = (IEclContext)context;
        }
    }
}

