/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.egl.merge.output;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.epsilon.egl.merge.output.ProtectedRegion;
import org.eclipse.epsilon.egl.merge.output.Region;

public class Output {
    private final List<Region> regions = new LinkedList<Region>();
    private final List<String> protectedRegionIds = new LinkedList<String>();
    private final List<String> duplicatedProtectedRegionIds = new LinkedList<String>();

    public Output(Region ... regions) {
        this.regions.addAll(Arrays.asList(regions));
        this.processIds();
    }

    public Output(List<Region> regions) {
        this.regions.addAll(regions);
        this.processIds();
    }

    private void processIds() {
        for (Region r : this.regions) {
            if (!(r instanceof ProtectedRegion)) continue;
            ProtectedRegion pr = (ProtectedRegion)r;
            if (this.protectedRegionIds.contains(pr.getId())) {
                this.duplicatedProtectedRegionIds.add(pr.getId());
                continue;
            }
            this.protectedRegionIds.add(pr.getId());
        }
    }

    public List<Region> getRegions() {
        return Collections.unmodifiableList(this.regions);
    }

    public List<ProtectedRegion> getProtectedRegions() {
        LinkedList<ProtectedRegion> protectedRegions = new LinkedList<ProtectedRegion>();
        for (Region region : this.regions) {
            if (!(region instanceof ProtectedRegion)) continue;
            protectedRegions.add((ProtectedRegion)region);
        }
        return Collections.unmodifiableList(protectedRegions);
    }

    public ProtectedRegion getProtectedRegion(String id) {
        for (Region region : this.regions) {
            ProtectedRegion protectedRegion;
            if (!(region instanceof ProtectedRegion) || !(protectedRegion = (ProtectedRegion)region).getId().equals(id)) continue;
            return protectedRegion;
        }
        return null;
    }

    public List<String> getProblems() {
        LinkedList<String> problems = new LinkedList<String>();
        for (String id : this.duplicatedProtectedRegionIds) {
            problems.add("Output contains more than one protected region with the identifier '" + id + "'");
        }
        return Collections.unmodifiableList(problems);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Region region : this.regions) {
            builder.append(region);
        }
        return builder.toString();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof Output)) {
            return false;
        }
        Output that = (Output)o;
        return this.regions.equals(that.regions);
    }

    public int hashCode() {
        return this.regions.hashCode();
    }
}

