/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.etl.strategy;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.epsilon.common.util.CollectionUtil;
import org.eclipse.epsilon.eol.EolFormalParameter;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.types.EolCollectionType;
import org.eclipse.epsilon.erl.rules.INamedRule;
import org.eclipse.epsilon.erl.strategy.IEquivalentProvider;
import org.eclipse.epsilon.etl.TransformRule;
import org.eclipse.epsilon.etl.execute.context.IEtlContext;
import org.eclipse.epsilon.etl.strategy.ITransformationStrategy;
import org.eclipse.epsilon.etl.trace.Transformation;
import org.eclipse.epsilon.etl.trace.Transformations;

public class FastTransformationStrategy
implements ITransformationStrategy {
    protected IEquivalentProvider equivalentProvider;
    protected HashMap<Object, Collection<Object>> flatTrace = new HashMap();
    protected HashMap<Object, Transformations> pendingTransformations = new HashMap();

    public FastTransformationStrategy() {
        this.equivalentProvider = this;
    }

    public List<Object> getExcluded() {
        return Collections.emptyList();
    }

    @Override
    public boolean canTransform(Object source) {
        return !this.getExcluded().contains(source);
    }

    @Override
    public Collection<?> transform(Object source, IEtlContext context, List<String> rules) throws EolRuntimeException {
        throw new UnsupportedOperationException("FastTransformationStrategy cannot transform single objects. Please use DefaultTransformationStrategy instead.");
    }

    @Override
    public Collection<?> getEquivalents(Object source, IEolContext context_, List<String> rules) throws EolRuntimeException {
        IEtlContext context = (IEtlContext)context_;
        if (this.pendingTransformations.containsKey(source)) {
            Transformations transformations = this.pendingTransformations.remove(source);
            this.executeTransformations(transformations, context);
        }
        return this.flatTrace.get(source);
    }

    @Override
    public Object getEquivalent(Object source, IEolContext context_, List<String> rules) throws EolRuntimeException {
        IEtlContext context = (IEtlContext)context_;
        Collection<?> equivalents = this.getEquivalents(source, (IEolContext)context, rules);
        if (equivalents != null && !equivalents.isEmpty()) {
            return CollectionUtil.getFirst(equivalents);
        }
        return null;
    }

    @Override
    public Collection<?> getEquivalent(Collection<?> collection, IEolContext context_, List<String> rules) throws EolRuntimeException {
        IEtlContext context = (IEtlContext)context_;
        return CollectionUtil.flatten(this.getEquivalents(collection, (IEolContext)context, rules));
    }

    @Override
    public Collection<?> getEquivalents(Collection<?> collection, IEolContext context_, List<String> rules) throws EolRuntimeException {
        IEtlContext context = (IEtlContext)context_;
        List equivalents = CollectionUtil.createDefaultList();
        Iterator<?> it = collection.iterator();
        while (it.hasNext()) {
            Collection<?> equivalent = this.getEquivalents(it.next(), (IEolContext)context, rules);
            if (equivalent == null || equivalents.contains(equivalent)) continue;
            equivalents.add(equivalent);
        }
        return equivalents;
    }

    @Override
    public void transformModels(IEtlContext context) throws EolRuntimeException {
        for (INamedRule rule : context.getModule().getTransformRules()) {
            TransformRule transformRule = (TransformRule)rule;
            if (transformRule.isLazy() || transformRule.isAbstract()) continue;
            Collection<?> sources = transformRule.isGreedy() ? transformRule.getSourceType(context).getAllOfKind() : transformRule.getSourceType(context).getAllOfType();
            for (Object instance : sources) {
                if (this.getExcluded().contains(instance) || !transformRule.appliesTo(instance, context, false, false)) continue;
                List<Object> targets = CollectionUtil.createDefaultList();
                for (EolFormalParameter target : transformRule.getTargetParameters()) {
                    targets.add(target.getType(context).createInstance());
                }
                context.getTransformationTrace().add(instance, targets, transformRule);
            }
        }
        for (Transformation transformation : context.getTransformationTrace().getTransformations()) {
            if (this.flatTrace.containsKey(transformation.getSource())) {
                if (transformation.getRule().isPrimary()) {
                    this.flatTrace.put(transformation.getSource(), EolCollectionType.join(transformation.getTargets(), this.flatTrace.get(transformation.getSource())));
                } else {
                    this.flatTrace.get(transformation.getSource()).addAll(transformation.getTargets());
                }
            } else {
                this.flatTrace.put(transformation.getSource(), EolCollectionType.clone(transformation.getTargets()));
            }
            if (this.pendingTransformations.containsKey(transformation.getSource())) {
                this.pendingTransformations.get(transformation.getSource()).add(transformation);
                continue;
            }
            Transformations transformations = new Transformations();
            transformations.add(transformation);
            this.pendingTransformations.put(transformation.getSource(), transformations);
        }
        this.executeTransformations(context.getTransformationTrace().getTransformations(), context);
    }

    protected void executeTransformations(Transformations transformations, IEtlContext context) throws EolRuntimeException {
        for (Transformation transformation : transformations) {
            TransformRule rule = transformation.getRule();
            if (rule.hasTransformed(transformation.getSource())) continue;
            rule.transform(transformation.getSource(), transformation.getTargets(), context);
        }
    }

    @Override
    public void setEquivalentProvider(IEquivalentProvider equivalentProvider) {
        this.equivalentProvider = equivalentProvider;
    }

    @Override
    public IEquivalentProvider getEquivalentProvider() {
        return this.equivalentProvider;
    }
}

