/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.uml.internal.operations;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.uml2.uml.BehavioralFeature;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.internal.operations.NamespaceOperations;
import org.eclipse.uml2.uml.internal.operations.ParameterOperations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BehavioralFeatureOperations
extends NamespaceOperations {
    protected BehavioralFeatureOperations() {
    }

    public static boolean validateAbstractNoMethod(BehavioralFeature behavioralFeature, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public static Parameter createReturnResult(BehavioralFeature behavioralFeature, String name, Type type) {
        Parameter returnResult = behavioralFeature.createOwnedParameter(name, type);
        returnResult.setDirection(ParameterDirectionKind.RETURN_LITERAL);
        return returnResult;
    }

    public static EList<Parameter> inputParameters(BehavioralFeature behavioralFeature) {
        UniqueEList.FastCompare<Parameter> inputParameters = new UniqueEList.FastCompare<Parameter>();
        for (Parameter ownedParameter : behavioralFeature.getOwnedParameters()) {
            ParameterDirectionKind direction = ownedParameter.getDirection();
            if (direction != ParameterDirectionKind.IN_LITERAL && direction != ParameterDirectionKind.INOUT_LITERAL) continue;
            inputParameters.add(ownedParameter);
        }
        return ECollections.unmodifiableEList(inputParameters);
    }

    public static EList<Parameter> outputParameters(BehavioralFeature behavioralFeature) {
        UniqueEList.FastCompare<Parameter> outputParameters = new UniqueEList.FastCompare<Parameter>();
        for (Parameter ownedParameter : behavioralFeature.getOwnedParameters()) {
            ParameterDirectionKind direction = ownedParameter.getDirection();
            if (direction != ParameterDirectionKind.OUT_LITERAL && direction != ParameterDirectionKind.INOUT_LITERAL && direction != ParameterDirectionKind.RETURN_LITERAL) continue;
            outputParameters.add(ownedParameter);
        }
        return ECollections.unmodifiableEList(outputParameters);
    }

    public static boolean isDistinguishableFrom(BehavioralFeature behavioralFeature, NamedElement n, Namespace ns) {
        if (n instanceof BehavioralFeature) {
            EList<String> namesOfMemberN = ns.getNamesOfMember(n);
            for (String nameOfMemberBF : ns.getNamesOfMember(behavioralFeature)) {
                if (!namesOfMemberN.contains(nameOfMemberBF)) continue;
                Iterator bfParameters = behavioralFeature.getOwnedParameters().iterator();
                Iterator nParameters = ((BehavioralFeature)n).getOwnedParameters().iterator();
                while (bfParameters.hasNext() && nParameters.hasNext()) {
                    if (ParameterOperations.matches((Parameter)bfParameters.next(), (Parameter)nParameters.next())) continue;
                    return true;
                }
                return bfParameters.hasNext() || nParameters.hasNext();
            }
        }
        return true;
    }
}

