/*
 * Decompiled with CFR 0.152.
 */
package de.ugoe.cs.util.console;

import de.ugoe.cs.util.console.Console;
import de.ugoe.cs.util.console.listener.IOutputListener;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class FileOutputListener
implements IOutputListener {
    boolean failureLogged = false;
    String filename;
    OutputStreamWriter writer = null;

    public FileOutputListener(String filename) {
        this.filename = filename;
    }

    public void start() {
        try {
            FileOutputStream fos = new FileOutputStream(this.filename);
            this.writer = new OutputStreamWriter((OutputStream)fos, "UTF-8");
            Console.getInstance().registerOutputListener(this);
        }
        catch (IOException e) {
            Console.printerrln("Failed to start FileOutputListener for file " + this.filename + ": " + e.getMessage());
        }
    }

    public void stop() {
        Console.getInstance().removeOutputListener(this);
        if (this.writer != null) {
            try {
                this.writer.close();
                this.writer = null;
            }
            catch (IOException e) {
                Console.printerrln("Failed to close file " + this.filename + ": " + e.getMessage());
            }
        }
    }

    @Override
    public void outputMsg(String newMessage) {
        block3: {
            if (this.writer != null) {
                try {
                    this.writer.write(newMessage);
                }
                catch (IOException e) {
                    if (this.failureLogged) break block3;
                    Console.printerrln("FileOutpustListener for file " + this.filename + " broken: " + e.getMessage());
                    this.failureLogged = true;
                }
            }
        }
    }

    public String getFilename() {
        return this.filename;
    }
}

