/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.application.greedyensemble;

import de.lmu.ifi.dbs.elki.application.AbstractApplication;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDPair;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.distance.distancefunction.PrimitiveDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.correlation.WeightedPearsonCorrelationDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.WeightedEuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.WeightedManhattanDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.WeightedSquaredEuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.evaluation.scores.ROCEvaluation;
import de.lmu.ifi.dbs.elki.evaluation.scores.adapter.AbstractVectorIter;
import de.lmu.ifi.dbs.elki.evaluation.scores.adapter.DecreasingVectorIter;
import de.lmu.ifi.dbs.elki.evaluation.scores.adapter.VectorNonZero;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.MeanVariance;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import de.lmu.ifi.dbs.elki.utilities.DatabaseUtil;
import de.lmu.ifi.dbs.elki.utilities.FormatUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.ArrayLikeUtil;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.ensemble.EnsembleVoting;
import de.lmu.ifi.dbs.elki.utilities.ensemble.EnsembleVotingMean;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.EnumParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import de.lmu.ifi.dbs.elki.utilities.scaling.ScalingFunction;
import de.lmu.ifi.dbs.elki.utilities.scaling.outlier.OutlierScalingFunction;
import de.lmu.ifi.dbs.elki.workflow.InputStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;

@Reference(authors="E. Schubert, R. Wojdanowski, A. Zimek, H.-P. Kriegel", title="On Evaluation of Outlier Rankings and Outlier Scores", booktitle="Proc. 12th SIAM International Conference on Data Mining (SDM), Anaheim, CA, 2012.", url="http://dx.doi.org/10.1137/1.9781611972825.90")
public class GreedyEnsembleExperiment
extends AbstractApplication {
    private static final Logging LOG = Logging.getLogger(GreedyEnsembleExperiment.class);
    private InputStep inputstep;
    boolean refine_truth = false;
    EnsembleVoting voting;
    ScalingFunction prescaling;
    ScalingFunction scaling;
    double rate;
    int minvote = 1;
    Distance distance = Distance.PEARSON;

    public GreedyEnsembleExperiment(InputStep inputStep, EnsembleVoting ensembleVoting, Distance distance, ScalingFunction scalingFunction, ScalingFunction scalingFunction2, double d) {
        this.inputstep = inputStep;
        this.voting = ensembleVoting;
        this.distance = distance;
        this.prescaling = scalingFunction;
        this.scaling = scalingFunction2;
        this.rate = d;
    }

    @Override
    public void run() {
        Object object;
        Object object2;
        Object object3;
        double d;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        DBID dBID;
        Database database = this.inputstep.getDatabase();
        Relation<NumberVector> relation = database.getRelation(TypeUtil.NUMBER_VECTOR_FIELD, new Object[0]);
        NumberVector.Factory factory = RelationUtil.getNumberVectorFactory(relation);
        Relation<String> relation2 = DatabaseUtil.guessLabelRepresentation(database);
        String string = relation2.get(dBID = DBIDUtil.deref(relation2.iterDBIDs()));
        if (!string.matches("bylabel")) {
            throw new AbortException("No 'by label' reference outlier found, which is needed for weighting!");
        }
        relation = GreedyEnsembleExperiment.applyPrescaling(this.prescaling, relation, dBID);
        int n = relation.size() - 1;
        int n2 = RelationUtil.dimensionality(relation);
        NumberVector numberVector = relation.get(dBID);
        VectorNonZero vectorNonZero = new VectorNonZero(numberVector);
        int n3 = (int)(this.rate * (double)n2);
        int n4 = 0;
        int[] nArray = new int[n2];
        int n5 = 0;
        Object object8 = new ArrayList<DecreasingVectorIter>(n);
        if (this.minvote >= n) {
            this.minvote = Math.max(1, n - 1);
        }
        Object object9 = relation.iterDBIDs();
        while (object9.valid()) {
            if (!DBIDUtil.equal(dBID, (DBIDRef)object9)) {
                ((ArrayList)object8).add(new DecreasingVectorIter(relation.get((DBIDRef)object9)));
            }
            object9.advance();
        }
        block1: while (n4 < n3) {
            object9 = ((ArrayList)object8).iterator();
            while (object9.hasNext()) {
                int n6;
                object7 = (DecreasingVectorIter)object9.next();
                if (!((AbstractVectorIter)object7).valid()) {
                    LOG.warning("Union_outliers=" + n4 + " < desired_outliers=" + n3 + " minvote=" + this.minvote);
                    break block1;
                }
                int n7 = n6 = ((AbstractVectorIter)object7).dim();
                nArray[n7] = nArray[n7] + 1;
                if (nArray[n6] == this.minvote) {
                    ++n4;
                }
                ((AbstractVectorIter)object7).advance();
            }
            ++n5;
        }
        LOG.verbose("Merged top " + n5 + " outliers to: " + n4 + " outliers (desired: at least " + n3 + ")");
        double[] dArray = new double[n2];
        object8 = new double[n2];
        this.updateEstimations(nArray, n4, dArray, (double[])object8);
        object9 = factory.newNumberVector((double[])object8);
        Object object10 = object7 = this.getDistanceFunction(dArray);
        double[] dArray2 = new double[n2];
        Object object11 = new double[n];
        for (int i = 0; i < n2; ++i) {
            int n8 = 0;
            object6 = relation.iterDBIDs();
            while (object6.valid()) {
                if (!DBIDUtil.equal(dBID, (DBIDRef)object6)) {
                    NumberVector numberVector2 = relation.get((DBIDRef)object6);
                    object11[n8] = numberVector2.doubleValue(i);
                    ++n8;
                }
                object6.advance();
            }
            dArray2[i] = this.voting.combine((double[])object11, n8);
            if (!Double.isNaN(dArray2[i])) continue;
            LOG.warning("NaN after combining: " + FormatUtil.format(object11) + " i=" + n8 + " " + this.voting.toString());
        }
        object11 = factory.newNumberVector(dArray2);
        double d2 = 0.0;
        object6 = "";
        double d3 = Double.POSITIVE_INFINITY;
        String string2 = "";
        DBID dBID2 = null;
        double d4 = Double.POSITIVE_INFINITY;
        Object object12 = new double[n2];
        Object object13 = relation.iterDBIDs();
        while (object13.valid()) {
            if (!DBIDUtil.equal(dBID, (DBIDRef)object13)) {
                object5 = relation.get((DBIDRef)object13);
                this.singleEnsemble((double[])object12, (NumberVector)object5);
                object4 = new Vector((double[])object12);
                double d5 = ROCEvaluation.computeROCAUC(vectorNonZero, new DecreasingVectorIter((NumberVector)object4));
                d = object7.distance(object4, object9);
                double d6 = object10.distance(object4, numberVector);
                LOG.verbose("ROC AUC: " + d5 + " estimated " + d + " cost " + d6 + " " + relation2.get((DBIDRef)object13));
                if (d5 > d2) {
                    d2 = d5;
                    object6 = relation2.get((DBIDRef)object13);
                }
                if (d6 < d3) {
                    d3 = d6;
                    string2 = relation2.get((DBIDRef)object13);
                }
                if (d < d4 || dBID2 == null) {
                    d4 = d;
                    dBID2 = DBIDUtil.deref((DBIDRef)object13);
                }
            }
            object13.advance();
        }
        if (this.prescaling != null) {
            LOG.verbose("Input prescaling: " + this.prescaling);
        }
        LOG.verbose("Distance function: " + object7);
        LOG.verbose("Ensemble voting: " + this.voting);
        if (this.scaling != null) {
            LOG.verbose("Ensemble rescaling: " + this.scaling);
        }
        LOG.verbose("Initial estimation of outliers: " + n4);
        LOG.verbose("Initializing ensemble with: " + relation2.get(dBID2));
        object12 = DBIDUtil.newArray(dBID2);
        object13 = DBIDUtil.newHashSet(relation.getDBIDs());
        object5 = DBIDUtil.newHashSet(relation.size());
        object5.add(dBID);
        object13.remove(dBID2);
        object13.remove(dBID);
        object4 = new double[n2];
        this.singleEnsemble((double[])object4, relation.get(dBID2));
        double[] dArray3 = new double[n2];
        block6: while (object13.size() > 0) {
            double d7;
            Object object14;
            NumberVector numberVector3;
            object3 = factory.newNumberVector((double[])object4);
            d = object7.distance(object9, object3);
            int n9 = object13.size();
            ArrayList<DoubleDBIDPair> arrayList = new ArrayList<DoubleDBIDPair>(n9);
            double[] dArray4 = new double[n2];
            DBIDRef dBIDRef = object13.iter();
            while (dBIDRef.valid()) {
                numberVector3 = relation.get(dBIDRef);
                this.singleEnsemble(dArray4, numberVector3);
                object14 = new Vector((double[])object4);
                d7 = object7.distance(object14, object3);
                arrayList.add(DBIDUtil.newPair(d7, dBIDRef));
                dBIDRef.advance();
            }
            Collections.sort(arrayList);
            while (arrayList.size() > 0) {
                dBIDRef = (DBIDRef)arrayList.remove(arrayList.size() - 1);
                object13.remove(dBIDRef);
                numberVector3 = relation.get(dBIDRef);
                object14 = new double[object12.size() + 1];
                for (int i = 0; i < n2; ++i) {
                    int n10 = 0;
                    object2 = object12.iter();
                    while (object2.valid()) {
                        object14[n10] = relation.get((DBIDRef)object2).doubleValue(i);
                        ++n10;
                        object2.advance();
                    }
                    object14[n10] = numberVector3.doubleValue(i);
                    dArray3[i] = this.voting.combine((double[])object14, n10 + 1);
                }
                GreedyEnsembleExperiment.applyScaling(dArray3, this.scaling);
                object14 = factory.newNumberVector(dArray3);
                d7 = object7.distance(object9, object14);
                if (d7 < d) {
                    System.arraycopy(dArray3, 0, object4, 0, n2);
                    object12.add(dBIDRef);
                    continue block6;
                }
                object5.add(dBIDRef);
                if (!this.refine_truth) continue;
                object2 = new ArrayList(n);
                object = relation.iterDBIDs();
                while (object.valid()) {
                    if (!DBIDUtil.equal(dBID, (DBIDRef)object) && !object5.contains((DBIDRef)object)) {
                        ((ArrayList)object2).add(new DecreasingVectorIter(relation.get((DBIDRef)object)));
                    }
                    object.advance();
                }
                if (this.minvote >= ((ArrayList)object2).size()) {
                    this.minvote = ((ArrayList)object2).size() - 1;
                }
                n4 = 0;
                Arrays.fill(nArray, 0);
                while (n4 < n3) {
                    DecreasingVectorIter decreasingVectorIter;
                    object = ((ArrayList)object2).iterator();
                    while (object.hasNext() && (decreasingVectorIter = (DecreasingVectorIter)object.next()).valid()) {
                        int n11 = decreasingVectorIter.dim();
                        if (nArray[n11] == 0) {
                            nArray[n11] = 1;
                        } else {
                            int n12 = n11;
                            nArray[n12] = nArray[n12] + 1;
                        }
                        if (nArray[n11] == this.minvote) {
                            ++n4;
                        }
                        decreasingVectorIter.advance();
                    }
                }
                LOG.warning("New num outliers: " + n4);
                this.updateEstimations(nArray, n4, dArray, (double[])object8);
                object9 = factory.newNumberVector((double[])object8);
            }
        }
        object3 = new StringBuilder();
        DBIDMIter dBIDMIter = object12.iter();
        while (dBIDMIter.valid()) {
            if (((StringBuilder)object3).length() > 0) {
                ((StringBuilder)object3).append(' ');
            }
            ((StringBuilder)object3).append(relation2.get(dBIDMIter));
            dBIDMIter.advance();
        }
        dBIDMIter = factory.newNumberVector((double[])object4);
        if (this.refine_truth) {
            LOG.verbose("Estimated outliers remaining: " + n4);
        }
        LOG.verbose("Greedy ensemble (" + object12.size() + "): " + ((StringBuilder)object3).toString());
        LOG.verbose("Best single ROC AUC: " + d2 + " (" + (String)object6 + ")");
        LOG.verbose("Best single cost:    " + d3 + " (" + string2 + ")");
        double d8 = ROCEvaluation.computeROCAUC(vectorNonZero, new DecreasingVectorIter((NumberVector)object11));
        double d9 = object10.distance(object11, numberVector);
        LOG.verbose("Naive ensemble AUC:   " + d8 + " cost: " + d9);
        LOG.verbose("Naive ensemble Gain:  " + this.gain(d8, d2, 1.0) + " cost gain: " + this.gain(d9, d3, 0.0));
        double d10 = ROCEvaluation.computeROCAUC(vectorNonZero, new DecreasingVectorIter((NumberVector)((Object)dBIDMIter)));
        double d11 = object10.distance(dBIDMIter, numberVector);
        LOG.verbose("Greedy ensemble AUC:  " + d10 + " cost: " + d11);
        LOG.verbose("Greedy ensemble Gain to best:  " + this.gain(d10, d2, 1.0) + " cost gain: " + this.gain(d11, d3, 0.0));
        LOG.verbose("Greedy ensemble Gain to naive: " + this.gain(d10, d8, 1.0) + " cost gain: " + this.gain(d11, d9, 0.0));
        MeanVariance meanVariance = new MeanVariance();
        object2 = new MeanVariance();
        object = DBIDUtil.newHashSet(relation.getDBIDs());
        object.remove(dBID);
        for (int i = 0; i < 1000; ++i) {
            double[] dArray5 = new double[n2];
            ModifiableDBIDs modifiableDBIDs = DBIDUtil.randomSample((DBIDs)object, object12.size(), Long.valueOf(i));
            double[] dArray6 = new double[modifiableDBIDs.size()];
            for (int j = 0; j < n2; ++j) {
                int n13 = 0;
                DBIDIter dBIDIter = modifiableDBIDs.iter();
                while (dBIDIter.valid()) {
                    assert (!DBIDUtil.equal(dBID, dBIDIter));
                    NumberVector numberVector4 = relation.get(dBIDIter);
                    dArray6[n13] = numberVector4.doubleValue(j);
                    ++n13;
                    dBIDIter.advance();
                }
                dArray5[j] = this.voting.combine(dArray6, n13);
            }
            GreedyEnsembleExperiment.applyScaling(dArray5, this.scaling);
            modifiableDBIDs = factory.newNumberVector(dArray5);
            double d12 = ROCEvaluation.computeROCAUC(vectorNonZero, new DecreasingVectorIter((NumberVector)((Object)modifiableDBIDs)));
            meanVariance.put(d12);
            double d13 = object10.distance(modifiableDBIDs, numberVector);
            ((MeanVariance)object2).put(d13);
        }
        LOG.verbose("Random ensemble AUC:  " + meanVariance.getMean() + " + stddev: " + meanVariance.getSampleStddev() + " = " + (meanVariance.getMean() + meanVariance.getSampleStddev()));
        LOG.verbose("Random ensemble Gain: " + this.gain(meanVariance.getMean(), d2, 1.0));
        LOG.verbose("Greedy improvement:   " + (d10 - meanVariance.getMean()) / meanVariance.getSampleStddev() + " standard deviations.");
        LOG.verbose("Random ensemble Cost: " + ((MeanVariance)object2).getMean() + " + stddev: " + ((MeanVariance)object2).getSampleStddev() + " = " + (((MeanVariance)object2).getMean() + meanVariance.getSampleStddev()));
        LOG.verbose("Random ensemble Gain: " + this.gain(((MeanVariance)object2).getMean(), d3, 0.0));
        LOG.verbose("Greedy improvement:   " + (((MeanVariance)object2).getMean() - d11) / ((MeanVariance)object2).getSampleStddev() + " standard deviations.");
        LOG.verbose("Naive ensemble Gain to random: " + this.gain(d8, meanVariance.getMean(), 1.0) + " cost gain: " + this.gain(d9, ((MeanVariance)object2).getMean(), 0.0));
        LOG.verbose("Random ensemble Gain to naive: " + this.gain(meanVariance.getMean(), d8, 1.0) + " cost gain: " + this.gain(((MeanVariance)object2).getMean(), d9, 0.0));
        LOG.verbose("Greedy ensemble Gain to random: " + this.gain(d10, meanVariance.getMean(), 1.0) + " cost gain: " + this.gain(d11, ((MeanVariance)object2).getMean(), 0.0));
    }

    protected void singleEnsemble(double[] dArray, NumberVector numberVector) {
        double[] dArray2 = new double[1];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[0] = numberVector.doubleValue(i);
            dArray[i] = this.voting.combine(dArray2, 1);
            if (!Double.isNaN(dArray[i])) continue;
            LOG.warning("NaN after combining: " + FormatUtil.format(dArray2) + " " + this.voting.toString());
        }
        GreedyEnsembleExperiment.applyScaling(dArray, this.scaling);
    }

    public static Relation<NumberVector> applyPrescaling(ScalingFunction scalingFunction, Relation<NumberVector> relation, DBIDs dBIDs) {
        if (scalingFunction == null) {
            return relation;
        }
        NumberVector.Factory<NumberVector> factory = RelationUtil.getNumberVectorFactory(relation);
        DBIDs dBIDs2 = relation.getDBIDs();
        WritableDataStore<NumberVector> writableDataStore = DataStoreUtil.makeStorage(dBIDs2, 2, NumberVector.class);
        DBIDIter dBIDIter = dBIDs2.iter();
        while (dBIDIter.valid()) {
            NumberVector numberVector = relation.get(dBIDIter);
            double[] dArray = numberVector.getColumnVector().getArrayRef();
            if (!dBIDs.contains(dBIDIter)) {
                GreedyEnsembleExperiment.applyScaling(dArray, scalingFunction);
            }
            writableDataStore.put(dBIDIter, factory.newNumberVector(dArray, ArrayLikeUtil.DOUBLEARRAYADAPTER));
            dBIDIter.advance();
        }
        return new MaterializedRelation<NumberVector>(relation.getDataTypeInformation(), dBIDs2, "rescaled", writableDataStore);
    }

    private static void applyScaling(double[] dArray, ScalingFunction scalingFunction) {
        if (scalingFunction == null) {
            return;
        }
        if (scalingFunction instanceof OutlierScalingFunction) {
            ((OutlierScalingFunction)scalingFunction).prepare(dArray, ArrayLikeUtil.DOUBLEARRAYADAPTER);
        }
        for (int i = 0; i < dArray.length; ++i) {
            double d = scalingFunction.getScaled(dArray[i]);
            if (Double.isNaN(d)) {
                LOG.warning("NaN after prescaling: " + dArray[i] + " " + scalingFunction.toString() + " -> " + d);
            }
            dArray[i] = d;
        }
    }

    protected void updateEstimations(int[] nArray, int n, double[] dArray, double[] dArray2) {
        double d = 0.5 / (double)n;
        double d2 = 0.5 / (double)(nArray.length - n);
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] >= this.minvote) {
                dArray[i] = d;
                dArray2[i] = 1.0;
                continue;
            }
            dArray[i] = d2;
            dArray2[i] = 0.0;
        }
    }

    private PrimitiveDistanceFunction<NumberVector> getDistanceFunction(double[] dArray) {
        switch (this.distance) {
            case SQEUCLIDEAN: {
                return new WeightedSquaredEuclideanDistanceFunction(dArray);
            }
            case EUCLIDEAN: {
                return new WeightedEuclideanDistanceFunction(dArray);
            }
            case MANHATTAN: {
                return new WeightedManhattanDistanceFunction(dArray);
            }
            case PEARSON: {
                return new WeightedPearsonCorrelationDistanceFunction(dArray);
            }
        }
        throw new AbortException("Unsupported distance mode: " + (Object)((Object)this.distance));
    }

    double gain(double d, double d2, double d3) {
        return 1.0 - (d3 - d) / (d3 - d2);
    }

    public static void main(String[] stringArray) {
        GreedyEnsembleExperiment.runCLIApplication(GreedyEnsembleExperiment.class, stringArray);
    }

    public static class Parameterizer
    extends AbstractApplication.Parameterizer {
        public static final OptionID RATE_ID = new OptionID("greedy.rate", "Expected rate of outliers.");
        public static final OptionID VOTING_ID = new OptionID("ensemble.voting", "Ensemble voting function.");
        public static final OptionID PRESCALING_ID = new OptionID("ensemble.prescaling", "Prescaling to apply to input scores.");
        public static final OptionID SCALING_ID = new OptionID("ensemble.scaling", "Scaling to apply to ensemble.");
        public static final OptionID DISTANCE_ID = new OptionID("ensemble.measure", "Similarity measure.");
        InputStep inputstep;
        EnsembleVoting voting;
        Distance distance = Distance.PEARSON;
        ScalingFunction prescaling;
        ScalingFunction scaling;
        double rate = 0.01;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            DoubleParameter doubleParameter;
            EnumParameter<Distance> enumParameter;
            super.makeOptions(parameterization);
            this.inputstep = parameterization.tryInstantiate(InputStep.class);
            ObjectParameter objectParameter = new ObjectParameter(VOTING_ID, (Class<?>)EnsembleVoting.class, EnsembleVotingMean.class);
            if (parameterization.grab(objectParameter)) {
                this.voting = (EnsembleVoting)objectParameter.instantiateClass(parameterization);
            }
            if (parameterization.grab(enumParameter = new EnumParameter<Distance>(DISTANCE_ID, Distance.class))) {
                this.distance = (Distance)((Object)enumParameter.getValue());
            }
            ObjectParameter objectParameter2 = new ObjectParameter(PRESCALING_ID, ScalingFunction.class);
            objectParameter2.setOptional(true);
            if (parameterization.grab(objectParameter2)) {
                this.prescaling = (ScalingFunction)objectParameter2.instantiateClass(parameterization);
            }
            ObjectParameter objectParameter3 = new ObjectParameter(SCALING_ID, ScalingFunction.class);
            objectParameter3.setOptional(true);
            if (parameterization.grab(objectParameter3)) {
                this.scaling = (ScalingFunction)objectParameter3.instantiateClass(parameterization);
            }
            if (parameterization.grab(doubleParameter = new DoubleParameter(RATE_ID, 0.01))) {
                this.rate = doubleParameter.doubleValue();
            }
        }

        @Override
        protected GreedyEnsembleExperiment makeInstance() {
            return new GreedyEnsembleExperiment(this.inputstep, this.voting, this.distance, this.prescaling, this.scaling, this.rate);
        }
    }

    public static enum Distance {
        PEARSON,
        SQEUCLIDEAN,
        EUCLIDEAN,
        MANHATTAN;

    }
}

