/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.data.type;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.VectorFieldTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.VectorTypeInformation;
import de.lmu.ifi.dbs.elki.utilities.ClassGenericsUtil;
import de.lmu.ifi.dbs.elki.utilities.exceptions.UnableToComplyException;
import de.lmu.ifi.dbs.elki.utilities.io.ByteArrayUtil;
import de.lmu.ifi.dbs.elki.utilities.io.ByteBufferSerializer;
import java.io.IOException;
import java.nio.ByteBuffer;

public class TypeInformationSerializer
implements ByteBufferSerializer<TypeInformation> {
    public static final TypeInformationSerializer STATIC = new TypeInformationSerializer();
    private static final byte TAG_SIMPLE = 0;
    private static final byte TAG_VECTOR = 1;
    private static final byte TAG_VECTOR_FIELD = 2;
    static final ByteBufferSerializer<SimpleTypeInformation<?>> SIMPLE_TYPE_SERIALIZER = new SimpleTypeSerializer();
    static final ByteBufferSerializer<VectorTypeInformation<?>> VECTOR_TYPE_SERIALIZER = new VectorTypeSerializer();
    static final ByteBufferSerializer<VectorFieldTypeInformation<?>> VECTOR_FIELD_TYPE_SERIALIZER = new VectorFieldTypeSerializer();

    @Override
    public TypeInformation fromByteBuffer(ByteBuffer byteBuffer) throws IOException, UnsupportedOperationException {
        byte by = byteBuffer.get();
        switch (by) {
            case 0: {
                return SIMPLE_TYPE_SERIALIZER.fromByteBuffer(byteBuffer);
            }
            case 1: {
                return VECTOR_TYPE_SERIALIZER.fromByteBuffer(byteBuffer);
            }
            case 2: {
                return VECTOR_FIELD_TYPE_SERIALIZER.fromByteBuffer(byteBuffer);
            }
        }
        throw new UnsupportedOperationException("No deserialization known for type " + by);
    }

    @Override
    public void toByteBuffer(ByteBuffer byteBuffer, TypeInformation typeInformation) throws IOException, UnsupportedOperationException {
        Class<?> clazz = typeInformation.getClass();
        if (VectorFieldTypeInformation.class.equals(clazz)) {
            byteBuffer.put((byte)2);
            VECTOR_FIELD_TYPE_SERIALIZER.toByteBuffer(byteBuffer, (VectorFieldTypeInformation)typeInformation);
            return;
        }
        if (VectorTypeInformation.class.equals(clazz)) {
            byteBuffer.put((byte)1);
            VECTOR_TYPE_SERIALIZER.toByteBuffer(byteBuffer, (VectorTypeInformation)typeInformation);
            return;
        }
        if (SimpleTypeInformation.class.equals(clazz)) {
            byteBuffer.put((byte)0);
            SIMPLE_TYPE_SERIALIZER.toByteBuffer(byteBuffer, (SimpleTypeInformation)typeInformation);
            return;
        }
        throw new UnsupportedOperationException("Unsupported type information.");
    }

    @Override
    public int getByteSize(TypeInformation typeInformation) throws IOException, UnsupportedOperationException {
        Class<?> clazz = typeInformation.getClass();
        if (VectorFieldTypeInformation.class.equals(clazz)) {
            return 1 + VECTOR_FIELD_TYPE_SERIALIZER.getByteSize((VectorFieldTypeInformation)typeInformation);
        }
        if (VectorTypeInformation.class.equals(clazz)) {
            return 1 + VECTOR_TYPE_SERIALIZER.getByteSize((VectorTypeInformation)typeInformation);
        }
        if (SimpleTypeInformation.class.equals(clazz)) {
            return 1 + SIMPLE_TYPE_SERIALIZER.getByteSize((SimpleTypeInformation)typeInformation);
        }
        throw new UnsupportedOperationException("Unsupported type information.");
    }

    static class VectorFieldTypeSerializer
    implements ByteBufferSerializer<VectorFieldTypeInformation<?>> {
        VectorFieldTypeSerializer() {
        }

        @Override
        public VectorFieldTypeInformation<?> fromByteBuffer(ByteBuffer byteBuffer) throws IOException, UnsupportedOperationException {
            try {
                String string = ByteArrayUtil.STRING_SERIALIZER.fromByteBuffer(byteBuffer);
                NumberVector.Factory factory = ClassGenericsUtil.instantiate(NumberVector.Factory.class, string);
                String string2 = ByteArrayUtil.STRING_SERIALIZER.fromByteBuffer(byteBuffer);
                string2 = "".equals(string2) ? null : string2;
                String string3 = ByteArrayUtil.STRING_SERIALIZER.fromByteBuffer(byteBuffer);
                ByteBufferSerializer byteBufferSerializer = (ByteBufferSerializer)Class.forName(string3).newInstance();
                int n = ByteArrayUtil.readSignedVarint(byteBuffer);
                int n2 = ByteArrayUtil.readSignedVarint(byteBuffer);
                int n3 = ByteArrayUtil.readUnsignedVarint(byteBuffer);
                if (n3 > 0) {
                    assert (n == n2 && n2 == n3) : "Inconsistent dimensionality and column names!";
                    String[] stringArray = new String[n3];
                    for (int i = 0; i < n3; ++i) {
                        stringArray[i] = ByteArrayUtil.readString(byteBuffer);
                    }
                    return new VectorFieldTypeInformation(factory, n, stringArray, byteBufferSerializer);
                }
                return new VectorFieldTypeInformation(factory, n, n2, byteBufferSerializer);
            }
            catch (UnableToComplyException unableToComplyException) {
                throw new UnsupportedOperationException("Cannot deserialize - cannot instantiate factory: " + unableToComplyException, unableToComplyException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new UnsupportedOperationException("Cannot deserialize - class not found: " + classNotFoundException, classNotFoundException);
            }
            catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                throw new UnsupportedOperationException("Cannot deserialize - cannot instantiate serializer: " + reflectiveOperationException.getMessage(), reflectiveOperationException);
            }
        }

        @Override
        public void toByteBuffer(ByteBuffer byteBuffer, VectorFieldTypeInformation<?> vectorFieldTypeInformation) throws IOException, UnsupportedOperationException {
            ByteBufferSerializer byteBufferSerializer = vectorFieldTypeInformation.getSerializer();
            if (byteBufferSerializer == null) {
                throw new UnsupportedOperationException("No serializer for type " + this.toString() + " available.");
            }
            try {
                byteBufferSerializer.getClass().getDeclaredConstructor(new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new UnsupportedOperationException("No automatic serialization possible - no default constructor for serializer.");
            }
            catch (SecurityException securityException) {
                throw new UnsupportedOperationException("Serialization not possible.", securityException);
            }
            ByteArrayUtil.writeString(byteBuffer, vectorFieldTypeInformation.getFactory().getClass().getName());
            ByteArrayUtil.writeString(byteBuffer, vectorFieldTypeInformation.getLabel());
            ByteArrayUtil.writeString(byteBuffer, byteBufferSerializer.getClass().getName());
            ByteArrayUtil.writeSignedVarint(byteBuffer, vectorFieldTypeInformation.mindim());
            ByteArrayUtil.writeSignedVarint(byteBuffer, vectorFieldTypeInformation.maxdim());
            String[] stringArray = vectorFieldTypeInformation.getLabels();
            if (stringArray == null) {
                ByteArrayUtil.writeUnsignedVarint(byteBuffer, 0);
            } else {
                ByteArrayUtil.writeUnsignedVarint(byteBuffer, stringArray.length);
                for (String string : stringArray) {
                    ByteArrayUtil.writeString(byteBuffer, string);
                }
            }
        }

        @Override
        public int getByteSize(VectorFieldTypeInformation<?> vectorFieldTypeInformation) throws IOException, UnsupportedOperationException {
            ByteBufferSerializer byteBufferSerializer = vectorFieldTypeInformation.getSerializer();
            if (byteBufferSerializer == null) {
                throw new UnsupportedOperationException("No serializer for type " + this.toString() + " available.");
            }
            try {
                byteBufferSerializer.getClass().getDeclaredConstructor(new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new UnsupportedOperationException("No automatic serialization possible - no default constructor for serializer.");
            }
            catch (SecurityException securityException) {
                throw new UnsupportedOperationException("Serialization not possible.", securityException);
            }
            int n = 0;
            n += ByteArrayUtil.STRING_SERIALIZER.getByteSize(vectorFieldTypeInformation.getRestrictionClass().getName());
            n += ByteArrayUtil.STRING_SERIALIZER.getByteSize(vectorFieldTypeInformation.getLabel());
            n += ByteArrayUtil.STRING_SERIALIZER.getByteSize(byteBufferSerializer.getClass().getName());
            n += ByteArrayUtil.getSignedVarintSize(vectorFieldTypeInformation.mindim());
            n += ByteArrayUtil.getSignedVarintSize(vectorFieldTypeInformation.maxdim());
            String[] stringArray = vectorFieldTypeInformation.getLabels();
            if (stringArray == null) {
                n += ByteArrayUtil.getUnsignedVarintSize(0);
            } else {
                n += ByteArrayUtil.getUnsignedVarintSize(stringArray.length);
                for (String string : stringArray) {
                    n += ByteArrayUtil.getStringSize(string);
                }
            }
            return n;
        }
    }

    static class VectorTypeSerializer
    implements ByteBufferSerializer<VectorTypeInformation<?>> {
        VectorTypeSerializer() {
        }

        @Override
        public VectorTypeInformation<?> fromByteBuffer(ByteBuffer byteBuffer) throws IOException, UnsupportedOperationException {
            try {
                String string = ByteArrayUtil.STRING_SERIALIZER.fromByteBuffer(byteBuffer);
                NumberVector.Factory factory = ClassGenericsUtil.instantiate(NumberVector.Factory.class, string);
                String string2 = ByteArrayUtil.STRING_SERIALIZER.fromByteBuffer(byteBuffer);
                string2 = "".equals(string2) ? null : string2;
                String string3 = ByteArrayUtil.STRING_SERIALIZER.fromByteBuffer(byteBuffer);
                ByteBufferSerializer byteBufferSerializer = (ByteBufferSerializer)Class.forName(string3).newInstance();
                int n = ByteArrayUtil.readSignedVarint(byteBuffer);
                int n2 = ByteArrayUtil.readSignedVarint(byteBuffer);
                return new VectorTypeInformation(factory, byteBufferSerializer, n, n2);
            }
            catch (UnableToComplyException unableToComplyException) {
                throw new UnsupportedOperationException("Cannot deserialize - cannot instantiate factory: " + unableToComplyException, unableToComplyException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new UnsupportedOperationException("Cannot deserialize - class not found: " + classNotFoundException, classNotFoundException);
            }
            catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                throw new UnsupportedOperationException("Cannot deserialize - cannot instantiate serializer: " + reflectiveOperationException.getMessage(), reflectiveOperationException);
            }
        }

        @Override
        public void toByteBuffer(ByteBuffer byteBuffer, VectorTypeInformation<?> vectorTypeInformation) throws IOException, UnsupportedOperationException {
            ByteBufferSerializer byteBufferSerializer = vectorTypeInformation.getSerializer();
            if (byteBufferSerializer == null) {
                throw new UnsupportedOperationException("No serializer for type " + this.toString() + " available.");
            }
            try {
                byteBufferSerializer.getClass().getDeclaredConstructor(new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new UnsupportedOperationException("No automatic serialization possible - no default constructor for serializer.");
            }
            catch (SecurityException securityException) {
                throw new UnsupportedOperationException("Serialization not possible.", securityException);
            }
            ByteArrayUtil.writeString(byteBuffer, vectorTypeInformation.getFactory().getClass().getName());
            ByteArrayUtil.writeString(byteBuffer, vectorTypeInformation.getLabel());
            ByteArrayUtil.writeString(byteBuffer, byteBufferSerializer.getClass().getName());
            ByteArrayUtil.writeSignedVarint(byteBuffer, vectorTypeInformation.mindim());
            ByteArrayUtil.writeSignedVarint(byteBuffer, vectorTypeInformation.maxdim());
        }

        @Override
        public int getByteSize(VectorTypeInformation<?> vectorTypeInformation) throws IOException, UnsupportedOperationException {
            ByteBufferSerializer byteBufferSerializer = vectorTypeInformation.getSerializer();
            if (byteBufferSerializer == null) {
                throw new UnsupportedOperationException("No serializer for type " + this.toString() + " available.");
            }
            try {
                byteBufferSerializer.getClass().getDeclaredConstructor(new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new UnsupportedOperationException("No automatic serialization possible - no default constructor for serializer.");
            }
            catch (SecurityException securityException) {
                throw new UnsupportedOperationException("Serialization not possible.", securityException);
            }
            int n = 0;
            n += ByteArrayUtil.STRING_SERIALIZER.getByteSize(vectorTypeInformation.getRestrictionClass().getName());
            n += ByteArrayUtil.STRING_SERIALIZER.getByteSize(vectorTypeInformation.getLabel());
            n += ByteArrayUtil.STRING_SERIALIZER.getByteSize(byteBufferSerializer.getClass().getName());
            n += ByteArrayUtil.getSignedVarintSize(vectorTypeInformation.mindim());
            return n += ByteArrayUtil.getSignedVarintSize(vectorTypeInformation.maxdim());
        }
    }

    static class SimpleTypeSerializer
    implements ByteBufferSerializer<SimpleTypeInformation<?>> {
        SimpleTypeSerializer() {
        }

        @Override
        public SimpleTypeInformation<?> fromByteBuffer(ByteBuffer byteBuffer) throws IOException, UnsupportedOperationException {
            try {
                String string = ByteArrayUtil.STRING_SERIALIZER.fromByteBuffer(byteBuffer);
                Class<?> clazz = Class.forName(string);
                String string2 = ByteArrayUtil.STRING_SERIALIZER.fromByteBuffer(byteBuffer);
                string2 = "".equals(string2) ? null : string2;
                String string3 = ByteArrayUtil.STRING_SERIALIZER.fromByteBuffer(byteBuffer);
                ByteBufferSerializer byteBufferSerializer = (ByteBufferSerializer)Class.forName(string3).newInstance();
                return new SimpleTypeInformation(clazz, string2, byteBufferSerializer);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new UnsupportedOperationException("Cannot deserialize - class not found: " + classNotFoundException, classNotFoundException);
            }
            catch (InstantiationException instantiationException) {
                throw new UnsupportedOperationException("Cannot deserialize - cannot instantiate serializer: " + instantiationException.getMessage(), instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new UnsupportedOperationException("Cannot deserialize - cannot instantiate serializer: " + illegalAccessException.getMessage(), illegalAccessException);
            }
        }

        @Override
        public void toByteBuffer(ByteBuffer byteBuffer, SimpleTypeInformation<?> simpleTypeInformation) throws IOException, UnsupportedOperationException {
            ByteBufferSerializer<?> byteBufferSerializer = simpleTypeInformation.getSerializer();
            if (byteBufferSerializer == null) {
                throw new UnsupportedOperationException("No serializer for type " + this.toString() + " available.");
            }
            try {
                byteBufferSerializer.getClass().getDeclaredConstructor(new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new UnsupportedOperationException("No automatic serialization possible - no default constructor for serializer.");
            }
            catch (SecurityException securityException) {
                throw new UnsupportedOperationException("Serialization not possible.", securityException);
            }
            ByteArrayUtil.writeString(byteBuffer, simpleTypeInformation.getRestrictionClass().getName());
            ByteArrayUtil.writeString(byteBuffer, simpleTypeInformation.getLabel());
            ByteArrayUtil.writeString(byteBuffer, byteBufferSerializer.getClass().getName());
        }

        @Override
        public int getByteSize(SimpleTypeInformation<?> simpleTypeInformation) throws IOException, UnsupportedOperationException {
            ByteBufferSerializer<?> byteBufferSerializer = simpleTypeInformation.getSerializer();
            if (byteBufferSerializer == null) {
                throw new UnsupportedOperationException("No serializer for type " + this.toString() + " available.");
            }
            try {
                byteBufferSerializer.getClass().getDeclaredConstructor(new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new UnsupportedOperationException("No automatic serialization possible - no default constructor for serializer.");
            }
            catch (SecurityException securityException) {
                throw new UnsupportedOperationException("Serialization not possible.", securityException);
            }
            int n = 0;
            n += ByteArrayUtil.STRING_SERIALIZER.getByteSize(simpleTypeInformation.getRestrictionClass().getName());
            n += ByteArrayUtil.STRING_SERIALIZER.getByteSize(simpleTypeInformation.getLabel());
            return n += ByteArrayUtil.STRING_SERIALIZER.getByteSize(byteBufferSerializer.getClass().getName());
        }
    }
}

