/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.filter.normalization.columnwise;

import de.lmu.ifi.dbs.elki.data.SparseNumberVector;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.datasource.filter.normalization.AbstractNormalization;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import gnu.trove.iterator.TIntDoubleIterator;
import gnu.trove.map.TIntDoubleMap;
import gnu.trove.map.hash.TIntDoubleHashMap;

@Alias(value={"de.lmu.ifi.dbs.elki.datasource.filter.normalization.InverseDocumentFrequencyNormalization", "de.lmu.ifi.dbs.elki.datasource.filter.InverseDocumentFrequencyNormalization"})
public class InverseDocumentFrequencyNormalization<V extends SparseNumberVector>
extends AbstractNormalization<V> {
    private static final Logging LOG = Logging.getLogger(InverseDocumentFrequencyNormalization.class);
    TIntDoubleMap idf = new TIntDoubleHashMap();
    int objcnt = 0;

    @Override
    protected boolean prepareStart(SimpleTypeInformation<V> simpleTypeInformation) {
        if (this.idf.size() > 0) {
            throw new UnsupportedOperationException("This normalization may only be used once!");
        }
        this.objcnt = 0;
        return true;
    }

    @Override
    protected void prepareProcessInstance(V v) {
        int n = v.iter();
        while (v.iterValid(n)) {
            if (v.iterDoubleValue(n) >= 0.0) {
                int n2 = v.iterDim(n);
                this.idf.put(n2, this.idf.get(n2) + 1.0);
            }
            n = v.iterAdvance(n);
        }
        ++this.objcnt;
    }

    @Override
    protected void prepareComplete() {
        double d = this.objcnt;
        TIntDoubleIterator tIntDoubleIterator = this.idf.iterator();
        while (tIntDoubleIterator.hasNext()) {
            tIntDoubleIterator.advance();
            tIntDoubleIterator.setValue(Math.log(d / tIntDoubleIterator.value()));
        }
    }

    @Override
    protected V filterSingleObject(V v) {
        TIntDoubleHashMap tIntDoubleHashMap = new TIntDoubleHashMap();
        int n = v.iter();
        while (v.iterValid(n)) {
            int n2 = v.iterDim(n);
            tIntDoubleHashMap.put(n2, v.iterDoubleValue(n) * this.idf.get(n2));
            n = v.iterAdvance(n);
        }
        return ((SparseNumberVector.Factory)this.factory).newNumberVector(tIntDoubleHashMap, v.getDimensionality());
    }

    @Override
    public V restore(V v) {
        TIntDoubleHashMap tIntDoubleHashMap = new TIntDoubleHashMap();
        int n = v.iter();
        while (v.iterValid(n)) {
            int n2 = v.iterDim(n);
            tIntDoubleHashMap.put(n2, v.iterDoubleValue(n) / this.idf.get(n2));
            n = v.iterAdvance(n);
        }
        return ((SparseNumberVector.Factory)this.factory).newNumberVector(tIntDoubleHashMap, v.getDimensionality());
    }

    @Override
    protected SimpleTypeInformation<? super V> getInputTypeRestriction() {
        return TypeUtil.SPARSE_VECTOR_VARIABLE_LENGTH;
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }
}

