/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction.set;

import de.lmu.ifi.dbs.elki.data.BitVector;
import de.lmu.ifi.dbs.elki.data.FeatureVector;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.distance.distancefunction.NumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.set.AbstractSetDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Reference(authors="R. W. Hamming", title="Error detecting and error correcting codes", booktitle="Bell System technical journal, 29(2)", url="http://dx.doi.org/10.1002/j.1538-7305.1950.tb00463.x")
public class HammingDistanceFunction
extends AbstractSetDistanceFunction<FeatureVector<?>>
implements NumberVectorDistanceFunction<FeatureVector<?>> {
    public static final HammingDistanceFunction STATIC = new HammingDistanceFunction();

    @Override
    public boolean isMetric() {
        return true;
    }

    @Override
    public double distance(FeatureVector<?> featureVector, FeatureVector<?> featureVector2) {
        Object obj;
        int n;
        if (featureVector instanceof BitVector && featureVector2 instanceof BitVector) {
            return ((BitVector)featureVector).hammingDistance((BitVector)featureVector2);
        }
        if (featureVector instanceof NumberVector && featureVector2 instanceof NumberVector) {
            return this.hammingDistanceNumberVector((NumberVector)featureVector, (NumberVector)featureVector2);
        }
        int n2 = featureVector.getDimensionality();
        int n3 = featureVector2.getDimensionality();
        int n4 = 0;
        for (n = 0; n < n2 && n < n3; ++n) {
            obj = featureVector.getValue(n);
            Object obj2 = featureVector2.getValue(n);
            boolean bl = HammingDistanceFunction.isNull(obj);
            boolean bl2 = HammingDistanceFunction.isNull(obj2);
            if (bl && bl2 || obj instanceof Double && Double.isNaN((Double)obj) || obj2 instanceof Double && Double.isNaN((Double)obj2) || !bl && !bl2 && obj.equals(obj2)) continue;
            ++n4;
        }
        while (n < n2) {
            obj = featureVector.getValue(n);
            if (!(HammingDistanceFunction.isNull(obj) || obj instanceof Double && Double.isNaN((Double)obj))) {
                ++n4;
            }
            ++n;
        }
        while (n < n3) {
            obj = featureVector2.getValue(n);
            if (!(HammingDistanceFunction.isNull(obj) || obj instanceof Double && Double.isNaN((Double)obj))) {
                ++n4;
            }
            ++n;
        }
        return n4;
    }

    @Override
    public double distance(NumberVector numberVector, NumberVector numberVector2) {
        if (numberVector instanceof BitVector && numberVector2 instanceof BitVector) {
            return ((BitVector)numberVector).hammingDistance((BitVector)numberVector2);
        }
        return this.hammingDistanceNumberVector(numberVector, numberVector2);
    }

    private double hammingDistanceNumberVector(NumberVector numberVector, NumberVector numberVector2) {
        double d;
        int n;
        int n2 = numberVector.getDimensionality();
        int n3 = numberVector2.getDimensionality();
        int n4 = 0;
        for (n = 0; n < n2 && n < n3; ++n) {
            d = numberVector.doubleValue(n);
            double d2 = numberVector2.doubleValue(n);
            if (d != d || d2 != d2 || d == d2) continue;
            ++n4;
        }
        while (n < n2) {
            d = numberVector.doubleValue(n);
            if (d != 0.0 && d == d) {
                ++n4;
            }
            ++n;
        }
        while (n < n3) {
            d = numberVector2.doubleValue(n);
            if (d != 0.0 && d == d) {
                ++n4;
            }
            ++n;
        }
        return n4;
    }

    @Override
    public SimpleTypeInformation<? super FeatureVector<?>> getInputTypeRestriction() {
        return TypeUtil.FEATURE_VECTORS;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected HammingDistanceFunction makeInstance() {
            return STATIC;
        }
    }
}

