/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.dependence;

import de.lmu.ifi.dbs.elki.math.statistics.dependence.AbstractDependenceMeasure;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.datastructures.heap.DoubleMinHeap;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Reference(authors="Elke Achtert, Hans-Peter Kriegel, Erich Schubert, Arthur Zimek", title="Interactive Data Mining with 3D-Parallel-Coordinate-Trees", booktitle="Proc. of the 2013 ACM International Conference on Management of Data (SIGMOD)", url="http://dx.doi.org/10.1145/2463676.2463696")
public class SURFINGDependenceMeasure
extends AbstractDependenceMeasure {
    public static final SURFINGDependenceMeasure STATIC = new SURFINGDependenceMeasure();

    protected SURFINGDependenceMeasure() {
    }

    @Override
    @Reference(authors="Christian Baumgartner, Claudia Plant, Karin Kailing, Hans-Peter Kriegel, and Peer Kr\u00f6ger", title="Subspace Selection for Clustering High-Dimensional Data", booktitle="IEEE International Conference on Data Mining, 2004", url="http://dx.doi.org/10.1109/ICDM.2004.10112")
    public <A, B> double dependence(NumberArrayAdapter<?, A> numberArrayAdapter, A a, NumberArrayAdapter<?, B> numberArrayAdapter2, B b) {
        int n = SURFINGDependenceMeasure.size(numberArrayAdapter, a, numberArrayAdapter2, b);
        int n2 = Math.max(1, n / 10);
        double[] dArray = new double[n];
        DoubleMinHeap doubleMinHeap = new DoubleMinHeap(n2);
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            double d2;
            double d3 = numberArrayAdapter.getDouble(a, i);
            double d4 = numberArrayAdapter2.getDouble(b, i);
            doubleMinHeap.clear();
            for (int j = 0; j < n; ++j) {
                double d5 = numberArrayAdapter.getDouble(a, j);
                double d6 = numberArrayAdapter2.getDouble(b, j);
                double d7 = d3 - d5;
                double d8 = d4 - d6;
                doubleMinHeap.add(d7 * d7 + d8 * d8);
            }
            dArray[i] = d2 = Math.sqrt(doubleMinHeap.peek());
            d += d2;
        }
        d /= (double)n;
        double d9 = 0.0;
        int n3 = 0;
        for (int i = 0; i < dArray.length; ++i) {
            d9 += Math.abs(d - dArray[i]);
            if (!(dArray[i] < d)) continue;
            ++n3;
        }
        return n3 > 0 ? d9 / (2.0 * d * (double)n3) : 0.0;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected SURFINGDependenceMeasure makeInstance() {
            return STATIC;
        }
    }
}

