/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.result.textwriter;

import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.FeatureVector;
import de.lmu.ifi.dbs.elki.data.HierarchicalClassLabel;
import de.lmu.ifi.dbs.elki.data.LabelList;
import de.lmu.ifi.dbs.elki.data.SimpleClassLabel;
import de.lmu.ifi.dbs.elki.data.model.Model;
import de.lmu.ifi.dbs.elki.data.synthetic.bymodel.GeneratorSingleCluster;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.datasource.bundle.SingleObjectBundle;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import de.lmu.ifi.dbs.elki.result.CollectionResult;
import de.lmu.ifi.dbs.elki.result.IterableResult;
import de.lmu.ifi.dbs.elki.result.OrderingResult;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultUtil;
import de.lmu.ifi.dbs.elki.result.SettingsResult;
import de.lmu.ifi.dbs.elki.result.textwriter.StreamFactory;
import de.lmu.ifi.dbs.elki.result.textwriter.TextWriteable;
import de.lmu.ifi.dbs.elki.result.textwriter.TextWriterStream;
import de.lmu.ifi.dbs.elki.result.textwriter.TextWriterWriterInterface;
import de.lmu.ifi.dbs.elki.result.textwriter.naming.NamingScheme;
import de.lmu.ifi.dbs.elki.result.textwriter.naming.SimpleEnumeratingScheme;
import de.lmu.ifi.dbs.elki.result.textwriter.writers.TextWriterDoubleArray;
import de.lmu.ifi.dbs.elki.result.textwriter.writers.TextWriterDoubleDoublePair;
import de.lmu.ifi.dbs.elki.result.textwriter.writers.TextWriterIgnore;
import de.lmu.ifi.dbs.elki.result.textwriter.writers.TextWriterIntArray;
import de.lmu.ifi.dbs.elki.result.textwriter.writers.TextWriterObjectArray;
import de.lmu.ifi.dbs.elki.result.textwriter.writers.TextWriterObjectInline;
import de.lmu.ifi.dbs.elki.result.textwriter.writers.TextWriterPair;
import de.lmu.ifi.dbs.elki.result.textwriter.writers.TextWriterTextWriteable;
import de.lmu.ifi.dbs.elki.result.textwriter.writers.TextWriterVector;
import de.lmu.ifi.dbs.elki.utilities.HandlerList;
import de.lmu.ifi.dbs.elki.utilities.datastructures.iterator.Iter;
import de.lmu.ifi.dbs.elki.utilities.exceptions.UnableToComplyException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.TrackedParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ClassParameter;
import de.lmu.ifi.dbs.elki.utilities.pairs.DoubleDoublePair;
import de.lmu.ifi.dbs.elki.utilities.pairs.Pair;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class TextWriter {
    public static final String FILE_EXTENSION = ".txt";
    public static final HandlerList<TextWriterWriterInterface<?>> writers = new HandlerList();
    protected Map<String, Object> filenames = new HashMap<String, Object>();

    protected String getFilename(Object object, String string) {
        if (string == null || string.length() == 0) {
            string = "result";
        }
        int n = 0;
        while (true) {
            String string2;
            Object object2;
            if ((object2 = this.filenames.get(string2 = n > 0 ? string + "-" + n : string)) == null || object2 == object) {
                this.filenames.put(string2, object);
                return string2;
            }
            ++n;
        }
    }

    public void output(Database database, Result result, StreamFactory streamFactory, Pattern pattern) throws UnableToComplyException, IOException {
        Object object;
        LinkedList linkedList = new LinkedList();
        LinkedList<OrderingResult> linkedList2 = new LinkedList<OrderingResult>();
        LinkedList<Clustering> linkedList3 = new LinkedList<Clustering>();
        LinkedList<IterableResult> linkedList4 = new LinkedList<IterableResult>();
        LinkedList<SettingsResult> linkedList5 = new LinkedList<SettingsResult>();
        LinkedList<Object> linkedList6 = new LinkedList<Object>();
        Iterator iterator = ResultUtil.filterResults(database.getHierarchy(), result, Result.class);
        Iterator object22 = iterator.iterator();
        while (object22.hasNext()) {
            Object object2;
            object = (Result)object22.next();
            if (pattern != null && ((object2 = object.getShortName()) == null || !pattern.matcher((CharSequence)object2).find()) || object instanceof Database) continue;
            if (object instanceof Relation) {
                linkedList.add((Relation)object);
                continue;
            }
            if (object instanceof OrderingResult) {
                linkedList2.add((OrderingResult)object);
                continue;
            }
            if (object instanceof Clustering) {
                linkedList3.add((Clustering)object);
                continue;
            }
            if (object instanceof IterableResult) {
                linkedList4.add((IterableResult)object);
                continue;
            }
            if (object instanceof SettingsResult) {
                linkedList5.add((SettingsResult)object);
                continue;
            }
            linkedList6.add(object);
        }
        this.writeSettingsResult(streamFactory, linkedList5);
        for (IterableResult iterableResult : linkedList4) {
            this.writeIterableResult(streamFactory, iterableResult);
        }
        for (Clustering clustering : linkedList3) {
            object = new SimpleEnumeratingScheme(clustering);
            for (Cluster cluster : clustering.getAllClusters()) {
                this.writeClusterResult(database, streamFactory, clustering, cluster, linkedList, (NamingScheme)object);
            }
        }
        for (OrderingResult orderingResult : linkedList2) {
            this.writeOrderingResult(database, streamFactory, orderingResult, linkedList);
        }
        for (Result result2 : linkedList6) {
            this.writeOtherResult(streamFactory, result2);
        }
    }

    private void printObject(TextWriterStream textWriterStream, Database database, DBIDRef dBIDRef, List<Relation<?>> list) throws UnableToComplyException, IOException {
        String string;
        SingleObjectBundle singleObjectBundle = database.getBundle(dBIDRef);
        for (int i = 0; i < singleObjectBundle.metaLength(); ++i) {
            Iterator<Relation<?>> iterator = singleObjectBundle.data(i);
            if (iterator == null) continue;
            TextWriterWriterInterface<?> object = textWriterStream.getWriterFor(iterator);
            if (object == null) {
                throw new UnableToComplyException("No handler for database object itself: " + iterator.getClass().getSimpleName());
            }
            string = null;
            if (TypeUtil.DBID.isAssignableFromType(singleObjectBundle.meta(i))) {
                string = "ID";
            }
            object.writeObject(textWriterStream, string, iterator);
        }
        Collection<Relation<?>> collection = database.getRelations();
        if (list != null) {
            for (Relation<?> relation : list) {
                TextWriterWriterInterface<?> textWriterWriterInterface;
                if (collection.contains(relation)) continue;
                string = relation.getShortName();
                Object obj = relation.get(dBIDRef);
                if (obj == null || (textWriterWriterInterface = textWriterStream.getWriterFor(obj)) == null) continue;
                textWriterWriterInterface.writeObject(textWriterStream, string, obj);
            }
        }
        textWriterStream.flush();
    }

    private void writeClusterResult(Database database, StreamFactory streamFactory, Clustering<Model> clustering, Cluster<Model> cluster, List<Relation<?>> list, NamingScheme namingScheme) throws FileNotFoundException, UnableToComplyException, IOException {
        Iter iter;
        Object object;
        String string = null;
        string = namingScheme != null ? this.filenameFromLabel(namingScheme.getNameFor(cluster)) : "cluster";
        PrintStream printStream = streamFactory.openStream(this.getFilename(cluster, string));
        TextWriterStream textWriterStream = new TextWriterStream(printStream, writers);
        textWriterStream.commentPrintLn("Cluster: " + namingScheme.getNameFor(cluster));
        cluster.writeToText(textWriterStream, null);
        if (clustering.getClusterHierarchy().numParents(cluster) > 0) {
            object = new StringBuilder();
            ((StringBuilder)object).append("Parents:");
            iter = clustering.getClusterHierarchy().iterParents(cluster);
            while (iter.valid()) {
                ((StringBuilder)object).append(' ').append(namingScheme.getNameFor((Cluster)iter.get()));
                iter.advance();
            }
            textWriterStream.commentPrintLn(((StringBuilder)object).toString());
        }
        if (clustering.getClusterHierarchy().numChildren(cluster) > 0) {
            object = new StringBuilder();
            ((StringBuilder)object).append("Children:");
            iter = clustering.getClusterHierarchy().iterChildren(cluster);
            while (iter.valid()) {
                ((StringBuilder)object).append(' ').append(namingScheme.getNameFor((Cluster)iter.get()));
                iter.advance();
            }
            textWriterStream.commentPrintLn(((StringBuilder)object).toString());
        }
        textWriterStream.flush();
        object = cluster.getIDs();
        iter = object.iter();
        while (iter.valid()) {
            this.printObject(textWriterStream, database, (DBIDRef)((Object)iter), list);
            iter.advance();
        }
        textWriterStream.flush();
        streamFactory.closeStream(printStream);
    }

    private void writeIterableResult(StreamFactory streamFactory, IterableResult<?> iterableResult) throws UnableToComplyException, IOException {
        TextWriterWriterInterface<?> textWriterWriterInterface;
        Object object;
        PrintStream printStream = streamFactory.openStream(this.getFilename(iterableResult, iterableResult.getShortName()));
        TextWriterStream textWriterStream = new TextWriterStream(printStream, writers);
        if (iterableResult instanceof CollectionResult && (object = ((CollectionResult)iterableResult).getHeader()) != null) {
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                textWriterWriterInterface = (String)iterator.next();
                textWriterStream.commentPrintLn(textWriterWriterInterface);
            }
            textWriterStream.flush();
        }
        for (Iterator iterator : iterableResult) {
            textWriterWriterInterface = textWriterStream.getWriterFor(iterator);
            if (textWriterWriterInterface != null) {
                textWriterWriterInterface.writeObject(textWriterStream, null, iterator);
            }
            textWriterStream.flush();
        }
        textWriterStream.flush();
        streamFactory.closeStream(printStream);
    }

    private void writeOrderingResult(Database database, StreamFactory streamFactory, OrderingResult orderingResult, List<Relation<?>> list) throws IOException, UnableToComplyException {
        PrintStream printStream = streamFactory.openStream(this.getFilename(orderingResult, orderingResult.getShortName()));
        TextWriterStream textWriterStream = new TextWriterStream(printStream, writers);
        DBIDArrayMIter dBIDArrayMIter = orderingResult.order(orderingResult.getDBIDs()).iter();
        while (dBIDArrayMIter.valid()) {
            this.printObject(textWriterStream, database, dBIDArrayMIter, list);
            dBIDArrayMIter.advance();
        }
        textWriterStream.flush();
        streamFactory.closeStream(printStream);
    }

    private void writeSettingsResult(StreamFactory streamFactory, List<SettingsResult> list) throws UnableToComplyException, IOException {
        if (list.size() < 1) {
            return;
        }
        SettingsResult settingsResult = list.get(0);
        PrintStream printStream = streamFactory.openStream(this.getFilename(settingsResult, settingsResult.getShortName()));
        TextWriterStream textWriterStream = new TextWriterStream(printStream, writers);
        textWriterStream.commentPrintLn("Settings:");
        if (list != null) {
            for (SettingsResult settingsResult2 : list) {
                Object object = null;
                for (TrackedParameter trackedParameter : settingsResult2.getSettings()) {
                    String string;
                    if (trackedParameter.getOwner() != object && trackedParameter.getOwner() != null) {
                        if (object != null) {
                            textWriterStream.commentPrintLn("");
                        }
                        try {
                            string = trackedParameter.getOwner() instanceof Class ? ((Class)trackedParameter.getOwner()).getName() : trackedParameter.getOwner().getClass().getName();
                            if (ClassParameter.class.isInstance(trackedParameter.getOwner())) {
                                string = ((Class)((ClassParameter)trackedParameter.getOwner()).getValue()).getName();
                            }
                        }
                        catch (NullPointerException nullPointerException) {
                            string = "[null]";
                        }
                        textWriterStream.commentPrintLn(string);
                        object = trackedParameter.getOwner();
                    }
                    string = trackedParameter.getParameter().getOptionID().getName();
                    String string2 = "[unset]";
                    try {
                        if (trackedParameter.getParameter().isDefined()) {
                            string2 = trackedParameter.getParameter().getValueAsString();
                        }
                    }
                    catch (NullPointerException nullPointerException) {
                        string2 = "[null]";
                    }
                    textWriterStream.commentPrintLn("-" + string + " " + string2);
                }
            }
        }
        textWriterStream.flush();
        streamFactory.closeStream(printStream);
    }

    private void writeOtherResult(StreamFactory streamFactory, Result result) throws UnableToComplyException, IOException {
        if (writers.getHandler(result) != null) {
            PrintStream printStream = streamFactory.openStream(this.getFilename(result, result.getShortName()));
            TextWriterStream textWriterStream = new TextWriterStream(printStream, writers);
            TextWriterWriterInterface<?> textWriterWriterInterface = textWriterStream.getWriterFor(result);
            if (textWriterWriterInterface == null) {
                throw new UnableToComplyException("No handler for result class: " + result.getClass().getSimpleName());
            }
            textWriterWriterInterface.writeObject(textWriterStream, null, result);
            textWriterStream.flush();
            streamFactory.closeStream(printStream);
        }
    }

    private String filenameFromLabel(String string) {
        return string.toLowerCase().replaceAll("[^a-zA-Z0-9_.\\[\\]-]", "_");
    }

    static {
        TextWriterObjectInline textWriterObjectInline = new TextWriterObjectInline();
        TextWriterIgnore textWriterIgnore = new TextWriterIgnore();
        writers.insertHandler(Pair.class, new TextWriterPair());
        writers.insertHandler(DoubleDoublePair.class, new TextWriterDoubleDoublePair());
        writers.insertHandler(FeatureVector.class, textWriterObjectInline);
        writers.insertHandler(double[].class, new TextWriterDoubleArray());
        writers.insertHandler(int[].class, new TextWriterIntArray());
        writers.insertHandler(String.class, textWriterObjectInline);
        writers.insertHandler(Double.class, textWriterObjectInline);
        writers.insertHandler(Integer.class, textWriterObjectInline);
        writers.insertHandler(String[].class, new TextWriterObjectArray());
        writers.insertHandler(Double[].class, new TextWriterObjectArray());
        writers.insertHandler(Integer[].class, new TextWriterObjectArray());
        writers.insertHandler(Vector.class, new TextWriterVector());
        writers.insertHandler(SimpleClassLabel.class, textWriterObjectInline);
        writers.insertHandler(HierarchicalClassLabel.class, textWriterObjectInline);
        writers.insertHandler(LabelList.class, textWriterObjectInline);
        writers.insertHandler(DBID.class, textWriterObjectInline);
        writers.insertHandler(GeneratorSingleCluster.class, textWriterIgnore);
        writers.insertHandler(TextWriteable.class, new TextWriterTextWriteable());
    }
}

