/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.datastructures.histogram;

import de.lmu.ifi.dbs.elki.utilities.datastructures.histogram.AbstractStaticHistogram;
import de.lmu.ifi.dbs.elki.utilities.datastructures.histogram.ObjHistogram;

public abstract class AbstractObjStaticHistogram<T>
extends AbstractStaticHistogram
implements ObjHistogram<T> {
    Object[] data;
    Object[] special = null;

    public AbstractObjStaticHistogram(int n, double d, double d2) {
        super(n, d, d2);
        if (n >= 0) {
            this.data = new Object[n];
            for (int i = 0; i < n; ++i) {
                this.data[i] = this.makeObject();
            }
        }
    }

    public T get(double d) {
        if (d == Double.NEGATIVE_INFINITY) {
            return this.getSpecial(0);
        }
        if (d == Double.POSITIVE_INFINITY) {
            return this.getSpecial(1);
        }
        if (Double.isNaN(d)) {
            return this.getSpecial(2);
        }
        int n = this.getBinNr(d);
        if (n < 0) {
            if (this.size - n > this.data.length) {
                Object[] objectArray = new Object[AbstractObjStaticHistogram.growSize(this.data.length, this.size - n)];
                System.arraycopy(this.data, 0, objectArray, -n, this.size);
                this.data = objectArray;
            } else {
                System.arraycopy(this.data, 0, this.data, -n, this.size);
            }
            for (int i = 0; i < -n; ++i) {
                this.data[i] = this.makeObject();
            }
            this.offset -= n;
            this.size -= n;
            this.max = Double.MAX_VALUE;
            return (T)this.data[0];
        }
        if (n >= this.size) {
            if (n >= this.data.length) {
                Object[] objectArray = new Object[AbstractObjStaticHistogram.growSize(this.data.length, n + 1)];
                System.arraycopy(this.data, 0, objectArray, 0, this.size);
                this.data = objectArray;
            }
            for (int i = this.size; i <= n; ++i) {
                this.data[i] = this.makeObject();
            }
            this.size = n + 1;
            this.max = Double.MAX_VALUE;
            return (T)this.data[n];
        }
        return (T)this.data[n];
    }

    protected T getSpecial(int n) {
        if (this.special == null) {
            this.special = new Object[]{this.makeObject(), this.makeObject(), this.makeObject()};
        }
        return (T)this.special[n];
    }

    protected abstract T makeObject();

    @Override
    public Iter iter() {
        return new Iter();
    }

    public class Iter
    extends AbstractStaticHistogram.Iter
    implements ObjHistogram.Iter<T> {
        public Iter() {
            super(AbstractObjStaticHistogram.this);
        }

        @Override
        public T getValue() {
            return AbstractObjStaticHistogram.this.data[this.bin];
        }
    }
}

