/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.scaling.outlier;

import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.relation.DoubleRelation;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.scaling.outlier.OutlierScalingFunction;

@Reference(authors="H.-P. Kriegel, P. Kr\u00f6ger, E. Schubert, A. Zimek", title="Interpreting and Unifying Outlier Scores", booktitle="Proc. 11th SIAM International Conference on Data Mining (SDM), Mesa, AZ, 2011", url="http://dx.doi.org/10.1137/1.9781611972818.2")
public class MultiplicativeInverseScaling
implements OutlierScalingFunction {
    double scaleval = 0.0;

    @Override
    public double getScaled(double d) {
        assert (this.scaleval != 0.0) : "prepare() was not run prior to using the scaling function.";
        try {
            return 1.0 / (d * this.scaleval);
        }
        catch (ArithmeticException arithmeticException) {
            return 1.0;
        }
    }

    @Override
    public void prepare(OutlierResult outlierResult) {
        double d = Double.MIN_VALUE;
        DoubleRelation doubleRelation = outlierResult.getScores();
        DBIDIter dBIDIter = doubleRelation.iterDBIDs();
        while (dBIDIter.valid()) {
            double d2 = doubleRelation.doubleValue(dBIDIter);
            double d3 = Math.abs(1.0 / d2);
            if (!Double.isInfinite(d3) && !Double.isNaN(d3)) {
                d = Math.max(d, d3);
            }
            dBIDIter.advance();
        }
        this.scaleval = d;
    }

    @Override
    public <A> void prepare(A a, NumberArrayAdapter<?, A> numberArrayAdapter) {
        double d = Double.MIN_VALUE;
        int n = numberArrayAdapter.size(a);
        for (int i = 0; i < n; ++i) {
            double d2 = Math.abs(1.0 / numberArrayAdapter.getDouble(a, i));
            if (Double.isInfinite(d2) || Double.isNaN(d2)) continue;
            d = Math.max(d, d2);
        }
        this.scaleval = d;
    }

    @Override
    public double getMin() {
        return 0.0;
    }

    @Override
    public double getMax() {
        return 1.0;
    }
}

