/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.batikutil;

import de.lmu.ifi.dbs.elki.visualization.svg.UpdateRunner;
import de.lmu.ifi.dbs.elki.visualization.svg.UpdateSynchronizer;
import java.lang.ref.WeakReference;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.batik.bridge.UpdateManager;
import org.apache.batik.bridge.UpdateManagerAdapter;
import org.apache.batik.bridge.UpdateManagerEvent;
import org.apache.batik.swing.svg.JSVGComponent;

class JSVGUpdateSynchronizer
implements UpdateSynchronizer {
    private final WeakReference<JSVGComponent> cref;
    private Set<WeakReference<UpdateRunner>> updaterunner = new CopyOnWriteArraySet<WeakReference<UpdateRunner>>();
    private final UMAdapter umadapter = new UMAdapter();
    private final AtomicReference<Runnable> pending = new AtomicReference();

    protected JSVGUpdateSynchronizer(JSVGComponent jSVGComponent) {
        assert (jSVGComponent != null);
        this.cref = new WeakReference<JSVGComponent>(jSVGComponent);
        jSVGComponent.addUpdateManagerListener(this.umadapter);
    }

    @Override
    public void activate() {
        this.makeRunnerIfNeeded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void makeRunnerIfNeeded() {
        Object object;
        WeakReference<UpdateRunner> weakReference2;
        boolean bl = true;
        for (WeakReference<UpdateRunner> weakReference2 : this.updaterunner) {
            object = (UpdateRunner)weakReference2.get();
            if (object == null) {
                this.updaterunner.remove(weakReference2);
                continue;
            }
            if (((UpdateRunner)object).isEmpty()) continue;
            bl = false;
        }
        if (bl) {
            return;
        }
        if (this.pending.get() != null) {
            return;
        }
        JSVGComponent jSVGComponent = (JSVGComponent)this.cref.get();
        if (jSVGComponent == null) {
            return;
        }
        weakReference2 = this;
        synchronized (weakReference2) {
            object = jSVGComponent;
            synchronized (object) {
                UpdateManager updateManager = jSVGComponent.getUpdateManager();
                if (updateManager != null) {
                    UpdateManager updateManager2 = updateManager;
                    synchronized (updateManager2) {
                        if (updateManager.isRunning()) {
                            Runnable runnable = new Runnable(){

                                @Override
                                public void run() {
                                    if (JSVGUpdateSynchronizer.this.pending.compareAndSet(this, null)) {
                                        for (WeakReference weakReference : JSVGUpdateSynchronizer.this.updaterunner) {
                                            UpdateRunner updateRunner = (UpdateRunner)weakReference.get();
                                            if (updateRunner == null || updateRunner.isEmpty()) continue;
                                            updateRunner.runQueue();
                                        }
                                    }
                                }
                            };
                            this.pending.set(runnable);
                            updateManager.getUpdateRunnableQueue().invokeLater(runnable);
                            return;
                        }
                    }
                }
            }
        }
    }

    @Override
    public void addUpdateRunner(UpdateRunner updateRunner) {
        for (WeakReference<UpdateRunner> weakReference : this.updaterunner) {
            if (weakReference.get() != null) continue;
            this.updaterunner.remove(weakReference);
        }
        this.updaterunner.add(new WeakReference<UpdateRunner>(updateRunner));
    }

    private class UMAdapter
    extends UpdateManagerAdapter {
        protected UMAdapter() {
        }

        @Override
        public void managerStarted(UpdateManagerEvent updateManagerEvent) {
            JSVGUpdateSynchronizer.this.makeRunnerIfNeeded();
        }

        @Override
        public void managerStopped(UpdateManagerEvent updateManagerEvent) {
            JSVGUpdateSynchronizer.this.pending.set(null);
        }
    }
}

