/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.bayes.net;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import weka.classifiers.bayes.BayesNet;
import weka.classifiers.bayes.net.BIFReader;
import weka.classifiers.bayes.net.ParentSet;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;

public class MarginCalculator
implements Serializable,
RevisionHandler {
    private static final long serialVersionUID = 650278019241175534L;
    boolean m_debug = false;
    public JunctionTreeNode m_root = null;
    JunctionTreeNode[] jtNodes;
    double[][] m_Margins;

    public int getNode(String sNodeName) {
        int iNode = 0;
        while (iNode < this.m_root.m_bayesNet.m_Instances.numAttributes()) {
            if (this.m_root.m_bayesNet.m_Instances.attribute(iNode).name().equals(sNodeName)) {
                return iNode;
            }
            ++iNode;
        }
        return -1;
    }

    public String toXMLBIF03() {
        return this.m_root.m_bayesNet.toXMLBIF03();
    }

    public void calcMargins(BayesNet bayesNet) throws Exception {
        boolean[][] bAdjacencyMatrix = this.moralize(bayesNet);
        this.process(bAdjacencyMatrix, bayesNet);
    }

    public void calcFullMargins(BayesNet bayesNet) throws Exception {
        int nNodes = bayesNet.getNrOfNodes();
        boolean[][] bAdjacencyMatrix = new boolean[nNodes][nNodes];
        int iNode = 0;
        while (iNode < nNodes) {
            int iNode2 = 0;
            while (iNode2 < nNodes) {
                bAdjacencyMatrix[iNode][iNode2] = true;
                ++iNode2;
            }
            ++iNode;
        }
        this.process(bAdjacencyMatrix, bayesNet);
    }

    public void process(boolean[][] bAdjacencyMatrix, BayesNet bayesNet) throws Exception {
        int iNode;
        int i;
        int[] order = this.getMaxCardOrder(bAdjacencyMatrix);
        bAdjacencyMatrix = this.fillIn(order, bAdjacencyMatrix);
        order = this.getMaxCardOrder(bAdjacencyMatrix);
        Set<Integer>[] cliques = this.getCliques(order, bAdjacencyMatrix);
        Set<Integer>[] separators = this.getSeparators(order, cliques);
        int[] parentCliques = this.getCliqueTree(order, cliques, separators);
        int nNodes = bAdjacencyMatrix.length;
        if (this.m_debug) {
            i = 0;
            while (i < nNodes) {
                iNode = order[i];
                if (cliques[iNode] != null) {
                    int iNode2;
                    System.out.print("Clique " + iNode + " (");
                    Iterator<Integer> nodes = cliques[iNode].iterator();
                    while (nodes.hasNext()) {
                        iNode2 = nodes.next();
                        System.out.print(String.valueOf(iNode2) + " " + bayesNet.getNodeName(iNode2));
                        if (!nodes.hasNext()) continue;
                        System.out.print(",");
                    }
                    System.out.print(") S(");
                    nodes = separators[iNode].iterator();
                    while (nodes.hasNext()) {
                        iNode2 = nodes.next();
                        System.out.print(String.valueOf(iNode2) + " " + bayesNet.getNodeName(iNode2));
                        if (!nodes.hasNext()) continue;
                        System.out.print(",");
                    }
                    System.out.println(") parent clique " + parentCliques[iNode]);
                }
                ++i;
            }
        }
        this.jtNodes = this.getJunctionTree(cliques, separators, parentCliques, order, bayesNet);
        this.m_root = null;
        int iNode2 = 0;
        while (iNode2 < nNodes) {
            if (parentCliques[iNode2] < 0 && this.jtNodes[iNode2] != null) {
                this.m_root = this.jtNodes[iNode2];
                break;
            }
            ++iNode2;
        }
        this.m_Margins = new double[nNodes][];
        this.initialize(this.jtNodes, order, cliques, separators, parentCliques);
        i = 0;
        while (i < nNodes) {
            iNode = order[i];
            if (cliques[iNode] != null && parentCliques[iNode] == -1 && separators[iNode].size() > 0) {
                throw new Exception("Something wrong in clique tree");
            }
            ++i;
        }
    }

    void initialize(JunctionTreeNode[] jtNodes, int[] order, Set<Integer>[] cliques, Set<Integer>[] separators, int[] parentCliques) {
        int iNode;
        int nNodes = order.length;
        int i = nNodes - 1;
        while (i >= 0) {
            iNode = order[i];
            if (jtNodes[iNode] != null) {
                jtNodes[iNode].initializeUp();
            }
            --i;
        }
        i = 0;
        while (i < nNodes) {
            iNode = order[i];
            if (jtNodes[iNode] != null) {
                jtNodes[iNode].initializeDown(false);
            }
            ++i;
        }
    }

    JunctionTreeNode[] getJunctionTree(Set<Integer>[] cliques, Set<Integer>[] separators, int[] parentCliques, int[] order, BayesNet bayesNet) {
        int iNode;
        int nNodes = order.length;
        JunctionTreeNode[] jtns = new JunctionTreeNode[nNodes];
        boolean[] bDone = new boolean[nNodes];
        int i = 0;
        while (i < nNodes) {
            iNode = order[i];
            if (cliques[iNode] != null) {
                jtns[iNode] = new JunctionTreeNode(cliques[iNode], bayesNet, bDone);
            }
            ++i;
        }
        i = 0;
        while (i < nNodes) {
            iNode = order[i];
            if (cliques[iNode] != null) {
                JunctionTreeNode parent = null;
                if (parentCliques[iNode] > 0) {
                    parent = jtns[parentCliques[iNode]];
                    JunctionTreeSeparator jts = new JunctionTreeSeparator(separators[iNode], bayesNet, jtns[iNode], parent);
                    jtns[iNode].setParentSeparator(jts);
                    jtns[parentCliques[iNode]].addChildClique(jtns[iNode]);
                }
            }
            ++i;
        }
        return jtns;
    }

    int getCPT(int[] nodeSet, int nNodes, int[] values, int[] order, BayesNet bayesNet) {
        int iCPTnew = 0;
        int iNode = 0;
        while (iNode < nNodes) {
            int nNode = nodeSet[iNode];
            iCPTnew *= bayesNet.getCardinality(nNode);
            iCPTnew += values[order[nNode]];
            ++iNode;
        }
        return iCPTnew;
    }

    int[] getCliqueTree(int[] order, Set<Integer>[] cliques, Set<Integer>[] separators) {
        int nNodes = order.length;
        int[] parentCliques = new int[nNodes];
        int i = 0;
        while (i < nNodes) {
            int iNode = order[i];
            parentCliques[iNode] = -1;
            if (cliques[iNode] != null && separators[iNode].size() > 0) {
                int j = 0;
                while (j < nNodes) {
                    int iNode2 = order[j];
                    if (iNode != iNode2 && cliques[iNode2] != null && cliques[iNode2].containsAll(separators[iNode])) {
                        parentCliques[iNode] = iNode2;
                        j = i;
                        j = 0;
                        j = nNodes;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return parentCliques;
    }

    Set<Integer>[] getSeparators(int[] order, Set<Integer>[] cliques) {
        int nNodes = order.length;
        HashSet[] separators = new HashSet[nNodes];
        HashSet<Integer> processedNodes = new HashSet<Integer>();
        int i = 0;
        while (i < nNodes) {
            int iNode = order[i];
            if (cliques[iNode] != null) {
                HashSet<Integer> separator = new HashSet<Integer>();
                separator.addAll(cliques[iNode]);
                separator.retainAll(processedNodes);
                separators[iNode] = separator;
                processedNodes.addAll(cliques[iNode]);
            }
            ++i;
        }
        return separators;
    }

    Set<Integer>[] getCliques(int[] order, boolean[][] bAdjacencyMatrix) throws Exception {
        int iNode;
        int nNodes = bAdjacencyMatrix.length;
        HashSet[] cliques = new HashSet[nNodes];
        int i = nNodes - 1;
        while (i >= 0) {
            iNode = order[i];
            HashSet<Integer> clique = new HashSet<Integer>();
            clique.add(iNode);
            int j = 0;
            while (j < i) {
                int iNode2 = order[j];
                if (bAdjacencyMatrix[iNode][iNode2]) {
                    clique.add(iNode2);
                }
                ++j;
            }
            cliques[iNode] = clique;
            --i;
        }
        int iNode2 = 0;
        while (iNode2 < nNodes) {
            int iNode22 = 0;
            while (iNode22 < nNodes) {
                if (iNode2 != iNode22 && cliques[iNode2] != null && cliques[iNode22] != null && cliques[iNode2].containsAll(cliques[iNode22])) {
                    cliques[iNode22] = null;
                }
                ++iNode22;
            }
            ++iNode2;
        }
        if (this.m_debug) {
            int[] nNodeSet = new int[nNodes];
            iNode = 0;
            while (iNode < nNodes) {
                if (cliques[iNode] != null) {
                    Iterator it = cliques[iNode].iterator();
                    int k = 0;
                    while (it.hasNext()) {
                        nNodeSet[k++] = (Integer)it.next();
                    }
                    int i2 = 0;
                    while (i2 < cliques[iNode].size()) {
                        int j = 0;
                        while (j < cliques[iNode].size()) {
                            if (i2 != j && !bAdjacencyMatrix[nNodeSet[i2]][nNodeSet[j]]) {
                                throw new Exception("Non clique" + i2 + " " + j);
                            }
                            ++j;
                        }
                        ++i2;
                    }
                }
                ++iNode;
            }
        }
        return cliques;
    }

    public boolean[][] moralize(BayesNet bayesNet) {
        int nNodes = bayesNet.getNrOfNodes();
        boolean[][] bAdjacencyMatrix = new boolean[nNodes][nNodes];
        int iNode = 0;
        while (iNode < nNodes) {
            ParentSet parents = bayesNet.getParentSets()[iNode];
            this.moralizeNode(parents, iNode, bAdjacencyMatrix);
            ++iNode;
        }
        return bAdjacencyMatrix;
    }

    private void moralizeNode(ParentSet parents, int iNode, boolean[][] bAdjacencyMatrix) {
        int iParent = 0;
        while (iParent < parents.getNrOfParents()) {
            int nParent = parents.getParent(iParent);
            if (this.m_debug && !bAdjacencyMatrix[iNode][nParent]) {
                System.out.println("Insert " + iNode + "--" + nParent);
            }
            bAdjacencyMatrix[iNode][nParent] = true;
            bAdjacencyMatrix[nParent][iNode] = true;
            int iParent2 = iParent + 1;
            while (iParent2 < parents.getNrOfParents()) {
                int nParent2 = parents.getParent(iParent2);
                if (this.m_debug && !bAdjacencyMatrix[nParent2][nParent]) {
                    System.out.println("Mary " + nParent + "--" + nParent2);
                }
                bAdjacencyMatrix[nParent2][nParent] = true;
                bAdjacencyMatrix[nParent][nParent2] = true;
                ++iParent2;
            }
            ++iParent;
        }
    }

    public boolean[][] fillIn(int[] order, boolean[][] bAdjacencyMatrix) {
        int nNodes = bAdjacencyMatrix.length;
        int[] inverseOrder = new int[nNodes];
        int iNode = 0;
        while (iNode < nNodes) {
            inverseOrder[order[iNode]] = iNode;
            ++iNode;
        }
        int i = nNodes - 1;
        while (i >= 0) {
            int iNode2 = order[i];
            int j = 0;
            while (j < i) {
                int iNode22 = order[j];
                if (bAdjacencyMatrix[iNode2][iNode22]) {
                    int k = j + 1;
                    while (k < i) {
                        int iNode3 = order[k];
                        if (bAdjacencyMatrix[iNode2][iNode3]) {
                            if (!(!this.m_debug || bAdjacencyMatrix[iNode22][iNode3] && bAdjacencyMatrix[iNode3][iNode22])) {
                                System.out.println("Fill in " + iNode22 + "--" + iNode3);
                            }
                            bAdjacencyMatrix[iNode22][iNode3] = true;
                            bAdjacencyMatrix[iNode3][iNode22] = true;
                        }
                        ++k;
                    }
                }
                ++j;
            }
            --i;
        }
        return bAdjacencyMatrix;
    }

    int[] getMaxCardOrder(boolean[][] bAdjacencyMatrix) {
        int nNodes = bAdjacencyMatrix.length;
        int[] order = new int[nNodes];
        if (nNodes == 0) {
            return order;
        }
        boolean[] bDone = new boolean[nNodes];
        order[0] = 0;
        bDone[0] = true;
        int iNode = 1;
        while (iNode < nNodes) {
            int nMaxCard = -1;
            int iBestNode = -1;
            int iNode2 = 0;
            while (iNode2 < nNodes) {
                if (!bDone[iNode2]) {
                    int nCard = 0;
                    int iNode3 = 0;
                    while (iNode3 < nNodes) {
                        if (bAdjacencyMatrix[iNode2][iNode3] && bDone[iNode3]) {
                            ++nCard;
                        }
                        ++iNode3;
                    }
                    if (nCard > nMaxCard) {
                        nMaxCard = nCard;
                        iBestNode = iNode2;
                    }
                }
                ++iNode2;
            }
            order[iNode] = iBestNode;
            bDone[iBestNode] = true;
            ++iNode;
        }
        return order;
    }

    public void setEvidence(int nNode, int iValue) throws Exception {
        if (this.m_root == null) {
            throw new Exception("Junction tree not initialize yet");
        }
        int iJtNode = 0;
        while (!(iJtNode >= this.jtNodes.length || this.jtNodes[iJtNode] != null && this.jtNodes[iJtNode].contains(nNode))) {
            ++iJtNode;
        }
        if (this.jtNodes.length == iJtNode) {
            throw new Exception("Could not find node " + nNode + " in junction tree");
        }
        this.jtNodes[iJtNode].setEvidence(nNode, iValue);
    }

    public String toString() {
        return this.m_root.toString();
    }

    public double[] getMargin(int iNode) {
        return this.m_Margins[iNode];
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 10154 $");
    }

    public static void main(String[] args) {
        try {
            BIFReader bayesNet = new BIFReader();
            bayesNet.processFile(args[0]);
            MarginCalculator dc = new MarginCalculator();
            dc.calcMargins(bayesNet);
            int iNode = 2;
            int iValue = 0;
            int iNode2 = 4;
            int iValue2 = 0;
            dc.setEvidence(iNode, iValue);
            dc.setEvidence(iNode2, iValue2);
            System.out.print(dc.toString());
            dc.calcFullMargins(bayesNet);
            dc.setEvidence(iNode, iValue);
            dc.setEvidence(iNode2, iValue2);
            System.out.println("==============");
            System.out.print(dc.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public class JunctionTreeNode
    implements Serializable,
    RevisionHandler {
        private static final long serialVersionUID = 650278019241175536L;
        BayesNet m_bayesNet;
        public int[] m_nNodes;
        int m_nCardinality;
        double[] m_fi;
        double[] m_P;
        double[][] m_MarginalP;
        JunctionTreeSeparator m_parentSeparator;
        public Vector<JunctionTreeNode> m_children;

        public void setParentSeparator(JunctionTreeSeparator parentSeparator) {
            this.m_parentSeparator = parentSeparator;
        }

        public void addChildClique(JunctionTreeNode child) {
            this.m_children.add(child);
        }

        public void initializeUp() {
            this.m_P = new double[this.m_nCardinality];
            int iPos = 0;
            while (iPos < this.m_nCardinality) {
                this.m_P[iPos] = this.m_fi[iPos];
                ++iPos;
            }
            int[] values = new int[this.m_nNodes.length];
            int[] order = new int[this.m_bayesNet.getNrOfNodes()];
            int iNode = 0;
            while (iNode < this.m_nNodes.length) {
                order[this.m_nNodes[iNode]] = iNode;
                ++iNode;
            }
            Iterator<JunctionTreeNode> iterator = this.m_children.iterator();
            while (iterator.hasNext()) {
                JunctionTreeNode element;
                JunctionTreeNode childNode = element = iterator.next();
                JunctionTreeSeparator separator = childNode.m_parentSeparator;
                int iPos2 = 0;
                while (iPos2 < this.m_nCardinality) {
                    int i;
                    int iNodeCPT;
                    int iSepCPT = MarginCalculator.this.getCPT(separator.m_nNodes, separator.m_nNodes.length, values, order, this.m_bayesNet);
                    int n = iNodeCPT = MarginCalculator.this.getCPT(this.m_nNodes, this.m_nNodes.length, values, order, this.m_bayesNet);
                    this.m_P[n] = this.m_P[n] * separator.m_fiChild[iSepCPT];
                    int n2 = i = 0;
                    values[n2] = values[n2] + 1;
                    while (i < this.m_nNodes.length && values[i] == this.m_bayesNet.getCardinality(this.m_nNodes[i])) {
                        values[i] = 0;
                        if (++i >= this.m_nNodes.length) continue;
                        int n3 = i;
                        values[n3] = values[n3] + 1;
                    }
                    ++iPos2;
                }
            }
            double sum = 0.0;
            int iPos3 = 0;
            while (iPos3 < this.m_nCardinality) {
                sum += this.m_P[iPos3];
                ++iPos3;
            }
            iPos3 = 0;
            while (iPos3 < this.m_nCardinality) {
                int n = iPos3++;
                this.m_P[n] = this.m_P[n] / sum;
            }
            if (this.m_parentSeparator != null) {
                this.m_parentSeparator.updateFromChild();
            }
        }

        public void initializeDown(boolean recursively) {
            if (this.m_parentSeparator == null) {
                this.calcMarginalProbabilities();
            } else {
                this.m_parentSeparator.updateFromParent();
                int[] values = new int[this.m_nNodes.length];
                int[] order = new int[this.m_bayesNet.getNrOfNodes()];
                int iNode = 0;
                while (iNode < this.m_nNodes.length) {
                    order[this.m_nNodes[iNode]] = iNode;
                    ++iNode;
                }
                int iPos = 0;
                while (iPos < this.m_nCardinality) {
                    int i;
                    int iSepCPT = MarginCalculator.this.getCPT(this.m_parentSeparator.m_nNodes, this.m_parentSeparator.m_nNodes.length, values, order, this.m_bayesNet);
                    int iNodeCPT = MarginCalculator.this.getCPT(this.m_nNodes, this.m_nNodes.length, values, order, this.m_bayesNet);
                    if (this.m_parentSeparator.m_fiChild[iSepCPT] > 0.0) {
                        int n = iNodeCPT;
                        this.m_P[n] = this.m_P[n] * (this.m_parentSeparator.m_fiParent[iSepCPT] / this.m_parentSeparator.m_fiChild[iSepCPT]);
                    } else {
                        this.m_P[iNodeCPT] = 0.0;
                    }
                    int n = i = 0;
                    values[n] = values[n] + 1;
                    while (i < this.m_nNodes.length && values[i] == this.m_bayesNet.getCardinality(this.m_nNodes[i])) {
                        values[i] = 0;
                        if (++i >= this.m_nNodes.length) continue;
                        int n2 = i;
                        values[n2] = values[n2] + 1;
                    }
                    ++iPos;
                }
                double sum = 0.0;
                int iPos2 = 0;
                while (iPos2 < this.m_nCardinality) {
                    sum += this.m_P[iPos2];
                    ++iPos2;
                }
                iPos2 = 0;
                while (iPos2 < this.m_nCardinality) {
                    int n = iPos2++;
                    this.m_P[n] = this.m_P[n] / sum;
                }
                this.m_parentSeparator.updateFromChild();
                this.calcMarginalProbabilities();
            }
            if (recursively) {
                Iterator<JunctionTreeNode> iterator = this.m_children.iterator();
                while (iterator.hasNext()) {
                    JunctionTreeNode element;
                    JunctionTreeNode childNode = element = iterator.next();
                    childNode.initializeDown(true);
                }
            }
        }

        void calcMarginalProbabilities() {
            int[] values = new int[this.m_nNodes.length];
            int[] order = new int[this.m_bayesNet.getNrOfNodes()];
            this.m_MarginalP = new double[this.m_nNodes.length][];
            int iNode = 0;
            while (iNode < this.m_nNodes.length) {
                order[this.m_nNodes[iNode]] = iNode;
                this.m_MarginalP[iNode] = new double[this.m_bayesNet.getCardinality(this.m_nNodes[iNode])];
                ++iNode;
            }
            int iPos = 0;
            while (iPos < this.m_nCardinality) {
                int i;
                int iNodeCPT = MarginCalculator.this.getCPT(this.m_nNodes, this.m_nNodes.length, values, order, this.m_bayesNet);
                int iNode2 = 0;
                while (iNode2 < this.m_nNodes.length) {
                    double[] dArray = this.m_MarginalP[iNode2];
                    int n = values[iNode2];
                    dArray[n] = dArray[n] + this.m_P[iNodeCPT];
                    ++iNode2;
                }
                int n = i = 0;
                values[n] = values[n] + 1;
                while (i < this.m_nNodes.length && values[i] == this.m_bayesNet.getCardinality(this.m_nNodes[i])) {
                    values[i] = 0;
                    if (++i >= this.m_nNodes.length) continue;
                    int n2 = i;
                    values[n2] = values[n2] + 1;
                }
                ++iPos;
            }
            iNode = 0;
            while (iNode < this.m_nNodes.length) {
                MarginCalculator.this.m_Margins[this.m_nNodes[iNode]] = this.m_MarginalP[iNode];
                ++iNode;
            }
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            int iNode = 0;
            while (iNode < this.m_nNodes.length) {
                buf.append(String.valueOf(this.m_bayesNet.getNodeName(this.m_nNodes[iNode])) + ": ");
                int iValue = 0;
                while (iValue < this.m_MarginalP[iNode].length) {
                    buf.append(String.valueOf(this.m_MarginalP[iNode][iValue]) + " ");
                    ++iValue;
                }
                buf.append('\n');
                ++iNode;
            }
            Iterator<JunctionTreeNode> iterator = this.m_children.iterator();
            while (iterator.hasNext()) {
                JunctionTreeNode element;
                JunctionTreeNode childNode = element = iterator.next();
                buf.append("----------------\n");
                buf.append(childNode.toString());
            }
            return buf.toString();
        }

        void calculatePotentials(BayesNet bayesNet, Set<Integer> clique, boolean[] bDone) {
            this.m_fi = new double[this.m_nCardinality];
            int[] values = new int[this.m_nNodes.length];
            int[] order = new int[bayesNet.getNrOfNodes()];
            int iNode = 0;
            while (iNode < this.m_nNodes.length) {
                order[this.m_nNodes[iNode]] = iNode;
                ++iNode;
            }
            boolean[] bIsContained = new boolean[this.m_nNodes.length];
            int iNode2 = 0;
            while (iNode2 < this.m_nNodes.length) {
                int nNode = this.m_nNodes[iNode2];
                bIsContained[iNode2] = !bDone[nNode];
                int iParent = 0;
                while (iParent < bayesNet.getNrOfParents(nNode)) {
                    int nParent = bayesNet.getParent(nNode, iParent);
                    if (!clique.contains(nParent)) {
                        bIsContained[iNode2] = false;
                    }
                    ++iParent;
                }
                if (bIsContained[iNode2]) {
                    bDone[nNode] = true;
                    if (MarginCalculator.this.m_debug) {
                        System.out.println("adding node " + nNode);
                    }
                }
                ++iNode2;
            }
            int iPos = 0;
            while (iPos < this.m_nCardinality) {
                int i;
                int iCPT = MarginCalculator.this.getCPT(this.m_nNodes, this.m_nNodes.length, values, order, bayesNet);
                this.m_fi[iCPT] = 1.0;
                int iNode3 = 0;
                while (iNode3 < this.m_nNodes.length) {
                    if (bIsContained[iNode3]) {
                        int nNode = this.m_nNodes[iNode3];
                        int[] nNodes = bayesNet.getParentSet(nNode).getParents();
                        int iCPT2 = MarginCalculator.this.getCPT(nNodes, bayesNet.getNrOfParents(nNode), values, order, bayesNet);
                        double f = bayesNet.getDistributions()[nNode][iCPT2].getProbability(values[iNode3]);
                        int n = iCPT;
                        this.m_fi[n] = this.m_fi[n] * f;
                    }
                    ++iNode3;
                }
                int n = i = 0;
                values[n] = values[n] + 1;
                while (i < this.m_nNodes.length && values[i] == bayesNet.getCardinality(this.m_nNodes[i])) {
                    values[i] = 0;
                    if (++i >= this.m_nNodes.length) continue;
                    int n2 = i;
                    values[n2] = values[n2] + 1;
                }
                ++iPos;
            }
        }

        JunctionTreeNode(Set<Integer> clique, BayesNet bayesNet, boolean[] bDone) {
            this.m_bayesNet = bayesNet;
            this.m_children = new Vector();
            this.m_nNodes = new int[clique.size()];
            int iPos = 0;
            this.m_nCardinality = 1;
            for (Integer integer : clique) {
                int iNode = integer;
                this.m_nNodes[iPos++] = iNode;
                this.m_nCardinality *= bayesNet.getCardinality(iNode);
            }
            this.calculatePotentials(bayesNet, clique, bDone);
        }

        boolean contains(int nNode) {
            int[] nArray = this.m_nNodes;
            int n = this.m_nNodes.length;
            int n2 = 0;
            while (n2 < n) {
                int m_nNode = nArray[n2];
                if (m_nNode == nNode) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public void setEvidence(int nNode, int iValue) throws Exception {
            int[] values = new int[this.m_nNodes.length];
            int[] order = new int[this.m_bayesNet.getNrOfNodes()];
            int nNodeIdx = -1;
            int iNode = 0;
            while (iNode < this.m_nNodes.length) {
                order[this.m_nNodes[iNode]] = iNode;
                if (this.m_nNodes[iNode] == nNode) {
                    nNodeIdx = iNode;
                }
                ++iNode;
            }
            if (nNodeIdx < 0) {
                throw new Exception("setEvidence: Node " + nNode + " not found in this clique");
            }
            int iPos = 0;
            while (iPos < this.m_nCardinality) {
                int i;
                if (values[nNodeIdx] != iValue) {
                    int iNodeCPT = MarginCalculator.this.getCPT(this.m_nNodes, this.m_nNodes.length, values, order, this.m_bayesNet);
                    this.m_P[iNodeCPT] = 0.0;
                }
                int n = i = 0;
                values[n] = values[n] + 1;
                while (i < this.m_nNodes.length && values[i] == this.m_bayesNet.getCardinality(this.m_nNodes[i])) {
                    values[i] = 0;
                    if (++i >= this.m_nNodes.length) continue;
                    int n2 = i;
                    values[n2] = values[n2] + 1;
                }
                ++iPos;
            }
            double sum = 0.0;
            int iPos2 = 0;
            while (iPos2 < this.m_nCardinality) {
                sum += this.m_P[iPos2];
                ++iPos2;
            }
            iPos2 = 0;
            while (iPos2 < this.m_nCardinality) {
                int n = iPos2++;
                this.m_P[n] = this.m_P[n] / sum;
            }
            this.calcMarginalProbabilities();
            this.updateEvidence(this);
        }

        void updateEvidence(JunctionTreeNode source) {
            if (source != this) {
                int[] values = new int[this.m_nNodes.length];
                int[] order = new int[this.m_bayesNet.getNrOfNodes()];
                int iNode = 0;
                while (iNode < this.m_nNodes.length) {
                    order[this.m_nNodes[iNode]] = iNode;
                    ++iNode;
                }
                int[] nChildNodes = source.m_parentSeparator.m_nNodes;
                int nNumChildNodes = nChildNodes.length;
                int iPos = 0;
                while (iPos < this.m_nCardinality) {
                    int i;
                    int iNodeCPT = MarginCalculator.this.getCPT(this.m_nNodes, this.m_nNodes.length, values, order, this.m_bayesNet);
                    int iChildCPT = MarginCalculator.this.getCPT(nChildNodes, nNumChildNodes, values, order, this.m_bayesNet);
                    if (source.m_parentSeparator.m_fiParent[iChildCPT] != 0.0) {
                        int n = iNodeCPT;
                        this.m_P[n] = this.m_P[n] * (source.m_parentSeparator.m_fiChild[iChildCPT] / source.m_parentSeparator.m_fiParent[iChildCPT]);
                    } else {
                        this.m_P[iNodeCPT] = 0.0;
                    }
                    int n = i = 0;
                    values[n] = values[n] + 1;
                    while (i < this.m_nNodes.length && values[i] == this.m_bayesNet.getCardinality(this.m_nNodes[i])) {
                        values[i] = 0;
                        if (++i >= this.m_nNodes.length) continue;
                        int n2 = i;
                        values[n2] = values[n2] + 1;
                    }
                    ++iPos;
                }
                double sum = 0.0;
                int iPos2 = 0;
                while (iPos2 < this.m_nCardinality) {
                    sum += this.m_P[iPos2];
                    ++iPos2;
                }
                iPos2 = 0;
                while (iPos2 < this.m_nCardinality) {
                    int n = iPos2++;
                    this.m_P[n] = this.m_P[n] / sum;
                }
                this.calcMarginalProbabilities();
            }
            for (JunctionTreeNode element : this.m_children) {
                JunctionTreeNode childNode = element;
                if (childNode == source) continue;
                childNode.initializeDown(true);
            }
            if (this.m_parentSeparator != null) {
                this.m_parentSeparator.updateFromChild();
                this.m_parentSeparator.m_parentNode.updateEvidence(this);
                this.m_parentSeparator.updateFromParent();
            }
        }

        @Override
        public String getRevision() {
            return RevisionUtils.extract("$Revision: 10154 $");
        }
    }

    public class JunctionTreeSeparator
    implements Serializable,
    RevisionHandler {
        private static final long serialVersionUID = 6502780192411755343L;
        int[] m_nNodes;
        int m_nCardinality;
        double[] m_fiParent;
        double[] m_fiChild;
        JunctionTreeNode m_parentNode;
        JunctionTreeNode m_childNode;
        BayesNet m_bayesNet;

        JunctionTreeSeparator(Set<Integer> separator, BayesNet bayesNet, JunctionTreeNode childNode, JunctionTreeNode parentNode) {
            this.m_nNodes = new int[separator.size()];
            int iPos = 0;
            this.m_nCardinality = 1;
            for (Integer element : separator) {
                int iNode = element;
                this.m_nNodes[iPos++] = iNode;
                this.m_nCardinality *= bayesNet.getCardinality(iNode);
            }
            this.m_parentNode = parentNode;
            this.m_childNode = childNode;
            this.m_bayesNet = bayesNet;
        }

        public void updateFromParent() {
            double[] fis = this.update(this.m_parentNode);
            if (fis == null) {
                this.m_fiParent = null;
            } else {
                this.m_fiParent = fis;
                double sum = 0.0;
                int iPos = 0;
                while (iPos < this.m_nCardinality) {
                    sum += this.m_fiParent[iPos];
                    ++iPos;
                }
                iPos = 0;
                while (iPos < this.m_nCardinality) {
                    int n = iPos++;
                    this.m_fiParent[n] = this.m_fiParent[n] / sum;
                }
            }
        }

        public void updateFromChild() {
            double[] fis = this.update(this.m_childNode);
            if (fis == null) {
                this.m_fiChild = null;
            } else {
                this.m_fiChild = fis;
                double sum = 0.0;
                int iPos = 0;
                while (iPos < this.m_nCardinality) {
                    sum += this.m_fiChild[iPos];
                    ++iPos;
                }
                iPos = 0;
                while (iPos < this.m_nCardinality) {
                    int n = iPos++;
                    this.m_fiChild[n] = this.m_fiChild[n] / sum;
                }
            }
        }

        public double[] update(JunctionTreeNode node) {
            if (node.m_P == null) {
                return null;
            }
            double[] fi = new double[this.m_nCardinality];
            int[] values = new int[node.m_nNodes.length];
            int[] order = new int[this.m_bayesNet.getNrOfNodes()];
            int iNode = 0;
            while (iNode < node.m_nNodes.length) {
                order[node.m_nNodes[iNode]] = iNode;
                ++iNode;
            }
            int iPos = 0;
            while (iPos < node.m_nCardinality) {
                int i;
                int iSepCPT;
                int iNodeCPT = MarginCalculator.this.getCPT(node.m_nNodes, node.m_nNodes.length, values, order, this.m_bayesNet);
                int n = iSepCPT = MarginCalculator.this.getCPT(this.m_nNodes, this.m_nNodes.length, values, order, this.m_bayesNet);
                fi[n] = fi[n] + node.m_P[iNodeCPT];
                int n2 = i = 0;
                values[n2] = values[n2] + 1;
                while (i < node.m_nNodes.length && values[i] == this.m_bayesNet.getCardinality(node.m_nNodes[i])) {
                    values[i] = 0;
                    if (++i >= node.m_nNodes.length) continue;
                    int n3 = i;
                    values[n3] = values[n3] + 1;
                }
                ++iPos;
            }
            return fi;
        }

        @Override
        public String getRevision() {
            return RevisionUtils.extract("$Revision: 10154 $");
        }
    }
}

