/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.correlation;

import de.lmu.ifi.dbs.elki.algorithm.clustering.AbstractProjectedClustering;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.ClusterModel;
import de.lmu.ifi.dbs.elki.data.model.Model;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.IndefiniteProgress;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Centroid;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Matrix;
import de.lmu.ifi.dbs.elki.math.linearalgebra.SortedEigenPairs;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.PCAResult;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.PCARunner;
import de.lmu.ifi.dbs.elki.math.random.RandomFactory;
import de.lmu.ifi.dbs.elki.utilities.ClassGenericsUtil;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.RandomParameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Title(value="ORCLUS: Arbitrarily ORiented projected CLUSter generation")
@Description(value="Algorithm to find correlation clusters in high dimensional spaces.")
@Reference(authors="C. C. Aggarwal, P. S. Yu", title="Finding Generalized Projected Clusters in High Dimensional Spaces", booktitle="Proc. ACM SIGMOD Int. Conf. on Management of Data (SIGMOD '00)", url="http://dx.doi.org/10.1145/342009.335383")
public class ORCLUS<V extends NumberVector>
extends AbstractProjectedClustering<Clustering<Model>, V> {
    private static final Logging LOG = Logging.getLogger(ORCLUS.class);
    private double alpha;
    private RandomFactory rnd;
    private PCARunner pca;

    public ORCLUS(int n, int n2, int n3, double d, RandomFactory randomFactory, PCARunner pCARunner) {
        super(n, n2, n3);
        this.alpha = d;
        this.rnd = randomFactory;
        this.pca = pCARunner;
    }

    public Clustering<Model> run(Database database, Relation<V> relation) {
        try {
            IndefiniteProgress indefiniteProgress;
            DistanceQuery distanceQuery = this.getDistanceQuery(database);
            int n = RelationUtil.dimensionality(relation);
            if (n < this.l) {
                throw new IllegalStateException("Dimensionality of data < parameter l! (" + n + " < " + this.l + ")");
            }
            int n2 = Math.min(relation.size(), this.k_i * this.k);
            List<ORCLUSCluster> list = this.initialSeeds(relation, n2);
            double d = StrictMath.exp(-StrictMath.log((double)n / (double)this.l) * StrictMath.log(1.0 / this.alpha) / StrictMath.log((double)n2 / (double)this.k));
            IndefiniteProgress indefiniteProgress2 = indefiniteProgress = LOG.isVerbose() ? new IndefiniteProgress("Current number of clusters:", LOG) : null;
            while (n2 > this.k) {
                if (indefiniteProgress != null) {
                    indefiniteProgress.setProcessed(list.size(), LOG);
                }
                this.assign(relation, distanceQuery, list);
                for (ORCLUSCluster object : list) {
                    if (object.objectIDs.size() <= 0) continue;
                    object.basis = this.findBasis(relation, distanceQuery, object, n);
                }
                n2 = (int)Math.max((double)this.k, (double)n2 * this.alpha);
                n = (int)Math.max((double)this.l, (double)n * d);
                this.merge(relation, distanceQuery, list, n2, n, indefiniteProgress);
            }
            this.assign(relation, distanceQuery, list);
            LOG.setCompleted(indefiniteProgress);
            Clustering clustering = new Clustering("ORCLUS clustering", "orclus-clustering");
            for (ORCLUSCluster oRCLUSCluster : list) {
                clustering.addToplevelCluster(new Cluster<ClusterModel>((DBIDs)oRCLUSCluster.objectIDs, ClusterModel.CLUSTER));
            }
            return clustering;
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }

    private List<ORCLUSCluster> initialSeeds(Relation<V> relation, int n) {
        ModifiableDBIDs modifiableDBIDs = DBIDUtil.randomSample(relation.getDBIDs(), n, this.rnd);
        NumberVector.Factory<V> factory = RelationUtil.getNumberVectorFactory(relation);
        ArrayList<ORCLUSCluster> arrayList = new ArrayList<ORCLUSCluster>();
        DBIDIter dBIDIter = modifiableDBIDs.iter();
        while (dBIDIter.valid()) {
            arrayList.add(new ORCLUSCluster(this, (NumberVector)relation.get(dBIDIter), (DBIDRef)dBIDIter, factory));
            dBIDIter.advance();
        }
        return arrayList;
    }

    private void assign(Relation<V> relation, DistanceQuery<V> distanceQuery, List<ORCLUSCluster> list) {
        NumberVector.Factory<V> factory = RelationUtil.getNumberVectorFactory(relation);
        for (ORCLUSCluster iterator2 : list) {
            iterator2.objectIDs.clear();
        }
        ArrayList arrayList = new ArrayList(list.size());
        for (ORCLUSCluster oRCLUSCluster : list) {
            arrayList.add(this.projection(oRCLUSCluster, oRCLUSCluster.centroid, factory));
        }
        DBIDIter dBIDIter = relation.iterDBIDs();
        while (dBIDIter.valid()) {
            NumberVector numberVector = (NumberVector)relation.get(dBIDIter);
            double d = Double.POSITIVE_INFINITY;
            ORCLUSCluster oRCLUSCluster = null;
            for (int i = 0; i < list.size(); ++i) {
                ORCLUSCluster oRCLUSCluster2 = list.get(i);
                NumberVector numberVector2 = this.projection(oRCLUSCluster2, numberVector, factory);
                double d2 = distanceQuery.distance(numberVector2, arrayList.get(i));
                if (!(d2 < d)) continue;
                d = d2;
                oRCLUSCluster = oRCLUSCluster2;
            }
            assert (oRCLUSCluster != null);
            oRCLUSCluster.objectIDs.add(dBIDIter);
            dBIDIter.advance();
        }
        for (ORCLUSCluster oRCLUSCluster : list) {
            if (oRCLUSCluster.objectIDs.size() <= 0) continue;
            oRCLUSCluster.centroid = Centroid.make(relation, oRCLUSCluster.objectIDs).toVector(relation);
        }
    }

    private Matrix findBasis(Relation<V> relation, DistanceQuery<V> distanceQuery, ORCLUSCluster oRCLUSCluster, int n) {
        ModifiableDoubleDBIDList modifiableDoubleDBIDList = DBIDUtil.newDistanceDBIDList(oRCLUSCluster.objectIDs.size());
        Object object = oRCLUSCluster.objectIDs.iter();
        while (object.valid()) {
            double d = distanceQuery.distance(oRCLUSCluster.centroid, relation.get((DBIDRef)object));
            modifiableDoubleDBIDList.add(d, (DBIDRef)object);
            object.advance();
        }
        modifiableDoubleDBIDList.sort();
        object = this.pca.processQueryResult(modifiableDoubleDBIDList, relation);
        SortedEigenPairs sortedEigenPairs = ((PCAResult)object).getEigenPairs();
        return sortedEigenPairs.reverseEigenVectors(n);
    }

    private void merge(Relation<V> relation, DistanceQuery<V> distanceQuery, List<ORCLUSCluster> list, int n, int n2, IndefiniteProgress indefiniteProgress) {
        Object object;
        Object object2;
        int n3;
        ArrayList<ProjectedEnergy> arrayList = new ArrayList<ProjectedEnergy>();
        for (int i = 0; i < list.size(); ++i) {
            for (n3 = 0; n3 < list.size(); ++n3) {
                if (i >= n3) continue;
                ORCLUSCluster oRCLUSCluster = list.get(i);
                object2 = list.get(n3);
                object = this.projectedEnergy(relation, distanceQuery, oRCLUSCluster, (ORCLUSCluster)object2, i, n3, n2);
                arrayList.add((ProjectedEnergy)object);
            }
        }
        while (list.size() > n) {
            if (indefiniteProgress != null) {
                indefiniteProgress.setProcessed(list.size(), LOG);
            }
            ProjectedEnergy projectedEnergy = (ProjectedEnergy)Collections.min(arrayList);
            for (n3 = 0; n3 < list.size(); ++n3) {
                if (n3 == projectedEnergy.i) {
                    list.remove(n3);
                    list.add(n3, projectedEnergy.cluster);
                }
                if (n3 != projectedEnergy.j) continue;
                list.remove(n3);
            }
            n3 = projectedEnergy.i;
            int n4 = projectedEnergy.j;
            object2 = arrayList.iterator();
            while (object2.hasNext()) {
                object = (ProjectedEnergy)object2.next();
                if (((ProjectedEnergy)object).i == n3 || ((ProjectedEnergy)object).i == n4 || ((ProjectedEnergy)object).j == n3 || ((ProjectedEnergy)object).j == n4) {
                    object2.remove();
                    continue;
                }
                if (((ProjectedEnergy)object).i > n4) {
                    --((ProjectedEnergy)object).i;
                }
                if (((ProjectedEnergy)object).j <= n4) continue;
                --((ProjectedEnergy)object).j;
            }
            object = projectedEnergy.cluster;
            for (int i = 0; i < list.size(); ++i) {
                if (i < n3) {
                    arrayList.add(this.projectedEnergy(relation, distanceQuery, list.get(i), (ORCLUSCluster)object, i, n3, n2));
                    continue;
                }
                if (i <= n3) continue;
                arrayList.add(this.projectedEnergy(relation, distanceQuery, list.get(i), (ORCLUSCluster)object, n3, i, n2));
            }
        }
    }

    private ProjectedEnergy projectedEnergy(Relation<V> relation, DistanceQuery<V> distanceQuery, ORCLUSCluster oRCLUSCluster, ORCLUSCluster oRCLUSCluster2, int n, int n2, int n3) {
        ORCLUSCluster oRCLUSCluster3 = this.union(relation, distanceQuery, oRCLUSCluster, oRCLUSCluster2, n3);
        NumberVector.Factory<V> factory = RelationUtil.getNumberVectorFactory(relation);
        double d = 0.0;
        Object v = this.projection(oRCLUSCluster3, oRCLUSCluster3.centroid, factory);
        DBIDMIter dBIDMIter = oRCLUSCluster3.objectIDs.iter();
        while (dBIDMIter.valid()) {
            NumberVector numberVector = this.projection(oRCLUSCluster3, (NumberVector)relation.get(dBIDMIter), factory);
            double d2 = distanceQuery.distance(numberVector, v);
            d += d2 * d2;
            dBIDMIter.advance();
        }
        return new ProjectedEnergy(n, n2, oRCLUSCluster3, d /= (double)oRCLUSCluster3.objectIDs.size());
    }

    private ORCLUSCluster union(Relation<V> relation, DistanceQuery<V> distanceQuery, ORCLUSCluster oRCLUSCluster, ORCLUSCluster oRCLUSCluster2, int n) {
        ORCLUSCluster oRCLUSCluster3 = new ORCLUSCluster();
        oRCLUSCluster3.objectIDs = DBIDUtil.newHashSet(oRCLUSCluster.objectIDs);
        oRCLUSCluster3.objectIDs.addDBIDs(oRCLUSCluster2.objectIDs);
        oRCLUSCluster3.objectIDs = DBIDUtil.newArray(oRCLUSCluster3.objectIDs);
        if (oRCLUSCluster3.objectIDs.size() > 0) {
            oRCLUSCluster3.centroid = Centroid.make(relation, oRCLUSCluster3.objectIDs).toVector(relation);
            oRCLUSCluster3.basis = this.findBasis(relation, distanceQuery, oRCLUSCluster3, n);
        } else {
            NumberVector.Factory<V> factory = RelationUtil.getNumberVectorFactory(relation);
            Vector vector = oRCLUSCluster.centroid.getColumnVector().plusEquals(oRCLUSCluster2.centroid.getColumnVector()).timesEquals(0.5);
            oRCLUSCluster3.centroid = factory.newNumberVector(vector.getArrayRef());
            double[][] dArray = new double[oRCLUSCluster.basis.getRowDimensionality()][n];
            for (int i = 0; i < n; ++i) {
                dArray[i][i] = 1.0;
            }
            oRCLUSCluster3.basis = new Matrix(dArray);
        }
        return oRCLUSCluster3;
    }

    private V projection(ORCLUSCluster oRCLUSCluster, V v, NumberVector.Factory<V> factory) {
        Matrix matrix = v.getColumnVector().transposeTimes(oRCLUSCluster.basis);
        double[] dArray = matrix.getColumnPackedCopy();
        return factory.newNumberVector(dArray);
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(TypeUtil.NUMBER_VECTOR_FIELD);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractProjectedClustering.Parameterizer {
        public static final OptionID ALPHA_ID = new OptionID("orclus.alpha", "The factor for reducing the number of current clusters in each iteration.");
        public static final OptionID SEED_ID = new OptionID("orclus.seed", "The random number generator seed.");
        protected double alpha = -1.0;
        protected RandomFactory rnd;
        protected PCARunner pca = null;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            this.configK(parameterization);
            this.configKI(parameterization);
            this.configL(parameterization);
            this.configAlpha(parameterization);
            this.configSeed(parameterization);
            Class clazz = ClassGenericsUtil.uglyCastIntoSubclass(PCARunner.class);
            this.pca = (PCARunner)parameterization.tryInstantiate(clazz);
        }

        protected void configAlpha(Parameterization parameterization) {
            DoubleParameter doubleParameter = new DoubleParameter(ALPHA_ID, 0.5);
            doubleParameter.addConstraint(CommonConstraints.GREATER_THAN_ZERO_DOUBLE);
            doubleParameter.addConstraint(CommonConstraints.LESS_EQUAL_ONE_DOUBLE);
            if (parameterization.grab(doubleParameter)) {
                this.alpha = doubleParameter.doubleValue();
            }
        }

        protected void configSeed(Parameterization parameterization) {
            RandomParameter randomParameter = new RandomParameter(SEED_ID);
            if (parameterization.grab(randomParameter)) {
                this.rnd = (RandomFactory)randomParameter.getValue();
            }
        }

        @Override
        protected ORCLUS<V> makeInstance() {
            return new ORCLUS(this.k, this.k_i, this.l, this.alpha, this.rnd, this.pca);
        }
    }

    private final class ProjectedEnergy
    implements Comparable<ProjectedEnergy> {
        int i;
        int j;
        ORCLUSCluster cluster;
        double projectedEnergy;

        ProjectedEnergy(int n, int n2, ORCLUSCluster oRCLUSCluster, double d) {
            this.i = n;
            this.j = n2;
            this.cluster = oRCLUSCluster;
            this.projectedEnergy = d;
        }

        @Override
        public int compareTo(ProjectedEnergy projectedEnergy) {
            return Double.compare(this.projectedEnergy, projectedEnergy.projectedEnergy);
        }
    }

    private final class ORCLUSCluster {
        ModifiableDBIDs objectIDs;
        Matrix basis;
        V centroid;

        ORCLUSCluster() {
            this.objectIDs = DBIDUtil.newArray();
        }

        ORCLUSCluster(V v, DBIDRef dBIDRef, NumberVector.Factory<V> factory) {
            this.objectIDs = DBIDUtil.newArray();
            this.objectIDs.add(dBIDRef);
            int n = v.getDimensionality();
            this.basis = Matrix.unitMatrix(n);
            double[] dArray = v.getColumnVector().getArrayRef();
            this.centroid = factory.newNumberVector(dArray);
        }
    }
}

