/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.KMeans;
import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.quality.KMeansQualityMeasure;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.MeanModel;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.NumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.PrimitiveDistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;

public class BestOfMultipleKMeans<V extends NumberVector, M extends MeanModel>
extends AbstractAlgorithm<Clustering<M>>
implements KMeans<V, M> {
    private static final Logging LOG = Logging.getLogger(BestOfMultipleKMeans.class);
    private int trials;
    private KMeans<V, M> innerkMeans;
    private KMeansQualityMeasure<? super V> qualityMeasure;

    public BestOfMultipleKMeans(int n, KMeans<V, M> kMeans, KMeansQualityMeasure<? super V> kMeansQualityMeasure) {
        this.trials = n;
        this.innerkMeans = kMeans;
        this.qualityMeasure = kMeansQualityMeasure;
    }

    @Override
    public Clustering<M> run(Database database, Relation<V> relation) {
        if (!(this.innerkMeans.getDistanceFunction() instanceof PrimitiveDistanceFunction)) {
            throw new AbortException("K-Means results can only be evaluated for primitive distance functions, got: " + this.innerkMeans.getDistanceFunction().getClass());
        }
        NumberVectorDistanceFunction numberVectorDistanceFunction = (NumberVectorDistanceFunction)this.innerkMeans.getDistanceFunction();
        Clustering<M> clustering = null;
        double d = Double.NaN;
        FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress("K-means iterations", this.trials, LOG) : null;
        for (int i = 0; i < this.trials; ++i) {
            Clustering<M> clustering2 = this.innerkMeans.run(database, relation);
            double d2 = this.qualityMeasure.quality(clustering2, numberVectorDistanceFunction, relation);
            if (LOG.isVerbose()) {
                LOG.verbose("Cost of candidate " + i + ": " + d2);
            }
            if (this.qualityMeasure.isBetter(d2, d)) {
                clustering = clustering2;
                d = d2;
            }
            LOG.incrementProcessed(finiteProgress);
        }
        LOG.ensureCompleted(finiteProgress);
        return clustering;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return this.innerkMeans.getInputTypeRestriction();
    }

    @Override
    public DistanceFunction<? super V> getDistanceFunction() {
        return this.innerkMeans.getDistanceFunction();
    }

    @Override
    public void setK(int n) {
        this.innerkMeans.setK(n);
    }

    @Override
    public void setDistanceFunction(NumberVectorDistanceFunction<? super V> numberVectorDistanceFunction) {
        this.innerkMeans.setDistanceFunction(numberVectorDistanceFunction);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V extends NumberVector, M extends MeanModel>
    extends AbstractParameterizer {
        public static final OptionID TRIALS_ID = new OptionID("kmeans.trials", "The number of trials to run.");
        public static final OptionID KMEANS_ID = new OptionID("kmeans.algorithm", "KMeans variant to run multiple times.");
        public static final OptionID QUALITYMEASURE_ID = new OptionID("kmeans.qualitymeasure", "Quality measure variant for deciding which run to keep.");
        protected int trials;
        protected KMeans<V, M> kMeansVariant;
        protected KMeansQualityMeasure<? super V> qualityMeasure;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            ObjectParameter objectParameter;
            ObjectParameter objectParameter2;
            IntParameter intParameter = new IntParameter(TRIALS_ID);
            intParameter.addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (parameterization.grab(intParameter)) {
                this.trials = intParameter.intValue();
            }
            if (parameterization.grab(objectParameter2 = new ObjectParameter(KMEANS_ID, KMeans.class))) {
                this.kMeansVariant = (KMeans)objectParameter2.instantiateClass(parameterization);
            }
            if (parameterization.grab(objectParameter = new ObjectParameter(QUALITYMEASURE_ID, KMeansQualityMeasure.class))) {
                this.qualityMeasure = (KMeansQualityMeasure)objectParameter.instantiateClass(parameterization);
            }
        }

        @Override
        protected BestOfMultipleKMeans<V, M> makeInstance() {
            return new BestOfMultipleKMeans<V, M>(this.trials, this.kMeansVariant, this.qualityMeasure);
        }
    }
}

