/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.quality;

import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.quality.AbstractKMeansQualityMeasure;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.MeanModel;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.NumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;

@Reference(authors="G. Schwarz", title="Estimating the dimension of a model", booktitle="The annals of statistics 6.2", url="http://dx.doi.org/10.1214/aos/1176344136")
public class BayesianInformationCriterion
extends AbstractKMeansQualityMeasure<NumberVector> {
    @Override
    public <V extends NumberVector> double quality(Clustering<? extends MeanModel> clustering, NumberVectorDistanceFunction<? super V> numberVectorDistanceFunction, Relation<V> relation) {
        return BayesianInformationCriterion.logLikelihood(relation, clustering, numberVectorDistanceFunction) - 0.5 * (double)BayesianInformationCriterion.numberOfFreeParameters(relation, clustering) * Math.log(BayesianInformationCriterion.numPoints(clustering));
    }

    @Override
    public boolean ascending() {
        return true;
    }

    @Override
    public boolean isBetter(double d, double d2) {
        return !(d <= d2);
    }
}

