/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.trivial;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.ClusteringAlgorithm;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.model.Model;
import de.lmu.ifi.dbs.elki.data.synthetic.bymodel.GeneratorInterface;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.PatternParameter;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

@Title(value="Clustering by model")
@Description(value="Cluster points by a (pre-assigned!) model. For comparing results with a reference clustering.")
public class ByModelClustering
extends AbstractAlgorithm<Clustering<Model>>
implements ClusteringAlgorithm<Clustering<Model>> {
    private static final Logging LOG = Logging.getLogger(ByModelClustering.class);
    private Pattern noisepattern = null;

    public ByModelClustering(Pattern pattern) {
        this.noisepattern = pattern;
    }

    public ByModelClustering() {
        this(null);
    }

    /*
     * WARNING - void declaration
     */
    public Clustering<Model> run(Relation<Model> relation) {
        HashMap<Object, HashSetModifiableDBIDs> hashMap = new HashMap<Object, HashSetModifiableDBIDs>();
        Object object = relation.iterDBIDs();
        while (object.valid()) {
            void object2;
            Model model = relation.get((DBIDRef)object);
            ModifiableDBIDs modifiableDBIDs = (ModifiableDBIDs)hashMap.get(model);
            if (modifiableDBIDs == null) {
                HashSetModifiableDBIDs hashSetModifiableDBIDs = DBIDUtil.newHashSet();
                hashMap.put(model, hashSetModifiableDBIDs);
            }
            object2.add((DBIDRef)object);
            object.advance();
        }
        object = new Clustering("By Model Clustering", "bymodel-clustering");
        for (Map.Entry entry : hashMap.entrySet()) {
            Model model = (Model)entry.getKey();
            ModifiableDBIDs modifiableDBIDs = (ModifiableDBIDs)entry.getValue();
            String string = model instanceof GeneratorInterface ? ((GeneratorInterface)((Object)model)).getName() : model.toString();
            Cluster<Model> cluster = new Cluster<Model>(string, (DBIDs)modifiableDBIDs, model);
            if (this.noisepattern != null && this.noisepattern.matcher(string).find()) {
                cluster.setNoise(true);
            }
            ((Clustering)object).addToplevelCluster(cluster);
        }
        return object;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(TypeUtil.MODEL);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID NOISE_ID = new OptionID("bymodel.noise", "Pattern to recognize noise models by their label.");
        protected Pattern noisepat;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            PatternParameter patternParameter = new PatternParameter(NOISE_ID);
            patternParameter.setOptional(true);
            if (parameterization.grab(patternParameter)) {
                this.noisepat = (Pattern)patternParameter.getValue();
            }
        }

        @Override
        protected ByModelClustering makeInstance() {
            return new ByModelClustering(this.noisepat);
        }
    }
}

