/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.lof;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.OutlierAlgorithm;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.result.outlier.QuotientOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;

@Title(value="INFLO: Influenced Outlierness Factor")
@Description(value="Ranking Outliers Using Symmetric Neigborhood Relationship")
@Reference(authors="W. Jin, A. Tung, J. Han, and W. Wang", title="Ranking outliers using symmetric neighborhood relationship", booktitle="Proc. 10th Pacific-Asia conference on Advances in Knowledge Discovery and Data Mining", url="http://dx.doi.org/10.1007/11731139_68")
@Alias(value={"de.lmu.ifi.dbs.elki.algorithm.outlier.INFLO"})
public class INFLO<O>
extends AbstractDistanceBasedAlgorithm<O, OutlierResult>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(INFLO.class);
    private double m;
    private int k;

    public INFLO(DistanceFunction<? super O> distanceFunction, double d, int n) {
        super(distanceFunction);
        this.m = d;
        this.k = n;
    }

    public OutlierResult run(Database database, Relation<O> relation) {
        DistanceQuery<O> distanceQuery = database.getDistanceQuery(relation, this.getDistanceFunction(), new Object[0]);
        KNNQuery<O> kNNQuery = database.getKNNQuery(distanceQuery, this.k + 1, "heavy");
        HashSetModifiableDBIDs hashSetModifiableDBIDs = DBIDUtil.newHashSet();
        WritableDataStore<ModifiableDBIDs> writableDataStore = DataStoreUtil.makeStorage(relation.getDBIDs(), 3, ModifiableDBIDs.class);
        WritableDataStore<ModifiableDBIDs> writableDataStore2 = DataStoreUtil.makeStorage(relation.getDBIDs(), 3, ModifiableDBIDs.class);
        WritableDoubleDataStore writableDoubleDataStore = DataStoreUtil.makeDoubleStorage(relation.getDBIDs(), 3);
        Object object = relation.iterDBIDs();
        while (object.valid()) {
            writableDataStore.put((DBIDRef)object, DBIDUtil.newArray());
            writableDataStore2.put((DBIDRef)object, DBIDUtil.newArray());
            object.advance();
        }
        this.computeNeighborhoods(relation, kNNQuery, hashSetModifiableDBIDs, writableDataStore, writableDataStore2, writableDoubleDataStore);
        object = new DoubleMinMax();
        WritableDoubleDataStore writableDoubleDataStore2 = DataStoreUtil.makeDoubleStorage(relation.getDBIDs(), 4);
        this.computeINFLO(relation, hashSetModifiableDBIDs, writableDataStore, writableDataStore2, writableDoubleDataStore, writableDoubleDataStore2, (DoubleMinMax)object);
        MaterializedDoubleRelation materializedDoubleRelation = new MaterializedDoubleRelation("Influence Outlier Score", "inflo-outlier", writableDoubleDataStore2, relation.getDBIDs());
        QuotientOutlierScoreMeta quotientOutlierScoreMeta = new QuotientOutlierScoreMeta(((DoubleMinMax)object).getMin(), ((DoubleMinMax)object).getMax(), 0.0, Double.POSITIVE_INFINITY, 1.0);
        return new OutlierResult(quotientOutlierScoreMeta, materializedDoubleRelation);
    }

    protected void computeNeighborhoods(Relation<O> relation, KNNQuery<O> kNNQuery, ModifiableDBIDs modifiableDBIDs, WritableDataStore<ModifiableDBIDs> writableDataStore, WritableDataStore<ModifiableDBIDs> writableDataStore2, WritableDoubleDataStore writableDoubleDataStore) {
        DBIDIter dBIDIter = relation.iterDBIDs();
        while (dBIDIter.valid()) {
            int n = ((ModifiableDBIDs)writableDataStore2.get(dBIDIter)).size();
            DBIDs dBIDs = this.getKNN(dBIDIter, kNNQuery, writableDataStore, writableDoubleDataStore);
            DBIDIter dBIDIter2 = dBIDs.iter();
            while (dBIDIter2.valid()) {
                if (!DBIDUtil.equal(dBIDIter, dBIDIter2) && this.getKNN(dBIDIter2, kNNQuery, writableDataStore, writableDoubleDataStore).contains(dBIDIter)) {
                    ((ModifiableDBIDs)writableDataStore2.get(dBIDIter2)).add(dBIDIter);
                    ((ModifiableDBIDs)writableDataStore2.get(dBIDIter)).add(dBIDIter2);
                    ++n;
                }
                dBIDIter2.advance();
            }
            if ((double)n >= (double)dBIDs.size() * this.m) {
                modifiableDBIDs.add(dBIDIter);
            }
            dBIDIter.advance();
        }
    }

    protected void computeINFLO(Relation<O> relation, ModifiableDBIDs modifiableDBIDs, WritableDataStore<ModifiableDBIDs> writableDataStore, WritableDataStore<ModifiableDBIDs> writableDataStore2, WritableDoubleDataStore writableDoubleDataStore, WritableDoubleDataStore writableDoubleDataStore2, DoubleMinMax doubleMinMax) {
        DBIDIter dBIDIter = relation.iterDBIDs();
        while (dBIDIter.valid()) {
            if (modifiableDBIDs.contains(dBIDIter)) {
                writableDoubleDataStore2.putDouble(dBIDIter, 1.0);
                doubleMinMax.put(1.0);
            } else {
                ModifiableDBIDs modifiableDBIDs2 = (ModifiableDBIDs)writableDataStore.get(dBIDIter);
                ModifiableDBIDs modifiableDBIDs3 = (ModifiableDBIDs)writableDataStore2.get(dBIDIter);
                modifiableDBIDs2.addDBIDs(modifiableDBIDs3);
                double d = 0.0;
                int n = 0;
                DBIDMIter dBIDMIter = modifiableDBIDs2.iter();
                while (dBIDMIter.valid()) {
                    if (!DBIDUtil.equal(dBIDIter, dBIDMIter)) {
                        d += writableDoubleDataStore.doubleValue(dBIDMIter);
                        ++n;
                    }
                    dBIDMIter.advance();
                }
                double d2 = writableDoubleDataStore.doubleValue(dBIDIter);
                double d3 = d2 > 0.0 ? (d2 < Double.POSITIVE_INFINITY ? d / ((double)n * d2) : 1.0) : (d == 0.0 ? 1.0 : Double.POSITIVE_INFINITY);
                writableDoubleDataStore2.putDouble(dBIDIter, d3);
                doubleMinMax.put(d3);
            }
            dBIDIter.advance();
        }
    }

    protected DBIDs getKNN(DBIDIter dBIDIter, KNNQuery<O> kNNQuery, WritableDataStore<ModifiableDBIDs> writableDataStore, WritableDoubleDataStore writableDoubleDataStore) {
        ModifiableDBIDs modifiableDBIDs = (ModifiableDBIDs)writableDataStore.get(dBIDIter);
        if (modifiableDBIDs.size() == 0) {
            KNNList kNNList = kNNQuery.getKNNForDBID(dBIDIter, this.k + 1);
            modifiableDBIDs.addDBIDs(kNNList);
            writableDoubleDataStore.putDouble(dBIDIter, 1.0 / kNNList.getKNNDistance());
        }
        return modifiableDBIDs;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getDistanceFunction().getInputTypeRestriction());
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<O> {
        public static final OptionID M_ID = new OptionID("inflo.m", "The pruning threshold");
        public static final OptionID K_ID = new OptionID("inflo.k", "The number of nearest neighbors of an object to be considered for computing its INFLO score.");
        protected double m = 1.0;
        protected int k = 0;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            IntParameter intParameter;
            super.makeOptions(parameterization);
            DoubleParameter doubleParameter = (DoubleParameter)new DoubleParameter(M_ID, 1.0).addConstraint(CommonConstraints.GREATER_THAN_ZERO_DOUBLE);
            if (parameterization.grab(doubleParameter)) {
                this.m = doubleParameter.doubleValue();
            }
            if (parameterization.grab(intParameter = (IntParameter)new IntParameter(K_ID).addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT))) {
                this.k = intParameter.intValue();
            }
        }

        @Override
        protected INFLO<O> makeInstance() {
            return new INFLO(this.distanceFunction, this.m, this.k);
        }
    }
}

