/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.spatial;

import de.lmu.ifi.dbs.elki.algorithm.outlier.spatial.AbstractDistanceBasedSpatialOutlier;
import de.lmu.ifi.dbs.elki.algorithm.outlier.spatial.neighborhood.NeighborSetPredicate;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.relation.DoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.PrimitiveDistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.QuotientOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;

@Title(value="Spatial Outlier Factor")
@Reference(authors="Huang, T., Qin, X.", title="Detecting outliers in spatial database", booktitle="Proc. 3rd International Conference on Image and Graphics", url="http://dx.doi.org/10.1109/ICIG.2004.53")
public class SOF<N, O>
extends AbstractDistanceBasedSpatialOutlier<N, O> {
    private static final Logging LOG = Logging.getLogger(SOF.class);

    public SOF(NeighborSetPredicate.Factory<N> factory, PrimitiveDistanceFunction<O> primitiveDistanceFunction) {
        super(factory, primitiveDistanceFunction);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public OutlierResult run(Database database, Relation<N> relation, Relation<O> relation2) {
        double d;
        double d2;
        Object object;
        NeighborSetPredicate neighborSetPredicate = this.getNeighborSetPredicateFactory().instantiate(database, relation);
        DistanceQuery<O> distanceQuery = this.getNonSpatialDistanceFunction().instantiate(relation2);
        WritableDoubleDataStore writableDoubleDataStore = DataStoreUtil.makeDoubleStorage(relation2.getDBIDs(), 3);
        WritableDoubleDataStore writableDoubleDataStore2 = DataStoreUtil.makeDoubleStorage(relation2.getDBIDs(), 4);
        DoubleMinMax doubleMinMax = new DoubleMinMax();
        Object object2 = relation2.iterDBIDs();
        while (object2.valid()) {
            object = neighborSetPredicate.getNeighborDBIDs((DBIDRef)object2);
            d2 = 0.0;
            DBIDIter dBIDIter = object.iter();
            while (dBIDIter.valid()) {
                d2 += distanceQuery.distance((DBIDRef)object2, (DBIDRef)dBIDIter);
                dBIDIter.advance();
            }
            d = 1.0 / (d2 / (double)object.size());
            if (Double.isNaN(d)) {
                d = 0.0;
            }
            writableDoubleDataStore.putDouble((DBIDRef)object2, d);
            object2.advance();
        }
        object2 = relation2.iterDBIDs();
        while (object2.valid()) {
            object = neighborSetPredicate.getNeighborDBIDs((DBIDRef)object2);
            d2 = 0.0;
            DBIDIter dBIDIter = object.iter();
            while (dBIDIter.valid()) {
                d2 += writableDoubleDataStore.doubleValue(dBIDIter);
                dBIDIter.advance();
            }
            d = d2 / (double)object.size() / writableDoubleDataStore.doubleValue((DBIDRef)object2);
            if (!Double.isNaN(d)) {
                writableDoubleDataStore2.putDouble((DBIDRef)object2, d);
                doubleMinMax.put(d);
            } else {
                writableDoubleDataStore2.putDouble((DBIDRef)object2, 0.0);
            }
            object2.advance();
        }
        object2 = new MaterializedDoubleRelation("Spatial Outlier Factor", "sof-outlier", writableDoubleDataStore2, relation2.getDBIDs());
        object = new QuotientOutlierScoreMeta(doubleMinMax.getMin(), doubleMinMax.getMax(), 0.0, Double.POSITIVE_INFINITY, 1.0);
        OutlierResult outlierResult = new OutlierResult((OutlierScoreMeta)object, (DoubleRelation)object2);
        outlierResult.addChildResult(neighborSetPredicate);
        return outlierResult;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getNeighborSetPredicateFactory().getInputTypeRestriction(), TypeUtil.NUMBER_VECTOR_FIELD);
    }

    public static class Parameterizer<N, O>
    extends AbstractDistanceBasedSpatialOutlier.Parameterizer<N, O> {
        @Override
        protected SOF<N, O> makeInstance() {
            return new SOF(this.npredf, this.distanceFunction);
        }
    }
}

