/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.filter;

import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.datasource.bundle.BundleMeta;
import de.lmu.ifi.dbs.elki.datasource.bundle.BundleStreamSource;
import de.lmu.ifi.dbs.elki.datasource.filter.AbstractStreamFilter;

public abstract class AbstractStreamConversionFilter<I, O>
extends AbstractStreamFilter {
    BundleMeta meta;
    int column = -1;

    @Override
    public BundleMeta getMeta() {
        return this.meta;
    }

    @Override
    public Object data(int n) {
        if (n != this.column) {
            return this.source.data(n);
        }
        Object object = this.source.data(n);
        return this.filterSingleObject(object);
    }

    @Override
    public BundleStreamSource.Event nextEvent() {
        BundleStreamSource.Event event = this.source.nextEvent();
        if (event == BundleStreamSource.Event.META_CHANGED) {
            if (this.meta == null) {
                this.meta = new BundleMeta();
            }
            BundleMeta bundleMeta = this.source.getMeta();
            for (int i = this.meta.size(); i < bundleMeta.size(); ++i) {
                if (this.column < 0) {
                    SimpleTypeInformation simpleTypeInformation = (SimpleTypeInformation)bundleMeta.get(i);
                    if (this.getInputTypeRestriction().isAssignableFromType(simpleTypeInformation)) {
                        SimpleTypeInformation simpleTypeInformation2 = simpleTypeInformation;
                        this.meta.add(this.convertedType(simpleTypeInformation2));
                        this.column = i;
                        continue;
                    }
                }
                this.meta.add(bundleMeta.get(i));
            }
        }
        return event;
    }

    protected abstract O filterSingleObject(I var1);

    protected abstract TypeInformation getInputTypeRestriction();

    protected abstract SimpleTypeInformation<? super O> convertedType(SimpleTypeInformation<I> var1);
}

