/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.gui.configurator;

import de.lmu.ifi.dbs.elki.gui.configurator.ParameterConfigurator;
import de.lmu.ifi.dbs.elki.gui.icons.StockIcon;
import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.ListParameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.TrackParameters;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Parameter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public abstract class AbstractParameterConfigurator<T extends Parameter<?>>
implements ParameterConfigurator {
    final T param;
    final JComponent parent;
    protected EventListenerList listenerList = new EventListenerList();

    public AbstractParameterConfigurator(T t, JComponent jComponent) {
        this.param = t;
        this.parent = jComponent;
    }

    protected void finishGridRow() {
        JLabel jLabel;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        if (this.param.isOptional()) {
            if (this.param.isDefined() && this.param.tookDefaultValue() && !(this.param instanceof Flag)) {
                jLabel = new JLabel(StockIcon.getStockIcon("dialog-information"));
                jLabel.setToolTipText("Default value: " + this.param.getDefaultValueAsString());
            } else {
                jLabel = new JLabel();
                jLabel.setMinimumSize(new Dimension(16, 16));
            }
        } else if (!this.param.isDefined()) {
            jLabel = new JLabel(StockIcon.getStockIcon("dialog-error"));
            jLabel.setToolTipText("Missing value.");
        } else {
            jLabel = new JLabel();
            jLabel.setMinimumSize(new Dimension(16, 16));
        }
        this.parent.add((Component)jLabel, gridBagConstraints);
    }

    @Override
    public void addParameter(Object object, Parameter<?> parameter, TrackParameters trackParameters) {
        LoggingUtil.warning(this.getClass() + " does not support sub-parameters!");
    }

    @Override
    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    @Override
    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(ChangeListener.class, changeListener);
    }

    protected void fireValueChanged() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : (ChangeListener[])this.listenerList.getListeners(ChangeListener.class)) {
            changeListener.stateChanged(changeEvent);
        }
    }

    @Override
    public void appendParameters(ListParameterization listParameterization) {
        Object object = this.getUserInput();
        if (object instanceof String && ((String)object).length() == 0) {
            object = null;
        }
        if (object != null) {
            listParameterization.addParameter(this.param.getOptionID(), object);
        }
    }

    public abstract Object getUserInput();
}

