/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.lsh.hashfamilies;

import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.ManhattanDistanceFunction;
import de.lmu.ifi.dbs.elki.index.lsh.hashfamilies.AbstractProjectedHashFunctionFamily;
import de.lmu.ifi.dbs.elki.math.linearalgebra.randomprojections.CauchyRandomProjectionFamily;
import de.lmu.ifi.dbs.elki.math.random.RandomFactory;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;

@Reference(authors="M. Datar and N. Immorlica and P. Indyk and V. S. Mirrokni", title="Locality-sensitive hashing scheme based on p-stable distributions", booktitle="Proc. 20th annual symposium on Computational geometry", url="http://dx.doi.org/10.1145/997817.997857")
public class ManhattanHashFunctionFamily
extends AbstractProjectedHashFunctionFamily {
    public ManhattanHashFunctionFamily(RandomFactory randomFactory, double d, int n) {
        super(randomFactory, new CauchyRandomProjectionFamily(randomFactory), d, n);
    }

    @Override
    public boolean isCompatible(DistanceFunction<?> distanceFunction) {
        return ManhattanDistanceFunction.class.isInstance(distanceFunction);
    }

    public static class Parameterizer
    extends AbstractProjectedHashFunctionFamily.Parameterizer {
        @Override
        protected ManhattanHashFunctionFamily makeInstance() {
            return new ManhattanHashFunctionFamily(this.random, this.width, this.k);
        }
    }
}

