/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.rdknn;

import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.AbstractRStarTreeNode;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.rdknn.RdKNNEntry;

public class RdKNNNode
extends AbstractRStarTreeNode<RdKNNNode, RdKNNEntry> {
    private static final long serialVersionUID = 1L;

    public RdKNNNode() {
    }

    public RdKNNNode(int n, boolean bl) {
        super(n, bl, RdKNNEntry.class);
    }

    protected double kNNDistance() {
        double d = ((RdKNNEntry)this.getEntry(0)).getKnnDistance();
        for (int i = 1; i < this.getNumEntries(); ++i) {
            double d2 = ((RdKNNEntry)this.getEntry(i)).getKnnDistance();
            d = d < d2 ? d2 : d;
        }
        return d;
    }

    @Override
    public boolean adjustEntry(RdKNNEntry rdKNNEntry) {
        boolean bl = super.adjustEntry(rdKNNEntry);
        rdKNNEntry.setKnnDistance(this.kNNDistance());
        return bl;
    }

    @Override
    protected void integrityCheckParameters(RdKNNNode rdKNNNode, int n) {
        super.integrityCheckParameters(rdKNNNode, n);
        RdKNNEntry rdKNNEntry = (RdKNNEntry)rdKNNNode.getEntry(n);
        double d = this.kNNDistance();
        if (rdKNNEntry.getKnnDistance() != d) {
            double d2 = d;
            double d3 = rdKNNEntry.getKnnDistance();
            throw new RuntimeException("Wrong knnDistance in node " + rdKNNNode.getPageID() + " at index " + n + " (child " + rdKNNEntry + ")" + "\nsoll: " + d2 + ",\n ist: " + d3);
        }
    }
}

