/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.linearalgebra.randomprojections;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.SparseNumberVector;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.linearalgebra.randomprojections.AbstractRandomProjectionFamily;
import de.lmu.ifi.dbs.elki.math.linearalgebra.randomprojections.RandomProjectionFamily;
import de.lmu.ifi.dbs.elki.math.random.RandomFactory;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import java.util.Random;

@Reference(authors="M. Henzinger", title="Finding near-duplicate web pages: a large-scale evaluation of algorithms", booktitle="Proc. 29th ACM Conference on Research and Development in Information Retrieval. ACM SIGIR, 2006", url="http://dx.doi.org/10.1145/1148170.1148222")
public class SimplifiedRandomHyperplaneProjectionFamily
implements RandomProjectionFamily {
    protected Random random;

    public SimplifiedRandomHyperplaneProjectionFamily(RandomFactory randomFactory) {
        this.random = randomFactory.getSingleThreadedRandom();
    }

    @Override
    public RandomProjectionFamily.Projection generateProjection(int n, int n2) {
        return new SignedProjection(n, n2, this.random);
    }

    public static class Parameterizer
    extends AbstractRandomProjectionFamily.Parameterizer {
        @Override
        protected SimplifiedRandomHyperplaneProjectionFamily makeInstance() {
            return new SimplifiedRandomHyperplaneProjectionFamily(this.random);
        }
    }

    private static class SignedProjection
    implements RandomProjectionFamily.Projection {
        boolean[][] mat;
        private int k;
        private double[] buf;

        public SignedProjection(int n, int n2, Random random) {
            this.mat = new boolean[n][n2];
            for (int i = 0; i < n; ++i) {
                boolean[] blArray = this.mat[i];
                for (int j = 0; j < n2; ++j) {
                    blArray[j] = random.nextBoolean();
                }
            }
            this.k = n2;
            this.buf = new double[n];
        }

        @Override
        public double[] project(NumberVector numberVector) {
            return this.project(numberVector, new double[this.k]);
        }

        @Override
        public double[] project(NumberVector numberVector, double[] dArray) {
            if (!(numberVector instanceof SparseNumberVector)) {
                return this.projectDense(numberVector, dArray);
            }
            SparseNumberVector sparseNumberVector = (SparseNumberVector)numberVector;
            int n = this.k;
            int n2 = sparseNumberVector.iter();
            while (sparseNumberVector.iterValid(n2)) {
                int n3 = sparseNumberVector.iterDim(n2);
                double d = sparseNumberVector.iterDoubleValue(n2);
                boolean[] blArray = this.mat[n3];
                for (int i = 0; i < n; ++i) {
                    if (blArray[i]) {
                        int n4 = i;
                        dArray[n4] = dArray[n4] + d;
                        continue;
                    }
                    int n5 = i;
                    dArray[n5] = dArray[n5] - d;
                }
                n2 = sparseNumberVector.iterAdvance(n2);
            }
            return dArray;
        }

        private double[] projectDense(NumberVector numberVector, double[] dArray) {
            int n = this.k;
            double d = MathUtil.min(this.buf.length, numberVector.getDimensionality());
            int n2 = 0;
            while ((double)n2 < d) {
                boolean[] blArray = this.mat[n2];
                double d2 = numberVector.doubleValue(n2);
                for (int i = 0; i < n; ++i) {
                    if (blArray[i]) {
                        int n3 = i;
                        dArray[n3] = dArray[n3] + d2;
                        continue;
                    }
                    int n4 = i;
                    dArray[n4] = dArray[n4] - d2;
                }
                ++n2;
            }
            return dArray;
        }

        @Override
        public int getOutputDimensionality() {
            return this.k;
        }
    }
}

