/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution;

import de.lmu.ifi.dbs.elki.math.random.RandomFactory;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.AbstractDistribution;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import java.util.Random;

public class GeneralizedLogisticAlternateDistribution
extends AbstractDistribution {
    double location;
    double scale;
    double shape;

    public GeneralizedLogisticAlternateDistribution(double d, double d2, double d3) {
        this(d, d2, d3, (Random)null);
    }

    public GeneralizedLogisticAlternateDistribution(double d, double d2, double d3, Random random) {
        super(random);
        this.location = d;
        this.scale = d2;
        this.shape = d3;
        if (!(d3 > -1.0) || !(d3 < 1.0)) {
            throw new ArithmeticException("Invalid shape parameter - must be -1 to +1, is: " + d3);
        }
    }

    public GeneralizedLogisticAlternateDistribution(double d, double d2, double d3, RandomFactory randomFactory) {
        super(randomFactory);
        this.location = d;
        this.scale = d2;
        this.shape = d3;
        if (!(d3 > -1.0) || !(d3 < 1.0)) {
            throw new ArithmeticException("Invalid shape parameter - must be -1 to +1, is: " + d3);
        }
    }

    public static double pdf(double d, double d2, double d3, double d4) {
        d = (d - d2) / d3;
        if (d4 != 0.0) {
            d = -Math.log(1.0 - d4 * d) / d4;
        }
        double d5 = 1.0 + Math.exp(-d);
        return Math.exp(-d * (1.0 - d4)) / (d3 * d5 * d5);
    }

    @Override
    public double pdf(double d) {
        return GeneralizedLogisticAlternateDistribution.pdf(d, this.location, this.scale, this.shape);
    }

    public static double cdf(double d, double d2, double d3, double d4) {
        d = (d - d2) / d3;
        if (d4 != 0.0) {
            double d5 = 1.0 - d4 * d;
            if (d5 < 1.0E-15) {
                return d4 < 0.0 ? 0.0 : 1.0;
            }
            d = -Math.log(d5) / d4;
        }
        return 1.0 / (1.0 + Math.exp(-d));
    }

    @Override
    public double cdf(double d) {
        return GeneralizedLogisticAlternateDistribution.cdf(d, this.location, this.scale, this.shape);
    }

    public static double quantile(double d, double d2, double d3, double d4) {
        if (d4 == 0.0) {
            return d2 - d3 * Math.log((1.0 - d) / d);
        }
        return d2 + d3 * (1.0 - Math.pow((1.0 - d) / d, d4)) / d4;
    }

    @Override
    public double quantile(double d) {
        return GeneralizedLogisticAlternateDistribution.quantile(d, this.location, this.scale, this.shape);
    }

    @Override
    public double nextRandom() {
        double d = this.random.nextDouble();
        return GeneralizedLogisticAlternateDistribution.quantile(d, this.location, this.scale, this.shape);
    }

    @Override
    public String toString() {
        return "GeneralizedLogisticAlternateDistribution(location=" + this.location + ", scale=" + this.scale + ", shape=" + this.shape + ")";
    }

    public static class Parameterizer
    extends AbstractDistribution.Parameterizer {
        double location;
        double scale;
        double shape;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            DoubleParameter doubleParameter;
            DoubleParameter doubleParameter2;
            super.makeOptions(parameterization);
            DoubleParameter doubleParameter3 = new DoubleParameter(LOCATION_ID);
            if (parameterization.grab(doubleParameter3)) {
                this.location = doubleParameter3.doubleValue();
            }
            if (parameterization.grab(doubleParameter2 = new DoubleParameter(SCALE_ID))) {
                this.scale = doubleParameter2.doubleValue();
            }
            if (parameterization.grab(doubleParameter = new DoubleParameter(SHAPE_ID))) {
                this.shape = doubleParameter.doubleValue();
            }
        }

        @Override
        protected GeneralizedLogisticAlternateDistribution makeInstance() {
            return new GeneralizedLogisticAlternateDistribution(this.location, this.scale, this.shape, this.rnd);
        }
    }
}

