/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator;

import de.lmu.ifi.dbs.elki.math.statistics.distribution.GammaDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.WeibullDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.AbstractLMMEstimator;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

public class WeibullLMMEstimator
extends AbstractLMMEstimator<WeibullDistribution> {
    public static final WeibullLMMEstimator STATIC = new WeibullLMMEstimator();

    private WeibullLMMEstimator() {
    }

    @Override
    public int getNumMoments() {
        return 3;
    }

    @Override
    public WeibullDistribution estimateFromLMoments(double[] dArray) {
        double d = dArray[2];
        double d2 = d * d;
        double d3 = d2 * d;
        double d4 = d3 * d;
        double d5 = d4 * d;
        double d6 = d5 * d;
        double d7 = 285.3 * d6 - 658.6 * d5 + 622.8 * d4 - 317.2 * d3 + 98.52 * d2 - 21.256 * d + 3.516;
        double d8 = GammaDistribution.gamma(1.0 + 1.0 / d7);
        double d9 = dArray[1] / (1.0 - Math.pow(2.0, -1.0 / d7) * d8);
        double d10 = dArray[0] - d9 * d8;
        return new WeibullDistribution(d7, d9, d10);
    }

    @Override
    public Class<? super WeibullDistribution> getDistributionClass() {
        return WeibullDistribution.class;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected WeibullLMMEstimator makeInstance() {
            return STATIC;
        }
    }
}

