/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.persistent;

import de.lmu.ifi.dbs.elki.persistent.AbstractPageFileFactory;
import de.lmu.ifi.dbs.elki.persistent.ExternalizablePage;
import de.lmu.ifi.dbs.elki.persistent.OnDiskArrayPageFile;
import de.lmu.ifi.dbs.elki.persistent.PageFile;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.FileParameter;
import java.io.File;

public class OnDiskArrayPageFileFactory<P extends ExternalizablePage>
extends AbstractPageFileFactory<P> {
    private String fileName;

    public OnDiskArrayPageFileFactory(int n, String string) {
        super(n);
        this.fileName = string;
    }

    @Override
    public PageFile<P> newPageFile(Class<P> clazz) {
        if (this.fileName == null) {
            throw new AbortException("Disk-backed page file may only be instantiated once!");
        }
        OnDiskArrayPageFile onDiskArrayPageFile = new OnDiskArrayPageFile(this.pageSize, this.fileName);
        this.fileName = null;
        return onDiskArrayPageFile;
    }

    public static class Parameterizer
    extends AbstractPageFileFactory.Parameterizer<ExternalizablePage> {
        private String fileName;
        public static final OptionID FILE_ID = new OptionID("pagefile.file", "The name of the file storing the page file.");

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            FileParameter fileParameter = new FileParameter(FILE_ID, FileParameter.FileType.OUTPUT_FILE);
            if (parameterization.grab(fileParameter)) {
                this.fileName = ((File)fileParameter.getValue()).getPath();
            }
        }

        @Override
        protected OnDiskArrayPageFileFactory<ExternalizablePage> makeInstance() {
            return new OnDiskArrayPageFileFactory<ExternalizablePage>(this.pageSize, this.fileName);
        }
    }
}

