/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters;

import de.lmu.ifi.dbs.elki.utilities.FormatUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.ParameterException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.WrongParameterValueException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.NumberParameter;

public class IntParameter
extends NumberParameter<IntParameter, Integer> {
    public IntParameter(OptionID optionID, int n) {
        super(optionID, n);
    }

    public IntParameter(OptionID optionID) {
        super(optionID);
    }

    @Override
    public String getValueAsString() {
        return ((Integer)this.getValue()).toString();
    }

    @Override
    protected Integer parseValue(Object object) throws ParameterException {
        if (object instanceof Integer) {
            return (Integer)object;
        }
        try {
            String string = object.toString();
            return (int)FormatUtil.parseLongBase10(string, 0, string.length());
        }
        catch (NullPointerException nullPointerException) {
            throw new WrongParameterValueException("Wrong parameter format! Parameter \"" + this.getName() + "\" requires an integer value, read: " + object + "!\n");
        }
        catch (NumberFormatException numberFormatException) {
            throw new WrongParameterValueException("Wrong parameter format! Parameter \"" + this.getName() + "\" requires an integer value, read: " + object + "!\n");
        }
    }

    @Override
    public String getSyntax() {
        return "<int>";
    }

    public int intValue() {
        return (Integer)this.getValue();
    }
}

