/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.histogram;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.math.scales.LinearScale;
import de.lmu.ifi.dbs.elki.result.ResultUtil;
import de.lmu.ifi.dbs.elki.result.SamplingResult;
import de.lmu.ifi.dbs.elki.utilities.datastructures.histogram.AbstractObjStaticHistogram;
import de.lmu.ifi.dbs.elki.utilities.datastructures.histogram.AbstractStaticHistogram;
import de.lmu.ifi.dbs.elki.utilities.datastructures.histogram.DoubleArrayStaticHistogram;
import de.lmu.ifi.dbs.elki.utilities.exceptions.ObjectNotFoundException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.colors.ColorLibrary;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClassManager;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.projector.HistogramProjector;
import de.lmu.ifi.dbs.elki.visualization.style.ClassStylingPolicy;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.style.StylingPolicy;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPath;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGSimpleLinearAxis;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.AbstractVisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.histogram.AbstractHistogramVisualization;
import java.util.Arrays;
import org.w3c.dom.Element;

public class ColoredHistogramVisualizer
extends AbstractVisFactory {
    private static final String CNAME = "Histograms";
    protected Parameterizer settings;
    private static final int DEFAULT_BINS = 80;

    public ColoredHistogramVisualizer(Parameterizer parameterizer) {
        this.settings = parameterizer;
    }

    @Override
    public Visualization makeVisualization(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
        return new Instance(visualizationTask, visualizationPlot, d, d2, projection);
    }

    @Override
    public void processNewResult(VisualizerContext visualizerContext, Object object) {
        VisualizationTree.findNew(visualizerContext, object, HistogramProjector.class, new VisualizationTree.Handler1<HistogramProjector<?>>(){

            @Override
            public void process(VisualizerContext visualizerContext, HistogramProjector<?> histogramProjector) {
                VisualizationTask visualizationTask = new VisualizationTask(ColoredHistogramVisualizer.CNAME, visualizerContext, histogramProjector, histogramProjector.getRelation(), ColoredHistogramVisualizer.this);
                visualizationTask.level = 100;
                visualizationTask.addUpdateFlags(5);
                visualizerContext.addVis(histogramProjector, visualizationTask);
            }
        });
    }

    @Override
    public boolean allowThumbnails(VisualizationTask visualizationTask) {
        return false;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID STYLE_CURVES_ID = new OptionID("projhistogram.curves", "Use curves instead of the stacked histogram style.");
        public static final OptionID HISTOGRAM_BINS_ID = new OptionID("projhistogram.bins", "Number of bins in the distribution histogram");
        protected boolean curves = false;
        protected int bins = 80;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            Flag flag = new Flag(STYLE_CURVES_ID);
            if (parameterization.grab(flag)) {
                this.curves = flag.isTrue();
            }
            IntParameter intParameter = new IntParameter(HISTOGRAM_BINS_ID, 80);
            intParameter.addConstraint(CommonConstraints.GREATER_THAN_ONE_INT);
            if (parameterization.grab(intParameter)) {
                this.bins = intParameter.intValue();
            }
        }

        @Override
        protected ColoredHistogramVisualizer makeInstance() {
            return new ColoredHistogramVisualizer(this);
        }
    }

    public class Instance<NV extends NumberVector>
    extends AbstractHistogramVisualization {
        public static final String BIN = "bin";
        private Relation<NV> relation;
        private SamplingResult sample;

        public Instance(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
            super(visualizationTask, visualizationPlot, d, d2, projection);
            this.relation = visualizationTask.getRelation();
            this.sample = ResultUtil.getSamplingResult(this.relation);
            this.addListeners();
        }

        @Override
        public void fullRedraw() {
            double d;
            double d2;
            double d32;
            Object object;
            StyleLibrary styleLibrary = this.context.getStyleLibrary();
            double d4 = styleLibrary.getSize("margin");
            this.layer = SVGUtil.svgElement(this.svgp.getDocument(), "g");
            double d5 = 100.0 * this.getWidth() / this.getHeight();
            double d6 = 100.0;
            String string = SVGUtil.makeMarginTransform(this.getWidth(), this.getHeight(), d5, d6, d4);
            SVGUtil.setAtt(this.layer, "transform", string);
            StylingPolicy stylingPolicy = this.context.getStylingPolicy();
            ClassStylingPolicy classStylingPolicy = stylingPolicy instanceof ClassStylingPolicy ? (ClassStylingPolicy)stylingPolicy : null;
            this.setupCSS(this.svgp, classStylingPolicy != null ? classStylingPolicy.getMaxStyle() : 0);
            int n = classStylingPolicy != null ? classStylingPolicy.getMinStyle() : 0;
            int n2 = classStylingPolicy != null ? classStylingPolicy.getMaxStyle() - classStylingPolicy.getMinStyle() : 0;
            DoubleMinMax doubleMinMax = new DoubleMinMax();
            double d7 = 1.0 / (double)this.relation.size();
            int n3 = n2 + 1;
            DoubleArrayStaticHistogram doubleArrayStaticHistogram = new DoubleArrayStaticHistogram(ColoredHistogramVisualizer.this.settings.bins, -0.5, 0.5, n3);
            if (classStylingPolicy != null) {
                for (int i = 0; i < n2; ++i) {
                    object = new double[n3];
                    object[0] = d7;
                    object[i + 1] = d7;
                    DBIDIter dBIDIter = classStylingPolicy.iterateClass(i + n);
                    while (dBIDIter.valid()) {
                        if (this.sample.getSample().contains(dBIDIter)) {
                            try {
                                double d8 = this.proj.fastProjectDataToRenderSpace((NumberVector)this.relation.get(dBIDIter)) * 0.01;
                                doubleArrayStaticHistogram.increment(d8, (double[])object);
                            }
                            catch (ObjectNotFoundException objectNotFoundException) {
                                // empty catch block
                            }
                        }
                        dBIDIter.advance();
                    }
                }
            } else {
                double[] dArray = new double[n3];
                dArray[0] = d7;
                object = this.relation.iterDBIDs();
                while (object.valid()) {
                    double d9 = this.proj.fastProjectDataToRenderSpace((NumberVector)this.relation.get((DBIDRef)object)) * 0.01;
                    doubleArrayStaticHistogram.increment(d9, dArray);
                    object.advance();
                }
            }
            Object object2 = doubleArrayStaticHistogram.iter();
            while (((AbstractStaticHistogram.Iter)object2).valid()) {
                for (double d32 : (Object)((double[])((AbstractObjStaticHistogram.Iter)object2).getValue())) {
                    doubleMinMax.put(d32);
                }
                ((AbstractStaticHistogram.Iter)object2).advance();
            }
            object2 = new LinearScale(0.0, doubleMinMax.getMax());
            object = new LinearScale(doubleArrayStaticHistogram.getCoverMinimum(), doubleArrayStaticHistogram.getCoverMaximum());
            try {
                SVGSimpleLinearAxis.drawAxis(this.svgp, this.layer, (LinearScale)object2, 0.0, d6, 0.0, 0.0, SVGSimpleLinearAxis.LabelStyle.LEFTHAND, styleLibrary);
                int n4 = RelationUtil.dimensionality(this.relation);
                double[] dArray = new double[n4];
                d32 = this.proj.fastProjectScaledToRender(dArray);
                for (int i = 0; i < n4; ++i) {
                    Arrays.fill(dArray, 0.0);
                    dArray[i] = 1.0;
                    d2 = this.proj.fastProjectScaledToRender(dArray);
                    if (!(d2 < d32) && !(d2 > d32)) continue;
                    double d10 = (d32 / 100.0 + 0.5) * d5;
                    d = (d2 / 100.0 + 0.5) * d5;
                    SVGSimpleLinearAxis.drawAxis(this.svgp, this.layer, this.proj.getScale(i), d10, d6, d, d6, SVGSimpleLinearAxis.LabelStyle.RIGHTHAND, styleLibrary);
                }
            }
            catch (CSSClassManager.CSSNamingConflict cSSNamingConflict) {
                LoggingUtil.exception("CSS class exception in axis class.", cSSNamingConflict);
            }
            if (!ColoredHistogramVisualizer.this.settings.curves) {
                AbstractObjStaticHistogram.Iter iter = doubleArrayStaticHistogram.iter();
                while (iter.valid()) {
                    int n5;
                    double d11 = ((LinearScale)object).getScaled(iter.getLeft());
                    double d12 = ((LinearScale)object).getScaled(iter.getRight());
                    d2 = 0.0;
                    for (int i = n5 = n2 > 0 ? 1 : 0; i < n3; ++i) {
                        d = ((LinearScale)object2).getScaled(((double[])iter.getValue())[i]);
                        Element element = SVGUtil.svgRect(this.svgp.getDocument(), d5 * d11, d6 * (1.0 - (d + d2)), d5 * (d12 - d11), d6 * d);
                        d2 += d;
                        SVGUtil.addCSSClass(element, BIN + (n + i - 1));
                        this.layer.appendChild(element);
                    }
                    iter.advance();
                }
            } else {
                double d13;
                d32 = d13 = ((LinearScale)object).getScaled(doubleArrayStaticHistogram.getCoverMinimum());
                SVGPath[] sVGPathArray = new SVGPath[n3];
                double[] dArray = new double[n3];
                for (int i = 0; i < n3; ++i) {
                    sVGPathArray[i] = new SVGPath(d5 * d13, d6 * 1.0);
                    dArray[i] = 0.0;
                }
                AbstractObjStaticHistogram.Iter iter = doubleArrayStaticHistogram.iter();
                while (iter.valid()) {
                    d13 = ((LinearScale)object).getScaled(iter.getLeft());
                    d32 = ((LinearScale)object).getScaled(iter.getRight());
                    for (int i = 0; i < n3; ++i) {
                        double d14 = ((LinearScale)object2).getScaled(((double[])iter.getValue())[i]);
                        if (!(dArray[i] > d14) && !(dArray[i] < d14)) continue;
                        sVGPathArray[i].lineTo(d5 * d13, d6 * (1.0 - dArray[i]));
                        sVGPathArray[i].lineTo(d5 * d13, d6 * (1.0 - d14));
                        sVGPathArray[i].lineTo(d5 * d32, d6 * (1.0 - d14));
                        dArray[i] = d14;
                    }
                    iter.advance();
                }
                for (int i = 0; i < n3; ++i) {
                    if (dArray[i] != 0.0) {
                        sVGPathArray[i].lineTo(d5 * d32, d6 * (1.0 - dArray[i]));
                    }
                    sVGPathArray[i].lineTo(d5 * d32, d6 * 1.0);
                    Element element = sVGPathArray[i].makeElement(this.svgp);
                    SVGUtil.addCSSClass(element, BIN + (n + i - 1));
                    this.layer.appendChild(element);
                }
            }
            this.svgp.updateStyleElement();
        }

        private void setupCSS(SVGPlot sVGPlot, int n) {
            StyleLibrary styleLibrary = this.context.getStyleLibrary();
            ColorLibrary colorLibrary = styleLibrary.getColorSet("plot");
            CSSClass cSSClass = new CSSClass(sVGPlot, "bin-1");
            if (!ColoredHistogramVisualizer.this.settings.curves) {
                cSSClass.setStatement("fill", "black");
                cSSClass.setStatement("fill-opacity", 1.0);
            } else {
                cSSClass.setStatement("stroke", "black");
                cSSClass.setStatement("stroke-width", styleLibrary.getLineWidth("plot"));
                cSSClass.setStatement("fill", "none");
            }
            sVGPlot.addCSSClassOrLogError(cSSClass);
            for (int i = 0; i < n; ++i) {
                CSSClass cSSClass2 = new CSSClass(sVGPlot, BIN + i);
                if (!ColoredHistogramVisualizer.this.settings.curves) {
                    cSSClass2.setStatement("fill", colorLibrary.getColor(i));
                } else {
                    cSSClass2.setStatement("stroke", colorLibrary.getColor(i));
                    cSSClass2.setStatement("stroke-width", styleLibrary.getLineWidth("plot"));
                    cSSClass2.setStatement("fill", "none");
                }
                sVGPlot.addCSSClassOrLogError(cSSClass2);
            }
        }
    }
}

