/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.uncertain;

import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.utilities.datastructures.hierarchy.Hierarchy;
import de.lmu.ifi.dbs.elki.utilities.exceptions.ObjectNotFoundException;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.projector.ScatterPlotProjector;
import de.lmu.ifi.dbs.elki.visualization.style.ClusterStylingPolicy;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.style.StylingPolicy;
import de.lmu.ifi.dbs.elki.visualization.style.marker.MarkerLibrary;
import de.lmu.ifi.dbs.elki.visualization.visualizers.AbstractVisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.AbstractScatterplotVisualization;

public class UncertainInstancesVisualization
extends AbstractVisFactory {
    private static final String NAME = "Uncertain Instance";

    @Override
    public Visualization makeVisualization(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
        return new Instance(visualizationTask, visualizationPlot, d, d2, projection);
    }

    @Override
    public void processNewResult(VisualizerContext visualizerContext, Object object) {
        Hierarchy.Iter<ScatterPlotProjector> iter = VisualizationTree.filter(visualizerContext, object, ScatterPlotProjector.class);
        while (iter.valid()) {
            ScatterPlotProjector scatterPlotProjector = iter.get();
            Relation relation = scatterPlotProjector.getRelation();
            if (TypeUtil.UNCERTAIN_OBJECT_FIELD.isAssignableFromType(relation.getDataTypeInformation())) {
                VisualizationTask visualizationTask = new VisualizationTask(NAME, visualizerContext, scatterPlotProjector, relation, this);
                visualizationTask.level = 100;
                visualizationTask.addUpdateFlags(13);
                visualizerContext.addVis(scatterPlotProjector, visualizationTask);
            }
            iter.advance();
        }
    }

    public class Instance
    extends AbstractScatterplotVisualization {
        public static final String CSS_CLASS = "uncertain-instances";

        public Instance(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
            super(visualizationTask, visualizationPlot, d, d2, projection);
            this.addListeners();
        }

        @Override
        public void fullRedraw() {
            Object object;
            Object object2;
            this.setupCanvas();
            StyleLibrary styleLibrary = this.context.getStyleLibrary();
            StylingPolicy stylingPolicy = this.context.getStylingPolicy();
            double d = styleLibrary.getSize("plot.marker");
            MarkerLibrary markerLibrary = styleLibrary.markers();
            if (!(stylingPolicy instanceof ClusterStylingPolicy)) {
                return;
            }
            ClusterStylingPolicy clusterStylingPolicy = (ClusterStylingPolicy)stylingPolicy;
            Clustering<?> clustering = clusterStylingPolicy.getClustering();
            Hierarchy.Iter<Clustering<?>> iter = this.context.getHierarchy().iterAncestors(clustering);
            Object object3 = null;
            boolean bl = false;
            while (iter.valid()) {
                int n;
                Result result = iter.get();
                if (result == this.rel) {
                    bl = true;
                } else if (result instanceof Relation && TypeUtil.NUMBER_VECTOR_FIELD.isAssignableFromType((TypeInformation)(object2 = ((Relation)result).getDataTypeInformation())) && (n = RelationUtil.dimensionality((Relation<? extends SpatialComparable>)(object = (Relation)result))) == RelationUtil.dimensionality(this.rel)) {
                    object3 = object;
                }
                if (bl && object3 != null) break;
                iter.advance();
            }
            if (!bl || object3 == null) {
                return;
            }
            for (int i = clusterStylingPolicy.getMinStyle(); i < clusterStylingPolicy.getMaxStyle(); ++i) {
                object2 = clusterStylingPolicy.iterateClass(i);
                while (object2.valid()) {
                    if (this.sample.getSample().contains((DBIDRef)object2)) {
                        try {
                            object = (NumberVector)object3.get((DBIDRef)object2);
                            double[] dArray = this.proj.fastProjectDataToRenderSpace((NumberVector)object);
                            if (dArray[0] == dArray[0] && dArray[1] == dArray[1]) {
                                markerLibrary.useMarker(this.svgp, this.layer, dArray[0], dArray[1], i, d);
                            }
                        }
                        catch (ObjectNotFoundException objectNotFoundException) {
                            // empty catch block
                        }
                    }
                    object2.advance();
                }
            }
        }
    }
}

