/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.lof;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.OutlierAlgorithm;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DoubleDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.logging.progress.StepProgress;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.result.outlier.QuotientOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.utilities.DatabaseUtil;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;

@Reference(authors="J. Tang, Z. Chen, A. W. C. Fu, D. W. Cheung", title="Enhancing effectiveness of outlier detections for low density patterns", booktitle="In Advances in Knowledge Discovery and Data Mining", url="http://dx.doi.org/10.1007/3-540-47887-6_53")
public class COF<O>
extends AbstractDistanceBasedAlgorithm<O, OutlierResult>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(COF.class);
    protected int k;

    public COF(int n, DistanceFunction<? super O> distanceFunction) {
        super(distanceFunction);
        this.k = n + 1;
    }

    public OutlierResult run(Database database, Relation<O> relation) {
        StepProgress stepProgress = LOG.isVerbose() ? new StepProgress("COF", 3) : null;
        DistanceQuery<O> distanceQuery = database.getDistanceQuery(relation, this.getDistanceFunction(), new Object[0]);
        LOG.beginStep(stepProgress, 1, "Materializing COF neighborhoods.");
        KNNQuery<O> kNNQuery = DatabaseUtil.precomputedKNNQuery(database, relation, distanceQuery, this.k);
        DBIDs dBIDs = relation.getDBIDs();
        LOG.beginStep(stepProgress, 2, "Computing Average Chaining Distances.");
        WritableDoubleDataStore writableDoubleDataStore = DataStoreUtil.makeDoubleStorage(dBIDs, 3);
        this.computeAverageChainingDistances(kNNQuery, distanceQuery, dBIDs, writableDoubleDataStore);
        LOG.beginStep(stepProgress, 3, "Computing Connectivity-based Outlier Factors.");
        WritableDoubleDataStore writableDoubleDataStore2 = DataStoreUtil.makeDoubleStorage(dBIDs, 30);
        DoubleMinMax doubleMinMax = new DoubleMinMax();
        this.computeCOFScores(kNNQuery, dBIDs, writableDoubleDataStore, writableDoubleDataStore2, doubleMinMax);
        LOG.setCompleted(stepProgress);
        MaterializedDoubleRelation materializedDoubleRelation = new MaterializedDoubleRelation("Connectivity-Based Outlier Factor", "cof-outlier", writableDoubleDataStore2, dBIDs);
        QuotientOutlierScoreMeta quotientOutlierScoreMeta = new QuotientOutlierScoreMeta(doubleMinMax.getMin(), doubleMinMax.getMax(), 0.0, Double.POSITIVE_INFINITY, 1.0);
        return new OutlierResult(quotientOutlierScoreMeta, materializedDoubleRelation);
    }

    protected void computeAverageChainingDistances(KNNQuery<O> kNNQuery, DistanceQuery<O> distanceQuery, DBIDs dBIDs, WritableDoubleDataStore writableDoubleDataStore) {
        FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress("Computing average chaining distances", dBIDs.size(), LOG) : null;
        DBIDIter dBIDIter = dBIDs.iter();
        while (dBIDIter.valid()) {
            KNNList kNNList = kNNQuery.getKNNForDBID(dBIDIter, this.k);
            int n = kNNList.size();
            DoubleDBIDListIter doubleDBIDListIter = kNNList.iter();
            DoubleDBIDListIter doubleDBIDListIter2 = kNNList.iter();
            double[] dArray = new double[n];
            int n2 = 0;
            while (doubleDBIDListIter.valid()) {
                dArray[n2] = DBIDUtil.equal(doubleDBIDListIter, dBIDIter) ? Double.NaN : doubleDBIDListIter.doubleValue();
                doubleDBIDListIter.advance();
                ++n2;
            }
            double d = 0.0;
            for (int i = (n < this.k ? n : this.k) - 1; i > 0; --i) {
                double d2;
                int n3;
                int n4 = -1;
                double d3 = Double.NaN;
                for (n3 = 0; n3 < dArray.length; ++n3) {
                    d2 = dArray[n3];
                    if (d2 != d2 || d2 > d3) continue;
                    n4 = n3;
                    d3 = d2;
                }
                d += d3 * (double)i;
                dArray[n4] = Double.NaN;
                doubleDBIDListIter.seek(n4);
                doubleDBIDListIter2.seek(0);
                n3 = 0;
                while (doubleDBIDListIter2.valid()) {
                    double d4;
                    d2 = dArray[n3];
                    if (d2 == d2 && (d4 = distanceQuery.distance((DBIDRef)doubleDBIDListIter, (DBIDRef)doubleDBIDListIter2)) < d2) {
                        dArray[n3] = d4;
                    }
                    doubleDBIDListIter2.advance();
                    ++n3;
                }
            }
            writableDoubleDataStore.putDouble(dBIDIter, d / ((double)n * 0.5 * ((double)n - 1.0)));
            LOG.incrementProcessed(finiteProgress);
            dBIDIter.advance();
        }
        LOG.ensureCompleted(finiteProgress);
    }

    private void computeCOFScores(KNNQuery<O> kNNQuery, DBIDs dBIDs, DoubleDataStore doubleDataStore, WritableDoubleDataStore writableDoubleDataStore, DoubleMinMax doubleMinMax) {
        FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress("COF for objects", dBIDs.size(), LOG) : null;
        DBIDIter dBIDIter = dBIDs.iter();
        while (dBIDIter.valid()) {
            KNNList kNNList = kNNQuery.getKNNForDBID(dBIDIter, this.k);
            double d = 0.0;
            DoubleDBIDListIter doubleDBIDListIter = kNNList.iter();
            while (doubleDBIDListIter.valid()) {
                if (!DBIDUtil.equal(doubleDBIDListIter, dBIDIter)) {
                    d += doubleDataStore.doubleValue(doubleDBIDListIter);
                }
                doubleDBIDListIter.advance();
            }
            double d2 = d > 0.0 ? doubleDataStore.doubleValue(dBIDIter) * (double)this.k / d : (doubleDataStore.doubleValue(dBIDIter) > 0.0 ? Double.POSITIVE_INFINITY : 1.0);
            writableDoubleDataStore.putDouble(dBIDIter, d2);
            doubleMinMax.put(d2);
            LOG.incrementProcessed(finiteProgress);
            dBIDIter.advance();
        }
        LOG.ensureCompleted(finiteProgress);
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getDistanceFunction().getInputTypeRestriction());
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<O> {
        public static final OptionID K_ID = new OptionID("cof.k", "The number of neighbors (not including the query object) to use for computing the COF score.");
        protected int k;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            IntParameter intParameter = (IntParameter)new IntParameter(K_ID).addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (parameterization.grab(intParameter)) {
                this.k = intParameter.intValue();
            }
        }

        @Override
        protected COF<O> makeInstance() {
            return new COF(this.k, this.distanceFunction);
        }
    }
}

